package com.chenyang.nse.bussiness.tools.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenUtil {
    private static final long EXPIRE_DATE = 7200000L;
    private static final String TOKEN_SECRET = "GHCA";

    /**
     * 生成签名,2小时后过期
     *
     * @param username 用户名
     * @param password 密码
     * @param userId   用户ID
     * @return 加密的token
     */
    public static String getToken(String username, String password, String userId) {
        String token = "";

        try {
            Date date = new Date(System.currentTimeMillis() + EXPIRE_DATE);
            Algorithm algorithm = Algorithm.HMAC256(TOKEN_SECRET);
            Map<String, Object> header = new HashMap<>();
            header.put("typ", "JWT");
            header.put("alg", "HS256");
            token = JWT
                    .create()
                    .withHeader(header)
                    .withSubject(userId)
                    .withClaim("username", username)
                    .withClaim("password", password)
                    .withExpiresAt(date).sign(algorithm);
            return token;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNoDateToken(String username, String password) {
        String token = "";

        try {
            new Date(System.currentTimeMillis() + 7200000L);
            Algorithm algorithm = Algorithm.HMAC256(TOKEN_SECRET);
            Map<String, Object> header = new HashMap<>();
            header.put("typ", "JWT");
            header.put("alg", "HS256");
            token = JWT.create().withHeader(header).withClaim("username", username).withClaim("password", password).sign(algorithm);
            return token;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean verify(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256(TOKEN_SECRET);
            JWTVerifier verifier = JWT.require(algorithm).build();
            verifier.verify(token);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 获取token中的用户ID
     *
     * @return 用户ID
     */
    public static String getUserId() {
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            assert attributes != null;
            HttpServletRequest request = attributes.getRequest();
            String token = request.getHeader("token");
            DecodedJWT jwt = JWT.decode(token);
            return jwt.getSubject();
        } catch (JWTDecodeException var2) {
            return null;
        }
    }

    /**
     * 获取token中的用户名
     *
     * @param token 令牌
     * @return 用户名
     */
    public static String getUserName(String token) {
        try {
            DecodedJWT jwt = JWT.decode(token);
            return jwt.getClaim("username").asString();
        } catch (JWTDecodeException var2) {
            return null;
        }
    }

    /**
     * 获取token中的密码
     *
     * @param token 令牌
     * @return 密码
     */
    public static String getPassword(String token) {
        try {
            DecodedJWT jwt = JWT.decode(token);
            return jwt.getClaim("password").asString();
        } catch (JWTDecodeException var2) {
            return null;
        }
    }
}
