package com.chenyang.nse.bussiness.webtools.json;

public class ResponseObj<T> extends Response {
   private long total;
   private long pages;
   private int pageSize;
   private int pageNum;

   public ResponseObj() {
   }

   public ResponseObj(String code, String description) {
      this.code = code;
      this.msg = description;
   }

   public ResponseObj(String code, String description, T payload) {
      this.code = code;
      this.msg = description;
      this.data = payload;
   }

   public ResponseObj(boolean flag, String code, String description) {
      this.flag = flag;
      this.code = code;
      this.msg = description;
   }

   public ResponseObj(boolean flag, String code, String description, T payload) {
      this.flag = flag;
      this.code = code;
      this.msg = description;
      this.data = payload;
   }

   public void setTotal(long total) {
      this.total = total;
   }

   public long getTotal() {
      return this.total;
   }

   public long getPages() {
      return this.pages;
   }

   public int getPageSize() {
      return this.pageSize;
   }

   public int getPageNum() {
      return this.pageNum;
   }

   public void setPages(final long pages) {
      this.pages = pages;
   }

   public void setPageSize(final int pageSize) {
      this.pageSize = pageSize;
   }

   public void setPageNum(final int pageNum) {
      this.pageNum = pageNum;
   }

   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof ResponseObj)) {
         return false;
      } else {
         ResponseObj<?> other = (ResponseObj)o;
         if (!other.canEqual(this)) {
            return false;
         } else if (this.getTotal() != other.getTotal()) {
            return false;
         } else if (this.getPages() != other.getPages()) {
            return false;
         } else if (this.getPageSize() != other.getPageSize()) {
            return false;
         } else {
            return this.getPageNum() == other.getPageNum();
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof ResponseObj;
   }

   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      long $total = this.getTotal();
      result = result * 59 + (int)($total >>> 32 ^ $total);
      long $pages = this.getPages();
      result = result * 59 + (int)($pages >>> 32 ^ $pages);
      result = result * 59 + this.getPageSize();
      result = result * 59 + this.getPageNum();
      return result;
   }

   public String toString() {
      return "ResponseObj(total=" + this.getTotal() + ", pages=" + this.getPages() + ", pageSize=" + this.getPageSize() + ", pageNum=" + this.getPageNum() + ")";
   }
}
