/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLReplaceStatement
extends SQLStatementImpl {
    protected boolean lowPriority = false;
    protected boolean delayed = false;
    protected SQLExprTableSource tableSource;
    protected final List<SQLExpr> columns = new ArrayList<SQLExpr>();
    protected List<SQLInsertStatement.ValuesClause> valuesList = new ArrayList<SQLInsertStatement.ValuesClause>();
    protected SQLQueryExpr query;
    protected List<SQLCommentHint> hints;
    protected List<SQLAssignItem> partitions;

    public SQLName getTableName() {
        return this.tableSource == null ? null : (SQLName)this.tableSource.getExpr();
    }

    public void setTableName(SQLName tableName) {
        this.setTableSource(new SQLExprTableSource(tableName));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public List<SQLExpr> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLExpr column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public SQLQueryExpr getQuery() {
        return this.query;
    }

    public void setQuery(SQLQueryExpr query) {
        if (query != null) {
            query.setParent(this);
        }
        this.query = query;
    }

    public List<SQLInsertStatement.ValuesClause> getValuesList() {
        return this.valuesList;
    }

    @Override
    public SQLStatement clone() {
        SQLCommentHint clone;
        SQLReplaceStatement x = new SQLReplaceStatement();
        x.setDbType(this.dbType);
        if (this.headHints != null) {
            for (SQLCommentHint h : this.headHints) {
                clone = h.clone();
                clone.setParent(x);
                x.headHints.add(clone);
            }
        }
        if (this.hints != null && !this.hints.isEmpty()) {
            for (SQLCommentHint h : this.hints) {
                clone = h.clone();
                clone.setParent(x);
                x.getHints().add(clone);
            }
        }
        x.lowPriority = this.lowPriority;
        x.delayed = this.delayed;
        if (this.tableSource != null) {
            x.tableSource = this.tableSource.clone();
        }
        for (SQLInsertStatement.ValuesClause clause : this.valuesList) {
            x.getValuesList().add(clause.clone());
        }
        for (SQLExpr column : this.columns) {
            x.addColumn(column.clone());
        }
        if (this.query != null) {
            x.query = this.query.clone();
        }
        if (this.partitions != null) {
            for (SQLAssignItem partition : this.partitions) {
                x.addPartition(partition.clone());
            }
        }
        return x;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.valuesList);
            this.acceptChild(visitor, this.query);
        }
        visitor.endVisit(this);
    }

    public int getHintsSize() {
        return this.hints == null ? 0 : this.hints.size();
    }

    public List<SQLCommentHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLCommentHint>(2);
        }
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public void addPartition(SQLAssignItem partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLAssignItem>();
        }
        this.partitions.add(partition);
    }

    public List<SQLAssignItem> getPartitions() {
        return this.partitions;
    }
}

