/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.ast.SQLArgument;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmStatementImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmExecuteImmediateStatement
extends DmStatementImpl {
    private SQLExpr dynamicSql;
    private final List<SQLArgument> arguments = new ArrayList<SQLArgument>();
    private final List<SQLExpr> into = new ArrayList<SQLExpr>();
    private final List<SQLExpr> returnInto = new ArrayList<SQLExpr>();

    public DmExecuteImmediateStatement() {
    }

    public DmExecuteImmediateStatement(String dynamicSql) {
        this.setDynamicSql(dynamicSql);
    }

    @Override
    public void accept0(DmASTVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public DmExecuteImmediateStatement clone() {
        SQLExpr e2;
        DmExecuteImmediateStatement x = new DmExecuteImmediateStatement();
        if (this.dynamicSql != null) {
            x.setDynamicSql(this.dynamicSql.clone());
        }
        for (SQLArgument arg : this.arguments) {
            SQLArgument a2 = arg.clone();
            a2.setParent(x);
            x.arguments.add(a2);
        }
        for (SQLExpr e : this.into) {
            e2 = e.clone();
            e2.setParent(x);
            x.into.add(e2);
        }
        for (SQLExpr e : this.returnInto) {
            e2 = e.clone();
            e2.setParent(x);
            x.returnInto.add(e2);
        }
        return x;
    }

    public SQLExpr getDynamicSql() {
        return this.dynamicSql;
    }

    public void setDynamicSql(SQLExpr dynamicSql) {
        if (dynamicSql != null) {
            dynamicSql.setParent(this);
        }
        this.dynamicSql = dynamicSql;
    }

    public void setDynamicSql(String dynamicSql) {
        this.setDynamicSql(new SQLCharExpr(dynamicSql));
    }

    public List<SQLArgument> getArguments() {
        return this.arguments;
    }

    public List<SQLExpr> getInto() {
        return this.into;
    }

    public List<SQLExpr> getReturnInto() {
        return this.returnInto;
    }
}

