/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.es.visitor;

import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import com.alibaba.druid.sql.dialect.es.ast.EsParserBaseVisitor;
import com.alibaba.druid.sql.dialect.es.ast.EsParserContextBase;
import com.alibaba.druid.sql.dialect.es.visitor.MappingTree;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class EsSchemaVisitor
extends EsParserBaseVisitor<MappingTree> {
    private MappingTree context;
    private MappingTree current;

    public EsSchemaVisitor(MappingTree context) {
        this.context = context;
        this.current = context;
    }

    @Override
    public MappingTree visitMappingResponse(EsParser.MappingResponseContext ctx) {
        this.visitChildren((RuleNode)ctx);
        return this.context;
    }

    @Override
    public MappingTree visitMappingResponseMapping(EsParser.MappingResponseMappingContext ctx) {
        String name = this.getText(ctx.string());
        MappingTree mapping = this.current.create();
        mapping.setName(name);
        mapping.setType(MappingTree.Type.index);
        this.current = mapping;
        this.visit((ParseTree)ctx.createIndexStatementBody());
        this.current = this.current.getParent();
        return this.context;
    }

    @Override
    public MappingTree visitCreateIndexStatementMappingsType(EsParser.CreateIndexStatementMappingsTypeContext ctx) {
        MappingTree mapping;
        this.current = mapping = this.current.create();
        if (ctx.mappingName != null) {
            this.current.setName(this.getText(ctx.mappingName));
        } else {
            this.current.setName("_doc");
        }
        this.current.setType(MappingTree.Type.mapping);
        this.visitChildren((RuleNode)ctx);
        this.current = this.current.getParent();
        return this.context;
    }

    @Override
    public MappingTree visitDdlMappingPropertiesDefine(EsParser.DdlMappingPropertiesDefineContext ctx) {
        List<EsParser.DdlFieldDeclContext> decls = ctx.ddlFieldDecl();
        if (decls != null && decls.size() > 0) {
            for (EsParser.DdlFieldDeclContext decl : decls) {
                this.visit((ParseTree)decl);
            }
        }
        return this.context;
    }

    @Override
    public MappingTree visitDdlFieldDecl(EsParser.DdlFieldDeclContext ctx) {
        EsParser.DdlFieldContext ddlFieldContext = ctx.ddlField();
        MappingTree field = this.current.create();
        field.setName(this.getText(ctx.fieldName));
        this.current = field;
        if (ddlFieldContext != null) {
            this.visit((ParseTree)ddlFieldContext);
        }
        this.current = this.current.getParent();
        return this.context;
    }

    @Override
    public MappingTree visitDdlFieldType(EsParser.DdlFieldTypeContext ctx) {
        this.current.setDataType(this.getText(ctx.string()));
        return this.context;
    }

    @Override
    public MappingTree visitDdlField(EsParser.DdlFieldContext ctx) {
        List<EsParser.DdlMappingPropertiesDefineContext> subMappings;
        List<EsParser.DdlFieldTypeContext> ddlFieldTypeContexts = ctx.ddlFieldType();
        if (ddlFieldTypeContexts != null && ddlFieldTypeContexts.size() > 0) {
            ddlFieldTypeContexts.get(0).accept(this);
        }
        if ((subMappings = ctx.ddlMappingPropertiesDefine()) != null && subMappings.size() > 0) {
            subMappings.get(0).accept(this);
        }
        return this.context;
    }

    private String getText(EsParserContextBase context) {
        String text = context.getText();
        if (text.length() > 0) {
            try {
                return text.substring(1, text.length() - 1);
            }
            catch (Exception var4) {
                System.out.println(text);
            }
        }
        return text;
    }

    public MappingTree defaultResult() {
        return this.context;
    }
}

