/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.es.visitor;

import com.alibaba.druid.sql.dialect.es.ast.EsLexer;
import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import com.alibaba.druid.sql.dialect.es.visitor.EsSchemaVisitor;
import com.alibaba.druid.sql.dialect.es.visitor.MappingTree;
import com.alibaba.druid.sql.dialect.es.visitor.QueryResponseVisitor;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class EsUtils {
    public static EsParser.StatementContext parse(String uri, String json) {
        String query = uri + "\n" + json;
        return EsUtils.parse(query);
    }

    public static EsParser.StatementContext parse(String query) {
        CodePointCharStream stream = CharStreams.fromString((String)query);
        EsLexer lexer = new EsLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        EsParser parser = new EsParser((TokenStream)tokenStream);
        EsParser.StatementContext statement = parser.statement();
        statement.putAttribute("apiType", parser.apiType);
        statement.putAttribute("stmtType", parser.type);
        return statement;
    }

    public static ParseTree parseMappingBody(String content) {
        CodePointCharStream stream = CharStreams.fromString((String)content);
        EsLexer lexer = new EsLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        EsParser parser = new EsParser((TokenStream)tokenStream);
        return parser.mappingResponse();
    }

    public static MappingTree parseMappingTree(String content) {
        ParseTree context = EsUtils.parseMappingBody(content);
        MappingTree tree = new MappingTree();
        EsSchemaVisitor visitor = new EsSchemaVisitor(tree);
        visitor.visit(context);
        return tree;
    }

    public static EsParser.SearchResponseContext parseSearchResponseBody(String content) {
        CodePointCharStream stream = CharStreams.fromString((String)content);
        EsLexer lexer = new EsLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        EsParser parser = new EsParser((TokenStream)tokenStream);
        return parser.searchResponse();
    }

    public static void parseSearchResponse(String body, QueryResponseVisitor.Visitor visitor) {
        if (body != null && body.length() != 0) {
            EsParser.SearchResponseContext ctx = EsUtils.parseSearchResponseBody(body);
            EsUtils.parseSearchResponse(ctx, visitor);
        }
    }

    public static void parseGetResponse(String body, QueryResponseVisitor.Visitor visitor) {
        if (body != null && body.length() != 0) {
            CodePointCharStream stream = CharStreams.fromString((String)body);
            EsLexer lexer = new EsLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            EsParser parser = new EsParser((TokenStream)tokenStream);
            EsParser.GetResponseContext ctx = parser.getResponse();
            QueryResponseVisitor getResponseVisitor = new QueryResponseVisitor(visitor);
            getResponseVisitor.accept(ctx);
        }
    }

    public static void parseSearchResponse(EsParser.SearchResponseContext ctx, QueryResponseVisitor.Visitor visitor) {
        QueryResponseVisitor searchResponesVisitor = new QueryResponseVisitor(visitor);
        searchResponesVisitor.accept(ctx);
    }
}

