/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbInsertStatement
extends SQLInsertStatement {
    private boolean lowPriority = false;
    private boolean delayed = false;
    private boolean highPriority = false;
    private boolean ignore = false;
    private boolean rollbackOnFail = false;
    private boolean fulltextDictionary = false;
    private boolean overwrite = false;
    private boolean ifNotExists = false;
    protected List<SQLCommentHint> hints;
    private final List<SQLExpr> duplicateKeyUpdate = new ArrayList<SQLExpr>();

    public MariadbInsertStatement() {
        this.dbType = DbType.mysql;
    }

    public void cloneTo(MariadbInsertStatement x) {
        super.cloneTo(x);
        x.lowPriority = this.lowPriority;
        x.delayed = this.delayed;
        x.highPriority = this.highPriority;
        x.ignore = this.ignore;
        x.rollbackOnFail = this.rollbackOnFail;
        x.fulltextDictionary = this.fulltextDictionary;
        x.overwrite = this.overwrite;
        x.ifNotExists = this.ifNotExists;
        for (SQLExpr e : this.duplicateKeyUpdate) {
            SQLExpr e2 = e.clone();
            e2.setParent(x);
            x.duplicateKeyUpdate.add(e2);
        }
    }

    public List<SQLExpr> getDuplicateKeyUpdate() {
        return this.duplicateKeyUpdate;
    }

    public boolean isLowPriority() {
        return this.lowPriority;
    }

    public void setLowPriority(boolean lowPriority) {
        this.lowPriority = lowPriority;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public boolean isHighPriority() {
        return this.highPriority;
    }

    public void setHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isRollbackOnFail() {
        return this.rollbackOnFail;
    }

    public void setRollbackOnFail(boolean rollbackOnFail) {
        this.rollbackOnFail = rollbackOnFail;
    }

    public boolean isFulltextDictionary() {
        return this.fulltextDictionary;
    }

    public void setFulltextDictionary(boolean fulltextDictionary) {
        this.fulltextDictionary = fulltextDictionary;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof MariadbASTVisitor) {
            this.accept0((MariadbASTVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    protected void accept0(MariadbASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.tableSource != null) {
                this.tableSource.accept(visitor);
            }
            if (this.columns != null) {
                for (SQLExpr column : this.columns) {
                    if (column == null) continue;
                    column.accept(visitor);
                }
            }
            if (this.valuesList != null) {
                for (SQLInsertStatement.ValuesClause values : this.valuesList) {
                    if (values == null) continue;
                    values.accept(visitor);
                }
            }
            if (this.query != null) {
                this.query.accept(visitor);
            }
            if (this.duplicateKeyUpdate != null) {
                for (SQLExpr item : this.duplicateKeyUpdate) {
                    if (item == null) continue;
                    item.accept(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }

    public int getHintsSize() {
        return this.hints == null ? 0 : this.hints.size();
    }

    public List<SQLCommentHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> x) {
        if (x != null) {
            for (int i = 0; i < x.size(); ++i) {
                x.get(i).setParent(this);
            }
        }
        this.hints = x;
    }

    @Override
    public SQLInsertStatement clone() {
        MariadbInsertStatement x = new MariadbInsertStatement();
        this.cloneTo(x);
        return x;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

