/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInputOutputFormat;
import com.alibaba.druid.sql.dialect.spark.ast.expr.HiveRowFormat;
import com.alibaba.druid.sql.dialect.spark.ast.statement.SparkCreateTableStatement;
import com.alibaba.druid.sql.dialect.spark.parser.SparkExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class SparkCreateTableParser
extends SQLCreateTableParser {
    public SparkCreateTableParser(String sql) {
        super(new SparkExprParser(sql));
        ((SparkExprParser)this.exprParser).setSparkSqlParser(this);
    }

    public SparkCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        SparkCreateTableStatement stmt = new SparkCreateTableStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals(FnvHash.Constants.IF)) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token()) != Token.IDENTIFIER && token != Token.LITERAL_ALIAS) {
                    if (token != Token.PRIMARY && token != Token.UNIQUE && token != Token.CHECK && token != Token.CONSTRAINT && token != Token.FOREIGN) {
                        if (token == Token.TABLESPACE) {
                            throw new ParserException("TODO " + this.lexer.info());
                        }
                        column = this.exprParser.parseColumn();
                        stmt.getTableElementList().add(column);
                    } else {
                        SQLConstraint constraint = this.exprParser.parseConstaint();
                        constraint.setParent(stmt);
                        stmt.getTableElementList().add((SQLTableElement)((Object)constraint));
                    }
                } else {
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
        }
        block1: while (true) {
            SQLExpr expr;
            if (this.lexer.token() != Token.USING) {
                SQLExpr comment;
                if (this.lexer.identifierEquals(FnvHash.Constants.OPTIONS)) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(stmt.getTableOptions(), stmt, false);
                    this.accept(Token.RPAREN);
                    continue;
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    comment = this.exprParser.expr();
                    stmt.setComment(comment);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.MAPPED)) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    this.exprParser.parseAssignItem(stmt.getMappedBy(), stmt);
                    continue;
                }
                if (this.lexer.token() == Token.PARTITIONED) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    this.accept(Token.LPAREN);
                    while (this.lexer.token() == Token.IDENTIFIER) {
                        SQLColumnDefinition column = this.exprParser.parseColumn();
                        stmt.addPartitionColumn(column);
                        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                            column.addAfterComment(this.lexer.readAndResetComments());
                        }
                        if (this.lexer.token() != Token.COMMA) {
                            this.accept(Token.RPAREN);
                            continue block1;
                        }
                        this.lexer.nextToken();
                        if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                        column.addAfterComment(this.lexer.readAndResetComments());
                    }
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                        stmt.addClusteredByItem(item);
                        if (this.lexer.token() != Token.COMMA) {
                            this.accept(Token.RPAREN);
                            continue block1;
                        }
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.SKEWED)) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    this.accept(Token.LPAREN);
                    this.exprParser.exprList(stmt.getSkewedBy(), stmt);
                    this.accept(Token.RPAREN);
                    this.accept(Token.ON);
                    this.accept(Token.LPAREN);
                    while (true) {
                        if (this.lexer.token() == Token.LPAREN) {
                            SQLListExpr list = new SQLListExpr();
                            this.lexer.nextToken();
                            this.exprParser.exprList(list.getItems(), list);
                            this.accept(Token.RPAREN);
                            stmt.addSkewedByOn(list);
                        } else {
                            expr = this.exprParser.expr();
                            stmt.addSkewedByOn(expr);
                        }
                        if (this.lexer.token() != Token.COMMA) {
                            this.accept(Token.RPAREN);
                            continue block1;
                        }
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
                    this.parseSortedBy(stmt);
                    continue;
                }
                if (this.lexer.token() != Token.ROW && !this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                    SQLSelect select;
                    if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
                        this.parseSortedBy(stmt);
                        continue;
                    }
                    if ((stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) && this.lexer.token() == Token.INTO) {
                        this.accept(Token.INTO);
                        if (this.lexer.token() != Token.LITERAL_INT) {
                            throw new ParserException("into buckets must be integer. " + this.lexer.info());
                        }
                        stmt.setBuckets(this.lexer.integerValue().intValue());
                        this.lexer.nextToken();
                        this.acceptIdentifier("BUCKETS");
                        if (this.lexer.token() != Token.LPAREN) continue;
                        this.lexer.nextToken();
                        select = this.createSQLSelectParser().select();
                        stmt.setBucketSelect(select);
                        this.accept(Token.RPAREN);
                        continue;
                    }
                    if (this.lexer.token() != Token.ROW && !this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
                        Object name;
                        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
                            this.lexer.nextToken();
                            this.accept(Token.AS);
                            if (this.lexer.identifierEquals(FnvHash.Constants.INPUTFORMAT)) {
                                HiveInputOutputFormat format = new HiveInputOutputFormat();
                                this.lexer.nextToken();
                                format.setInput(this.exprParser.primary());
                                if (this.lexer.identifierEquals(FnvHash.Constants.OUTPUTFORMAT)) {
                                    this.lexer.nextToken();
                                    format.setOutput(this.exprParser.primary());
                                }
                                stmt.setStoredAs(format);
                                continue;
                            }
                            name = this.exprParser.name();
                            stmt.setStoredAs((SQLExpr)name);
                            continue;
                        }
                        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                            this.lexer.nextToken();
                            SQLExpr location = this.exprParser.expr();
                            stmt.setLocation(location);
                            continue;
                        }
                        if (!this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                            if (this.lexer.identifierEquals(FnvHash.Constants.META)) {
                                this.lexer.nextToken();
                                this.acceptIdentifier("LIFECYCLE");
                                stmt.setMetaLifeCycle(this.exprParser.primary());
                                continue;
                            }
                            if (this.lexer.token() == Token.LIKE) {
                                this.lexer.nextToken();
                                name = this.exprParser.name();
                                stmt.setLike((SQLName)name);
                                continue;
                            }
                            if (this.lexer.token() != Token.COMMENT) {
                                if (this.lexer.token() == Token.AS) {
                                    this.lexer.nextToken();
                                    select = this.createSQLSelectParser().select();
                                    stmt.setSelect(select);
                                }
                                return stmt;
                            }
                            this.lexer.nextToken();
                            comment = this.exprParser.expr();
                            stmt.setComment(comment);
                            continue;
                        }
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        do {
                            name = this.lexer.stringVal();
                            this.lexer.nextToken();
                            this.accept(Token.EQ);
                            SQLExpr value = this.exprParser.primary();
                            stmt.addTblProperty((String)name, value);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        } while (this.lexer.token() != Token.RPAREN);
                        this.accept(Token.RPAREN);
                        continue;
                    }
                    this.parseRowFormat(stmt);
                    continue;
                }
                this.parseRowFormat(stmt);
                continue;
            }
            this.lexer.nextToken();
            expr = this.exprParser.name();
            stmt.setDatasource(expr);
        }
    }

    private void parseRowFormat(SparkCreateTableStatement stmt) {
        HiveRowFormat format = ((SparkExprParser)this.getExprParser()).parseHiveRowFormat();
        stmt.setHiveFormat(format);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("SERDEPROPERTIES");
            this.accept(Token.LPAREN);
            while (true) {
                String name = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.EQ);
                SQLExpr value = this.exprParser.primary();
                stmt.getSerdeProperties().put(name, value);
                if (this.lexer.token() != Token.COMMA) {
                    this.accept(Token.RPAREN);
                    break;
                }
                this.lexer.nextToken();
            }
        }
    }

    private void parseSortedBy(SparkCreateTableStatement stmt) {
        this.lexer.nextToken();
        this.accept(Token.BY);
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.addSortedByItem(item);
            if (this.lexer.token() != Token.COMMA) {
                this.accept(Token.RPAREN);
                return;
            }
            this.lexer.nextToken();
        }
    }
}

