/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlEvalVisitorImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorImpl;
import com.alibaba.druid.sql.visitor.functions.Ascii;
import com.alibaba.druid.sql.visitor.functions.Bin;
import com.alibaba.druid.sql.visitor.functions.BitLength;
import com.alibaba.druid.sql.visitor.functions.Char;
import com.alibaba.druid.sql.visitor.functions.Concat;
import com.alibaba.druid.sql.visitor.functions.DateAdd;
import com.alibaba.druid.sql.visitor.functions.Elt;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.alibaba.druid.sql.visitor.functions.Greatest;
import com.alibaba.druid.sql.visitor.functions.Hex;
import com.alibaba.druid.sql.visitor.functions.If;
import com.alibaba.druid.sql.visitor.functions.Insert;
import com.alibaba.druid.sql.visitor.functions.Instr;
import com.alibaba.druid.sql.visitor.functions.Isnull;
import com.alibaba.druid.sql.visitor.functions.Lcase;
import com.alibaba.druid.sql.visitor.functions.Least;
import com.alibaba.druid.sql.visitor.functions.Left;
import com.alibaba.druid.sql.visitor.functions.Length;
import com.alibaba.druid.sql.visitor.functions.Locate;
import com.alibaba.druid.sql.visitor.functions.Lpad;
import com.alibaba.druid.sql.visitor.functions.Ltrim;
import com.alibaba.druid.sql.visitor.functions.Now;
import com.alibaba.druid.sql.visitor.functions.OneParamFunctions;
import com.alibaba.druid.sql.visitor.functions.Reverse;
import com.alibaba.druid.sql.visitor.functions.Right;
import com.alibaba.druid.sql.visitor.functions.Substring;
import com.alibaba.druid.sql.visitor.functions.ToChar;
import com.alibaba.druid.sql.visitor.functions.ToDate;
import com.alibaba.druid.sql.visitor.functions.Trim;
import com.alibaba.druid.sql.visitor.functions.Ucase;
import com.alibaba.druid.sql.visitor.functions.Unhex;
import com.alibaba.druid.util.HexBin;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SQLEvalVisitorUtils {
    private static Map<String, Function> functions = new HashMap<String, Function>();

    public static Object evalExpr(DbType dbType, String expr, Object ... parameters) {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr(expr, dbType);
        return SQLEvalVisitorUtils.eval(dbType, (SQLObject)sqlExpr, parameters);
    }

    public static Object evalExpr(DbType dbType, String expr, List<Object> parameters) {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr(expr);
        return SQLEvalVisitorUtils.eval(dbType, (SQLObject)sqlExpr, parameters);
    }

    public static Object eval(DbType dbType, SQLObject sqlObject, Object ... parameters) {
        Object value = SQLEvalVisitorUtils.eval(dbType, sqlObject, Arrays.asList(parameters));
        if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
            value = null;
        }
        return value;
    }

    public static Object getValue(SQLObject sqlObject) {
        return sqlObject instanceof SQLNumericLiteralExpr ? ((SQLNumericLiteralExpr)sqlObject).getNumber() : sqlObject.getAttribute("eval.value");
    }

    public static Object eval(DbType dbType, SQLObject sqlObject, List<Object> parameters) {
        return SQLEvalVisitorUtils.eval(dbType, sqlObject, parameters, true);
    }

    public static Object eval(DbType dbType, SQLObject sqlObject, List<Object> parameters, boolean throwError) {
        Object value;
        SQLEvalVisitor visitor = SQLEvalVisitorUtils.createEvalVisitor(dbType);
        visitor.setParameters(parameters);
        if (sqlObject instanceof SQLValuableExpr) {
            value = ((SQLValuableExpr)sqlObject).getValue();
        } else {
            sqlObject.accept(visitor);
            value = SQLEvalVisitorUtils.getValue(sqlObject);
            if (value == null && throwError && !sqlObject.containsAttribute("eval.value")) {
                throw new FastsqlException("eval error : " + SQLUtils.toSQLString(sqlObject, dbType));
            }
        }
        return value;
    }

    public static SQLEvalVisitor createEvalVisitor(DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case mysql: 
            case mariadb: 
            case h2: {
                return new MySqlEvalVisitorImpl();
            }
            case oracle: {
                return new OracleEvalVisitor();
            }
        }
        return new SQLEvalVisitorImpl();
    }

    static void registerBaseFunctions() {
        functions.put("now", Now.instance);
        functions.put("concat", Concat.instance);
        functions.put("concat_ws", Concat.instance);
        functions.put("ascii", Ascii.instance);
        functions.put("bin", Bin.instance);
        functions.put("bit_length", BitLength.instance);
        functions.put("insert", Insert.instance);
        functions.put("instr", Instr.instance);
        functions.put("char", Char.instance);
        functions.put("elt", Elt.instance);
        functions.put("left", Left.instance);
        functions.put("locate", Locate.instance);
        functions.put("lpad", Lpad.instance);
        functions.put("ltrim", Ltrim.instance);
        functions.put("mid", Substring.instance);
        functions.put("substr", Substring.instance);
        functions.put("substring", Substring.instance);
        functions.put("right", Right.instance);
        functions.put("reverse", Reverse.instance);
        functions.put("len", Length.instance);
        functions.put("length", Length.instance);
        functions.put("char_length", Length.instance);
        functions.put("character_length", Length.instance);
        functions.put("trim", Trim.instance);
        functions.put("ucase", Ucase.instance);
        functions.put("upper", Ucase.instance);
        functions.put("lcase", Lcase.instance);
        functions.put("lower", Lcase.instance);
        functions.put("hex", Hex.instance);
        functions.put("unhex", Unhex.instance);
        functions.put("greatest", Greatest.instance);
        functions.put("least", Least.instance);
        functions.put("isnull", Isnull.instance);
        functions.put("if", If.instance);
        functions.put("to_date", ToDate.instance);
        functions.put("to_char", ToChar.instance);
        functions.put("dateadd", DateAdd.instance);
        functions.put("md5", OneParamFunctions.instance);
        functions.put("bit_count", OneParamFunctions.instance);
        functions.put("soundex", OneParamFunctions.instance);
        functions.put("space", OneParamFunctions.instance);
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        String methodName = x.getMethodName().toLowerCase();
        Function function = visitor.getFunction(methodName);
        if (function == null) {
            function = functions.get(methodName);
        }
        if (function != null) {
            Object result = function.eval(visitor, x);
            if (result != SQLEvalVisitor.EVAL_ERROR && result != null) {
                x.putAttribute("eval.value", result);
            }
            return false;
        }
        if ("mod".equals(methodName)) {
            long intValue1;
            if (x.getArguments().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            SQLExpr param1 = x.getArguments().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            long intValue0 = SQLEvalVisitorUtils.castToLong(param0Value);
            long result = intValue0 % (intValue1 = SQLEvalVisitorUtils.castToLong(param1Value).longValue());
            if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
                int intResult = (int)result;
                x.putAttribute("eval.value", intResult);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("abs".equals(methodName)) {
            if (x.getArguments().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            Number result = paramValue instanceof Integer ? (Number)Math.abs((Integer)paramValue) : (Number)(paramValue instanceof Long ? Long.valueOf(Math.abs((Long)paramValue)) : SQLEvalVisitorUtils.castToDecimal(paramValue).abs());
            x.putAttribute("eval.value", result);
        } else if ("acos".equals(methodName)) {
            if (x.getArguments().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
            double result = Math.acos(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("asin".equals(methodName)) {
            if (x.getArguments().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
            double result = Math.asin(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("atan".equals(methodName)) {
            if (x.getArguments().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
            double result = Math.atan(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if ("atan2".equals(methodName)) {
            double doubleValue1;
            if (x.getArguments().size() != 2) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            SQLExpr param1 = x.getArguments().get(1);
            param0.accept(visitor);
            param1.accept(visitor);
            Object param0Value = param0.getAttributes().get("eval.value");
            Object param1Value = param1.getAttributes().get("eval.value");
            if (param0Value == null || param1Value == null) {
                return false;
            }
            double doubleValue0 = SQLEvalVisitorUtils.castToDouble(param0Value);
            double result = Math.atan2(doubleValue0, doubleValue1 = SQLEvalVisitorUtils.castToDouble(param1Value).doubleValue());
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        } else if (!"ceil".equals(methodName) && !"ceiling".equals(methodName)) {
            if ("cos".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.cos(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if ("sin".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.sin(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if ("log".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.log(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if ("log10".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.log10(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if ("tan".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.tan(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if ("sqrt".equals(methodName)) {
                if (x.getArguments().size() != 1) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                param0.accept(visitor);
                Object paramValue = param0.getAttributes().get("eval.value");
                if (paramValue == null) {
                    return false;
                }
                double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
                double result = Math.sqrt(doubleValue);
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            } else if (!"power".equals(methodName) && !"pow".equals(methodName)) {
                if ("pi".equals(methodName)) {
                    x.putAttribute("eval.value", Math.PI);
                } else if ("rand".equals(methodName)) {
                    x.putAttribute("eval.value", Math.random());
                } else if ("chr".equals(methodName) && x.getArguments().size() == 1) {
                    SQLExpr first = x.getArguments().get(0);
                    Object firstResult = SQLEvalVisitorUtils.getValue(first);
                    if (firstResult instanceof Number) {
                        int intValue = ((Number)firstResult).intValue();
                        char ch = (char)intValue;
                        x.putAttribute("eval.value", Character.toString(ch));
                    }
                } else if ("current_user".equals(methodName)) {
                    x.putAttribute("eval.value", "CURRENT_USER");
                }
            } else {
                double doubleValue1;
                if (x.getArguments().size() != 2) {
                    return false;
                }
                SQLExpr param0 = x.getArguments().get(0);
                SQLExpr param1 = x.getArguments().get(1);
                param0.accept(visitor);
                param1.accept(visitor);
                Object param0Value = param0.getAttributes().get("eval.value");
                Object param1Value = param1.getAttributes().get("eval.value");
                if (param0Value == null || param1Value == null) {
                    return false;
                }
                double doubleValue0 = SQLEvalVisitorUtils.castToDouble(param0Value);
                double result = Math.pow(doubleValue0, doubleValue1 = SQLEvalVisitorUtils.castToDouble(param1Value).doubleValue());
                if (Double.isNaN(result)) {
                    x.putAttribute("eval.value", null);
                } else {
                    x.putAttribute("eval.value", result);
                }
            }
        } else {
            if (x.getArguments().size() != 1) {
                return false;
            }
            SQLExpr param0 = x.getArguments().get(0);
            param0.accept(visitor);
            Object paramValue = param0.getAttributes().get("eval.value");
            if (paramValue == null) {
                return false;
            }
            double doubleValue = SQLEvalVisitorUtils.castToDouble(paramValue);
            int result = (int)Math.ceil(doubleValue);
            if (Double.isNaN(result)) {
                x.putAttribute("eval.value", null);
            } else {
                x.putAttribute("eval.value", result);
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLCharExpr x) {
        x.putAttribute("eval.value", x.getText());
        return true;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLHexExpr x) {
        String hex = x.getHex();
        byte[] bytes = HexBin.decode(hex);
        if (bytes == null) {
            x.putAttribute("eval.value", SQLEvalVisitor.EVAL_ERROR);
        } else {
            String val = new String(bytes);
            x.putAttribute("eval.value", val);
        }
        return true;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLBinaryExpr x) {
        Number val;
        String text = x.getText();
        long[] words = new long[text.length() / 64 + 1];
        for (int i = text.length() - 1; i >= 0; --i) {
            int wordIndex;
            char ch = text.charAt(i);
            if (ch != '1') continue;
            int n = wordIndex = i >> 6;
            words[n] = words[n] | 1L << text.length() - 1 - i;
        }
        if (words.length == 1) {
            val = words[0];
        } else {
            byte[] bytes = new byte[words.length * 8];
            for (int i = 0; i < words.length; ++i) {
                Utils.putLong(bytes, (words.length - 1 - i) * 8, words[i]);
            }
            val = new BigInteger(bytes);
        }
        x.putAttribute("eval.value", val);
        return false;
    }

    public static SQLExpr unwrap(SQLExpr expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof SQLQueryExpr) {
            SQLSelectQueryBlock queryBlock;
            SQLSelect select = ((SQLQueryExpr)expr).getSubQuery();
            if (select == null) {
                return null;
            }
            if (select.getQuery() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)select.getQuery()).getFrom() == null && queryBlock.getSelectList().size() == 1) {
                return queryBlock.getSelectList().get(0).getExpr();
            }
        }
        return expr;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLBetweenExpr x) {
        SQLExpr testExpr = SQLEvalVisitorUtils.unwrap(x.getTestExpr());
        testExpr.accept(visitor);
        if (!testExpr.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object value = testExpr.getAttribute("eval.value");
        SQLExpr beginExpr = SQLEvalVisitorUtils.unwrap(x.getBeginExpr());
        beginExpr.accept(visitor);
        if (!beginExpr.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object begin = beginExpr.getAttribute("eval.value");
        if (SQLEvalVisitorUtils.lt(value, begin)) {
            x.getAttributes().put("eval.value", x.isNot());
            return false;
        }
        SQLExpr endExpr = SQLEvalVisitorUtils.unwrap(x.getEndExpr());
        endExpr.accept(visitor);
        if (!endExpr.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object end = endExpr.getAttribute("eval.value");
        if (SQLEvalVisitorUtils.gt(value, end)) {
            x.getAttributes().put("eval.value", x.isNot());
            return false;
        }
        x.getAttributes().put("eval.value", !x.isNot());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLNullExpr x) {
        x.getAttributes().put("eval.value", SQLEvalVisitor.EVAL_VALUE_NULL);
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLCaseExpr x) {
        Object value;
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(visitor);
            if (!x.getValueExpr().getAttributes().containsKey("eval.value")) {
                return false;
            }
            value = x.getValueExpr().getAttribute("eval.value");
        } else {
            value = null;
        }
        for (SQLCaseExpr.Item item : x.getItems()) {
            item.getConditionExpr().accept(visitor);
            if (!item.getConditionExpr().getAttributes().containsKey("eval.value")) {
                return false;
            }
            Object conditionValue = item.getConditionExpr().getAttribute("eval.value");
            if ((x.getValueExpr() == null || !SQLEvalVisitorUtils.eq(value, conditionValue)) && (x.getValueExpr() != null || !(conditionValue instanceof Boolean) || (Boolean)conditionValue != Boolean.TRUE)) continue;
            item.getValueExpr().accept(visitor);
            if (item.getValueExpr().getAttributes().containsKey("eval.value")) {
                x.getAttributes().put("eval.value", item.getValueExpr().getAttribute("eval.value"));
            }
            return false;
        }
        if (x.getElseExpr() != null) {
            x.getElseExpr().accept(visitor);
            if (x.getElseExpr().getAttributes().containsKey("eval.value")) {
                x.getAttributes().put("eval.value", x.getElseExpr().getAttribute("eval.value"));
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLInListExpr x) {
        SQLExpr valueExpr = x.getExpr();
        valueExpr.accept(visitor);
        if (!valueExpr.getAttributes().containsKey("eval.value")) {
            return false;
        }
        Object value = valueExpr.getAttribute("eval.value");
        for (SQLExpr item : x.getTargetList()) {
            item.accept(visitor);
            if (!item.getAttributes().containsKey("eval.value")) {
                return false;
            }
            Object itemValue = item.getAttribute("eval.value");
            if (!SQLEvalVisitorUtils.eq(value, itemValue)) continue;
            x.getAttributes().put("eval.value", !x.isNot());
            return false;
        }
        x.getAttributes().put("eval.value", x.isNot());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLQueryExpr x) {
        if (WallVisitorUtils.isSimpleCountTableSource((WallVisitor)null, x.getSubQuery())) {
            x.putAttribute("eval.value", 1);
            return false;
        }
        if (x.getSubQuery().getQuery() instanceof SQLSelectQueryBlock) {
            SQLExpr expr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)x.getSubQuery().getQuery();
            boolean nullFrom = false;
            if (queryBlock.getFrom() == null) {
                nullFrom = true;
            } else if (queryBlock.getFrom() instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)queryBlock.getFrom()).getExpr()) instanceof SQLIdentifierExpr && "dual".equalsIgnoreCase(((SQLIdentifierExpr)expr).getName())) {
                nullFrom = true;
            }
            if (nullFrom) {
                ArrayList<Object> row = new ArrayList<Object>(queryBlock.getSelectList().size());
                for (int i = 0; i < queryBlock.getSelectList().size(); ++i) {
                    SQLSelectItem item = queryBlock.getSelectList().get(i);
                    item.getExpr().accept(visitor);
                    Object cell = item.getExpr().getAttribute("eval.value");
                    row.add(cell);
                }
                ArrayList<ArrayList<Object>> rows = new ArrayList<ArrayList<Object>>(1);
                rows.add(row);
                queryBlock.putAttribute("eval.value", rows);
                x.getSubQuery().putAttribute("eval.value", rows);
                x.putAttribute("eval.value", rows);
                return false;
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLUnaryExpr x) {
        WallVisitorUtils.WallConditionContext wallConditionContext = WallVisitorUtils.getWallConditionContext();
        if (x.getOperator() == SQLUnaryOperator.Compl && wallConditionContext != null) {
            wallConditionContext.setBitwise(true);
        }
        x.getExpr().accept(visitor);
        Object val = x.getExpr().getAttribute("eval.value");
        if (val == SQLEvalVisitor.EVAL_ERROR) {
            x.putAttribute("eval.value", SQLEvalVisitor.EVAL_ERROR);
            return false;
        }
        if (val == null) {
            x.putAttribute("eval.value", SQLEvalVisitor.EVAL_VALUE_NULL);
            return false;
        }
        switch (x.getOperator()) {
            case BINARY: 
            case RAW: {
                x.putAttribute("eval.value", val);
                break;
            }
            case NOT: 
            case Not: {
                Boolean booleanVal = SQLEvalVisitorUtils.castToBoolean(val);
                if (booleanVal == null) break;
                x.putAttribute("eval.value", booleanVal == false);
                break;
            }
            case Plus: {
                x.putAttribute("eval.value", val);
                break;
            }
            case Negative: {
                x.putAttribute("eval.value", SQLEvalVisitorUtils.multi(val, -1));
                break;
            }
            case Compl: {
                x.putAttribute("eval.value", ~SQLEvalVisitorUtils.castToInteger(val).intValue());
            }
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLBinaryOpExpr x) {
        SQLExpr left = SQLEvalVisitorUtils.unwrap(x.getLeft());
        SQLExpr right = SQLEvalVisitorUtils.unwrap(x.getRight());
        left.accept(visitor);
        right.accept(visitor);
        WallVisitorUtils.WallConditionContext wallConditionContext = WallVisitorUtils.getWallConditionContext();
        if (x.getOperator() == SQLBinaryOperator.BooleanOr) {
            if (wallConditionContext != null && (left.getAttribute("eval.value") == Boolean.TRUE || right.getAttribute("eval.value") == Boolean.TRUE)) {
                wallConditionContext.setPartAlwayTrue(true);
            }
        } else if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            if (wallConditionContext != null && (left.getAttribute("eval.value") == Boolean.FALSE || right.getAttribute("eval.value") == Boolean.FALSE)) {
                wallConditionContext.setPartAlwayFalse(true);
            }
        } else if (x.getOperator() == SQLBinaryOperator.BooleanXor) {
            if (wallConditionContext != null) {
                wallConditionContext.setXor(true);
            }
        } else if ((x.getOperator() == SQLBinaryOperator.BitwiseAnd || x.getOperator() == SQLBinaryOperator.BitwiseNot || x.getOperator() == SQLBinaryOperator.BitwiseOr || x.getOperator() == SQLBinaryOperator.BitwiseXor) && wallConditionContext != null) {
            wallConditionContext.setBitwise(true);
        }
        Object leftValue = left.getAttribute("eval.value");
        Object rightValue = right.getAttributes().get("eval.value");
        if (x.getOperator() == SQLBinaryOperator.Like && SQLEvalVisitorUtils.isAlwayTrueLikePattern(x.getRight())) {
            x.putAttribute("hasTrueLike", Boolean.TRUE);
            x.putAttribute("eval.value", Boolean.TRUE);
            return false;
        }
        if (x.getOperator() == SQLBinaryOperator.NotLike && SQLEvalVisitorUtils.isAlwayTrueLikePattern(x.getRight())) {
            x.putAttribute("eval.value", Boolean.FALSE);
            return false;
        }
        boolean leftHasValue = left.getAttributes().containsKey("eval.value");
        boolean rightHasValue = right.getAttributes().containsKey("eval.value");
        if (!leftHasValue && !rightHasValue) {
            SQLExpr leftEvalExpr = (SQLExpr)left.getAttribute("eval.expr");
            SQLExpr rightEvalExpr = (SQLExpr)right.getAttribute("eval.expr");
            if (leftEvalExpr != null && leftEvalExpr.equals(rightEvalExpr)) {
                switch (x.getOperator()) {
                    case Like: 
                    case SoudsLike: 
                    case Equality: 
                    case GreaterThanOrEqual: 
                    case LessThanOrEqual: 
                    case NotLessThan: 
                    case NotGreaterThan: {
                        x.putAttribute("eval.value", Boolean.TRUE);
                        return false;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: 
                    case NotLike: 
                    case GreaterThan: 
                    case LessThan: {
                        x.putAttribute("eval.value", Boolean.FALSE);
                        return false;
                    }
                }
            }
        }
        if (!leftHasValue) {
            return false;
        }
        if (!rightHasValue) {
            return false;
        }
        if (wallConditionContext != null) {
            wallConditionContext.setConstArithmetic(true);
        }
        leftValue = SQLEvalVisitorUtils.processValue(leftValue);
        rightValue = SQLEvalVisitorUtils.processValue(rightValue);
        if (leftValue != null && rightValue != null) {
            Object value = null;
            switch (x.getOperator()) {
                case Like: {
                    String pattern = SQLEvalVisitorUtils.castToString(rightValue);
                    String input = SQLEvalVisitorUtils.castToString(left.getAttributes().get("eval.value"));
                    boolean matchResult = SQLEvalVisitorUtils.like(input, pattern);
                    x.putAttribute("eval.value", matchResult);
                }
                default: {
                    break;
                }
                case Equality: {
                    Boolean var29 = SQLEvalVisitorUtils.eq(leftValue, rightValue);
                    x.putAttribute("eval.value", var29);
                    break;
                }
                case GreaterThanOrEqual: {
                    Boolean var28 = SQLEvalVisitorUtils.gteq(leftValue, rightValue);
                    x.putAttribute("eval.value", var28);
                    break;
                }
                case LessThanOrEqual: {
                    Boolean var27 = SQLEvalVisitorUtils.lteq(leftValue, rightValue);
                    x.putAttribute("eval.value", var27);
                    break;
                }
                case NotEqual: 
                case LessThanOrGreater: {
                    Boolean var26 = !SQLEvalVisitorUtils.eq(leftValue, rightValue);
                    x.putAttribute("eval.value", var26);
                    break;
                }
                case NotLike: {
                    String pattern2 = SQLEvalVisitorUtils.castToString(rightValue);
                    String input2 = SQLEvalVisitorUtils.castToString(left.getAttributes().get("eval.value"));
                    boolean matchResult2 = !SQLEvalVisitorUtils.like(input2, pattern2);
                    x.putAttribute("eval.value", matchResult2);
                    break;
                }
                case GreaterThan: {
                    Boolean var25 = SQLEvalVisitorUtils.gt(leftValue, rightValue);
                    x.putAttribute("eval.value", var25);
                    break;
                }
                case LessThan: {
                    Boolean var24 = SQLEvalVisitorUtils.lt(leftValue, rightValue);
                    x.putAttribute("eval.value", var24);
                    break;
                }
                case Add: {
                    value = SQLEvalVisitorUtils.add(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case Subtract: {
                    value = SQLEvalVisitorUtils.sub(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case Multiply: {
                    value = SQLEvalVisitorUtils.multi(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case Divide: {
                    value = SQLEvalVisitorUtils.div(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case RightShift: {
                    value = SQLEvalVisitorUtils.rightShift(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case BitwiseAnd: {
                    value = SQLEvalVisitorUtils.bitAnd(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case BitwiseOr: {
                    value = SQLEvalVisitorUtils.bitOr(leftValue, rightValue);
                    x.putAttribute("eval.value", value);
                    break;
                }
                case Is: {
                    if (rightValue != SQLEvalVisitor.EVAL_VALUE_NULL || leftValue == null) break;
                    Boolean var16 = leftValue == SQLEvalVisitor.EVAL_VALUE_NULL;
                    x.putAttribute("eval.value", var16);
                    break;
                }
                case IsNot: {
                    if (leftValue == SQLEvalVisitor.EVAL_VALUE_NULL) {
                        x.putAttribute("eval.value", false);
                        break;
                    }
                    if (leftValue == null) break;
                    x.putAttribute("eval.value", true);
                    break;
                }
                case RegExp: 
                case RLike: {
                    String pattern3 = SQLEvalVisitorUtils.castToString(rightValue);
                    String input3 = SQLEvalVisitorUtils.castToString(left.getAttributes().get("eval.value"));
                    boolean matchResult3 = Pattern.matches(pattern3, input3);
                    x.putAttribute("eval.value", matchResult3);
                    break;
                }
                case NotRegExp: 
                case NotRLike: {
                    String pattern4 = SQLEvalVisitorUtils.castToString(rightValue);
                    String input4 = SQLEvalVisitorUtils.castToString(left.getAttributes().get("eval.value"));
                    boolean matchResult4 = !Pattern.matches(pattern4, input4);
                    x.putAttribute("eval.value", matchResult4);
                    break;
                }
                case Concat: {
                    String result = leftValue.toString() + rightValue.toString();
                    x.putAttribute("eval.value", result);
                    break;
                }
                case BooleanAnd: {
                    boolean first = SQLEvalVisitorUtils.eq(leftValue, true);
                    boolean second = SQLEvalVisitorUtils.eq(rightValue, true);
                    x.putAttribute("eval.value", first && second);
                    break;
                }
                case BooleanOr: {
                    boolean first5 = SQLEvalVisitorUtils.eq(leftValue, true);
                    boolean second5 = SQLEvalVisitorUtils.eq(rightValue, true);
                    x.putAttribute("eval.value", first5 || second5);
                }
            }
            return false;
        }
        return false;
    }

    private static Object processValue(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 1) {
                return SQLEvalVisitorUtils.processValue(list.get(0));
            }
        } else if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return value;
    }

    private static boolean isAlwayTrueLikePattern(SQLExpr x) {
        String text;
        if (x instanceof SQLCharExpr && (text = ((SQLCharExpr)x).getText()).length() > 0) {
            for (char ch : text.toCharArray()) {
                if (ch == '%') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLNumericLiteralExpr x) {
        x.putAttribute("eval.value", x.getNumber());
        return false;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLVariantRefExpr x) {
        boolean containsValue;
        if (!"?".equals(x.getName())) {
            return false;
        }
        Map<String, Object> attributes = x.getAttributes();
        int varIndex = x.getIndex();
        List<Object> parameters = visitor.getParameters();
        if (varIndex != -1 && parameters != null && parameters.size() > varIndex && !(containsValue = attributes.containsKey("eval.value"))) {
            Object value = parameters.get(varIndex);
            if (value == null) {
                value = SQLEvalVisitor.EVAL_VALUE_NULL;
            }
            attributes.put("eval.value", value);
        }
        return false;
    }

    public static Boolean castToBoolean(Object val) {
        if (val == null) {
            return null;
        }
        if (val == SQLEvalVisitor.EVAL_VALUE_NULL) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() > 0;
        }
        if (val instanceof String) {
            return "1".equals(val) || "true".equalsIgnoreCase((String)val);
        }
        throw new IllegalArgumentException(val.getClass() + " not supported.");
    }

    public static String castToString(Object val) {
        return val == null ? null : val.toString();
    }

    public static Byte castToByte(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        return val instanceof String ? Byte.parseByte((String)val) : ((Number)val).byteValue();
    }

    public static Short castToShort(Object val) {
        if (val != null && val != SQLEvalVisitor.EVAL_VALUE_NULL) {
            if (val instanceof Short) {
                return (Short)val;
            }
            return val instanceof String ? Short.parseShort((String)val) : ((Number)val).shortValue();
        }
        return null;
    }

    public static Integer castToInteger(Object val) {
        List list;
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        if (val instanceof List && (list = (List)val).size() == 1) {
            return SQLEvalVisitorUtils.castToInteger(list.get(0));
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new FastsqlException("cast error");
    }

    public static Long castToLong(Object val) {
        List list;
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof String) {
            return Long.parseLong((String)val);
        }
        if (val instanceof List && (list = (List)val).size() == 1) {
            return SQLEvalVisitorUtils.castToLong(list.get(0));
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        return ((Number)val).longValue();
    }

    public static Float castToFloat(Object val) {
        if (val != null && val != SQLEvalVisitor.EVAL_VALUE_NULL) {
            return Float.valueOf(val instanceof Float ? ((Float)val).floatValue() : ((Number)val).floatValue());
        }
        return null;
    }

    public static Double castToDouble(Object val) {
        if (val != null && val != SQLEvalVisitor.EVAL_VALUE_NULL) {
            return val instanceof Double ? ((Double)val).doubleValue() : ((Number)val).doubleValue();
        }
        return null;
    }

    public static BigInteger castToBigInteger(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        return val instanceof String ? new BigInteger((String)val) : BigInteger.valueOf(((Number)val).longValue());
    }

    public static Number castToNumber(String val) {
        if (val == null) {
            return null;
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException var9) {
            try {
                return Short.parseShort(val);
            }
            catch (NumberFormatException var8) {
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException var7) {
                    try {
                        return Long.parseLong(val);
                    }
                    catch (NumberFormatException var6) {
                        try {
                            return Float.valueOf(Float.parseFloat(val));
                        }
                        catch (NumberFormatException var5) {
                            try {
                                return Double.parseDouble(val);
                            }
                            catch (NumberFormatException var4) {
                                try {
                                    return new BigInteger(val);
                                }
                                catch (NumberFormatException var3) {
                                    try {
                                        return new BigDecimal(val);
                                    }
                                    catch (NumberFormatException var2) {
                                        return 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static Date castToDate(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof Number) {
            return new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            return SQLEvalVisitorUtils.castToDate((String)val);
        }
        throw new FastsqlException("can cast to date");
    }

    public static Date castToDate(String text) {
        if (text != null && text.length() != 0) {
            String format = text.length() == "yyyy-MM-dd".length() ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
            try {
                return new SimpleDateFormat(format).parse(text);
            }
            catch (ParseException e) {
                throw new FastsqlException("rowFormat : " + format + ", value : " + text, e);
            }
        }
        return null;
    }

    public static BigDecimal castToDecimal(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        if (val instanceof Float) {
            return new BigDecimal(((Float)val).floatValue());
        }
        return val instanceof Double ? new BigDecimal((Double)val) : BigDecimal.valueOf(((Number)val).longValue());
    }

    public static Object rightShift(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        if (a instanceof Long || b instanceof Long) {
            return SQLEvalVisitorUtils.castToLong(a) >> (int)SQLEvalVisitorUtils.castToLong(b).longValue();
        }
        return SQLEvalVisitorUtils.castToInteger(a) >> SQLEvalVisitorUtils.castToInteger(b);
    }

    public static Object bitAnd(Object a, Object b) {
        if (a != null && b != null) {
            if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
                if (a instanceof String) {
                    a = SQLEvalVisitorUtils.castToNumber((String)a);
                }
                if (b instanceof String) {
                    b = SQLEvalVisitorUtils.castToNumber((String)b);
                }
                return !(a instanceof Long) && !(b instanceof Long) ? (long)(SQLEvalVisitorUtils.castToInteger(a) & SQLEvalVisitorUtils.castToInteger(b)) : SQLEvalVisitorUtils.castToLong(a) & SQLEvalVisitorUtils.castToLong(b);
            }
            return null;
        }
        return null;
    }

    public static Object bitOr(Object a, Object b) {
        if (a != null && b != null) {
            if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
                if (a instanceof String) {
                    a = SQLEvalVisitorUtils.castToNumber((String)a);
                }
                if (b instanceof String) {
                    b = SQLEvalVisitorUtils.castToNumber((String)b);
                }
                return !(a instanceof Long) && !(b instanceof Long) ? (long)(SQLEvalVisitorUtils.castToInteger(a) | SQLEvalVisitorUtils.castToInteger(b)) : SQLEvalVisitorUtils.castToLong(a) | SQLEvalVisitorUtils.castToLong(b);
            }
            return null;
        }
        return null;
    }

    public static Object div(Object a, Object b) {
        if (a != null && b != null) {
            if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
                if (a instanceof String) {
                    a = SQLEvalVisitorUtils.castToNumber((String)a);
                }
                if (b instanceof String) {
                    b = SQLEvalVisitorUtils.castToNumber((String)b);
                }
                if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                    if (!(a instanceof Double) && !(b instanceof Double)) {
                        if (!(a instanceof Float) && !(b instanceof Float)) {
                            if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                                if (!(a instanceof Long) && !(b instanceof Long)) {
                                    if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                        if (!(a instanceof Short) && !(b instanceof Short)) {
                                            if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                                throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                            }
                                            return SQLEvalVisitorUtils.castToByte(a) / SQLEvalVisitorUtils.castToByte(b);
                                        }
                                        return SQLEvalVisitorUtils.castToShort(a) / SQLEvalVisitorUtils.castToShort(b);
                                    }
                                    Integer intA = SQLEvalVisitorUtils.castToInteger(a);
                                    Integer intB = SQLEvalVisitorUtils.castToInteger(b);
                                    if (intB == 0) {
                                        if (intA > 0) {
                                            return Double.POSITIVE_INFINITY;
                                        }
                                        return intA < 0 ? Double.NEGATIVE_INFINITY : Double.NaN;
                                    }
                                    return intA / intB;
                                }
                                Long longA = SQLEvalVisitorUtils.castToLong(a);
                                Long longB = SQLEvalVisitorUtils.castToLong(b);
                                if (longB == 0L) {
                                    if (longA > 0L) {
                                        return Double.POSITIVE_INFINITY;
                                    }
                                    return longA < 0L ? Double.NEGATIVE_INFINITY : Double.NaN;
                                }
                                return longA / longB;
                            }
                            return SQLEvalVisitorUtils.castToBigInteger(a).divide(SQLEvalVisitorUtils.castToBigInteger(b));
                        }
                        Float floatA = SQLEvalVisitorUtils.castToFloat(a);
                        Float floatB = SQLEvalVisitorUtils.castToFloat(b);
                        return floatA != null && floatB != null ? Float.valueOf(floatA.floatValue() / floatB.floatValue()) : null;
                    }
                    Double doubleA = SQLEvalVisitorUtils.castToDouble(a);
                    Double doubleB = SQLEvalVisitorUtils.castToDouble(b);
                    return doubleA != null && doubleB != null ? Double.valueOf(doubleA / doubleB) : null;
                }
                BigDecimal decimalA = SQLEvalVisitorUtils.castToDecimal(a);
                BigDecimal decimalB = SQLEvalVisitorUtils.castToDecimal(b);
                if (decimalB.scale() < decimalA.scale()) {
                    decimalB = decimalB.setScale(decimalA.scale());
                }
                try {
                    return decimalA.divide(decimalB);
                }
                catch (ArithmeticException var5) {
                    return decimalA.divide(decimalB, 4);
                }
            }
            return null;
        }
        return null;
    }

    public static boolean gt(Object a, Object b) {
        if (a != null && a != SQLEvalVisitor.EVAL_VALUE_NULL) {
            if (b != null && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
                if (!(a instanceof String) && !(b instanceof String)) {
                    if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                        if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                            if (!(a instanceof Long) && !(b instanceof Long)) {
                                if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                    if (!(a instanceof Short) && !(b instanceof Short)) {
                                        if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                            Date d2;
                                            if (!(a instanceof Date) && !(b instanceof Date)) {
                                                throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                            }
                                            Date d1 = SQLEvalVisitorUtils.castToDate(a);
                                            if (d1 == (d2 = SQLEvalVisitorUtils.castToDate(b))) {
                                                return false;
                                            }
                                            if (d1 == null) {
                                                return false;
                                            }
                                            if (d2 == null) {
                                                return true;
                                            }
                                            return d1.compareTo(d2) > 0;
                                        }
                                        return SQLEvalVisitorUtils.castToByte(a) > SQLEvalVisitorUtils.castToByte(b);
                                    }
                                    return SQLEvalVisitorUtils.castToShort(a) > SQLEvalVisitorUtils.castToShort(b);
                                }
                                return SQLEvalVisitorUtils.castToInteger(a) > SQLEvalVisitorUtils.castToInteger(b);
                            }
                            return SQLEvalVisitorUtils.castToLong(a) > SQLEvalVisitorUtils.castToLong(b);
                        }
                        return SQLEvalVisitorUtils.castToBigInteger(a).compareTo(SQLEvalVisitorUtils.castToBigInteger(b)) > 0;
                    }
                    return SQLEvalVisitorUtils.castToDecimal(a).compareTo(SQLEvalVisitorUtils.castToDecimal(b)) > 0;
                }
                return SQLEvalVisitorUtils.castToString(a).compareTo(SQLEvalVisitorUtils.castToString(b)) > 0;
            }
            return true;
        }
        return false;
    }

    public static boolean gteq(Object a, Object b) {
        return SQLEvalVisitorUtils.eq(a, b) ? true : SQLEvalVisitorUtils.gt(a, b);
    }

    public static boolean lt(Object a, Object b) {
        if (a == null) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (!(a instanceof String) && !(b instanceof String)) {
            if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                    if (!(a instanceof Long) && !(b instanceof Long)) {
                        if (!(a instanceof Integer) && !(b instanceof Integer)) {
                            if (!(a instanceof Short) && !(b instanceof Short)) {
                                if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                    Date d2;
                                    if (!(a instanceof Date) && !(b instanceof Date)) {
                                        throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                    }
                                    Date d1 = SQLEvalVisitorUtils.castToDate(a);
                                    if (d1 == (d2 = SQLEvalVisitorUtils.castToDate(b))) {
                                        return false;
                                    }
                                    if (d1 == null) {
                                        return true;
                                    }
                                    if (d2 == null) {
                                        return false;
                                    }
                                    return d1.compareTo(d2) < 0;
                                }
                                return SQLEvalVisitorUtils.castToByte(a) < SQLEvalVisitorUtils.castToByte(b);
                            }
                            return SQLEvalVisitorUtils.castToShort(a) < SQLEvalVisitorUtils.castToShort(b);
                        }
                        Integer intA = SQLEvalVisitorUtils.castToInteger(a);
                        Integer intB = SQLEvalVisitorUtils.castToInteger(b);
                        return intA < intB;
                    }
                    return SQLEvalVisitorUtils.castToLong(a) < SQLEvalVisitorUtils.castToLong(b);
                }
                return SQLEvalVisitorUtils.castToBigInteger(a).compareTo(SQLEvalVisitorUtils.castToBigInteger(b)) < 0;
            }
            return SQLEvalVisitorUtils.castToDecimal(a).compareTo(SQLEvalVisitorUtils.castToDecimal(b)) < 0;
        }
        return SQLEvalVisitorUtils.castToString(a).compareTo(SQLEvalVisitorUtils.castToString(b)) < 0;
    }

    public static boolean lteq(Object a, Object b) {
        return SQLEvalVisitorUtils.eq(a, b) ? true : SQLEvalVisitorUtils.lt(a, b);
    }

    public static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
                if (a.equals(b)) {
                    return true;
                }
                if (!(a instanceof String) && !(b instanceof String)) {
                    if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                        if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                            if (!(a instanceof Long) && !(b instanceof Long)) {
                                if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                    if (!(a instanceof Short) && !(b instanceof Short)) {
                                        if (!(a instanceof Boolean) && !(b instanceof Boolean)) {
                                            if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                                Date d2;
                                                if (!(a instanceof Date) && !(b instanceof Date)) {
                                                    throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                                }
                                                Date d1 = SQLEvalVisitorUtils.castToDate(a);
                                                if (d1 == (d2 = SQLEvalVisitorUtils.castToDate(b))) {
                                                    return true;
                                                }
                                                return d1 != null && d2 != null ? d1.equals(d2) : false;
                                            }
                                            return SQLEvalVisitorUtils.castToByte(a).equals(SQLEvalVisitorUtils.castToByte(b));
                                        }
                                        return SQLEvalVisitorUtils.castToBoolean(a).equals(SQLEvalVisitorUtils.castToBoolean(b));
                                    }
                                    return SQLEvalVisitorUtils.castToShort(a).equals(SQLEvalVisitorUtils.castToShort(b));
                                }
                                Integer inta = SQLEvalVisitorUtils.castToInteger(a);
                                Integer intb = SQLEvalVisitorUtils.castToInteger(b);
                                return inta != null && intb != null ? inta.equals(intb) : false;
                            }
                            return SQLEvalVisitorUtils.castToLong(a).equals(SQLEvalVisitorUtils.castToLong(b));
                        }
                        return SQLEvalVisitorUtils.castToBigInteger(a).compareTo(SQLEvalVisitorUtils.castToBigInteger(b)) == 0;
                    }
                    return SQLEvalVisitorUtils.castToDecimal(a).compareTo(SQLEvalVisitorUtils.castToDecimal(b)) == 0;
                }
                return SQLEvalVisitorUtils.castToString(a).equals(SQLEvalVisitorUtils.castToString(b));
            }
            return false;
        }
        return false;
    }

    public static Object add(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
            if (a instanceof String && !(b instanceof String)) {
                a = SQLEvalVisitorUtils.castToNumber((String)a);
            }
            if (b instanceof String && !(a instanceof String)) {
                b = SQLEvalVisitorUtils.castToNumber((String)b);
            }
            if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                    if (!(a instanceof Double) && !(b instanceof Double)) {
                        if (!(a instanceof Float) && !(b instanceof Float)) {
                            if (!(a instanceof Long) && !(b instanceof Long)) {
                                if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                    if (!(a instanceof Short) && !(b instanceof Short)) {
                                        if (!(a instanceof Boolean) && !(b instanceof Boolean)) {
                                            if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                                if (a instanceof String && b instanceof String) {
                                                    return SQLEvalVisitorUtils.castToString(a) + SQLEvalVisitorUtils.castToString(b);
                                                }
                                                throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                            }
                                            return SQLEvalVisitorUtils.castToByte(a) + SQLEvalVisitorUtils.castToByte(b);
                                        }
                                        int aI = 0;
                                        int bI = 0;
                                        if (SQLEvalVisitorUtils.castToBoolean(a).booleanValue()) {
                                            aI = 1;
                                        }
                                        if (SQLEvalVisitorUtils.castToBoolean(b).booleanValue()) {
                                            bI = 1;
                                        }
                                        return aI + bI;
                                    }
                                    return SQLEvalVisitorUtils.castToShort(a) + SQLEvalVisitorUtils.castToShort(b);
                                }
                                return SQLEvalVisitorUtils.castToInteger(a) + SQLEvalVisitorUtils.castToInteger(b);
                            }
                            return SQLEvalVisitorUtils.castToLong(a) + SQLEvalVisitorUtils.castToLong(b);
                        }
                        return Float.valueOf(SQLEvalVisitorUtils.castToFloat(a).floatValue() + SQLEvalVisitorUtils.castToFloat(b).floatValue());
                    }
                    return SQLEvalVisitorUtils.castToDouble(a) + SQLEvalVisitorUtils.castToDouble(b);
                }
                return SQLEvalVisitorUtils.castToBigInteger(a).add(SQLEvalVisitorUtils.castToBigInteger(b));
            }
            return SQLEvalVisitorUtils.castToDecimal(a).add(SQLEvalVisitorUtils.castToDecimal(b));
        }
        return SQLEvalVisitor.EVAL_VALUE_NULL;
    }

    public static Object sub(Object a, Object b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return a;
        }
        if (a != SQLEvalVisitor.EVAL_VALUE_NULL && b != SQLEvalVisitor.EVAL_VALUE_NULL) {
            if (!(a instanceof Date) && !(b instanceof Date)) {
                if (a instanceof String) {
                    a = SQLEvalVisitorUtils.castToNumber((String)a);
                }
                if (b instanceof String) {
                    b = SQLEvalVisitorUtils.castToNumber((String)b);
                }
                if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                    if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                        if (!(a instanceof Double) && !(b instanceof Double)) {
                            if (!(a instanceof Float) && !(b instanceof Float)) {
                                if (!(a instanceof Long) && !(b instanceof Long)) {
                                    if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                        if (!(a instanceof Short) && !(b instanceof Short)) {
                                            if (!(a instanceof Boolean) && !(b instanceof Boolean)) {
                                                if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                                    throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                                }
                                                return SQLEvalVisitorUtils.castToByte(a) - SQLEvalVisitorUtils.castToByte(b);
                                            }
                                            int aI = 0;
                                            int bI = 0;
                                            if (SQLEvalVisitorUtils.castToBoolean(a).booleanValue()) {
                                                aI = 1;
                                            }
                                            if (SQLEvalVisitorUtils.castToBoolean(b).booleanValue()) {
                                                bI = 1;
                                            }
                                            return aI - bI;
                                        }
                                        return SQLEvalVisitorUtils.castToShort(a) - SQLEvalVisitorUtils.castToShort(b);
                                    }
                                    return SQLEvalVisitorUtils.castToInteger(a) - SQLEvalVisitorUtils.castToInteger(b);
                                }
                                return SQLEvalVisitorUtils.castToLong(a) - SQLEvalVisitorUtils.castToLong(b);
                            }
                            return Float.valueOf(SQLEvalVisitorUtils.castToFloat(a).floatValue() - SQLEvalVisitorUtils.castToFloat(b).floatValue());
                        }
                        return SQLEvalVisitorUtils.castToDouble(a) - SQLEvalVisitorUtils.castToDouble(b);
                    }
                    return SQLEvalVisitorUtils.castToBigInteger(a).subtract(SQLEvalVisitorUtils.castToBigInteger(b));
                }
                return SQLEvalVisitorUtils.castToDecimal(a).subtract(SQLEvalVisitorUtils.castToDecimal(b));
            }
            return SQLEvalVisitor.EVAL_ERROR;
        }
        return SQLEvalVisitor.EVAL_VALUE_NULL;
    }

    public static Object multi(Object a, Object b) {
        if (a != null && b != null) {
            if (a instanceof String) {
                a = SQLEvalVisitorUtils.castToNumber((String)a);
            }
            if (b instanceof String) {
                b = SQLEvalVisitorUtils.castToNumber((String)b);
            }
            if (!(a instanceof BigDecimal) && !(b instanceof BigDecimal)) {
                if (!(a instanceof BigInteger) && !(b instanceof BigInteger)) {
                    if (!(a instanceof Double) && !(b instanceof Double)) {
                        if (!(a instanceof Float) && !(b instanceof Float)) {
                            if (!(a instanceof Long) && !(b instanceof Long)) {
                                if (!(a instanceof Integer) && !(b instanceof Integer)) {
                                    if (!(a instanceof Short) && !(b instanceof Short)) {
                                        if (!(a instanceof Byte) && !(b instanceof Byte)) {
                                            throw new IllegalArgumentException(a.getClass() + " and " + b.getClass() + " not supported.");
                                        }
                                        return SQLEvalVisitorUtils.castToByte(a) * SQLEvalVisitorUtils.castToByte(b);
                                    }
                                    Short shortA = SQLEvalVisitorUtils.castToShort(a);
                                    Short shortB = SQLEvalVisitorUtils.castToShort(b);
                                    return shortA != null && shortB != null ? Integer.valueOf(shortA * shortB) : null;
                                }
                                return SQLEvalVisitorUtils.castToInteger(a) * SQLEvalVisitorUtils.castToInteger(b);
                            }
                            return SQLEvalVisitorUtils.castToLong(a) * SQLEvalVisitorUtils.castToLong(b);
                        }
                        return Float.valueOf(SQLEvalVisitorUtils.castToFloat(a).floatValue() * SQLEvalVisitorUtils.castToFloat(b).floatValue());
                    }
                    return SQLEvalVisitorUtils.castToDouble(a) * SQLEvalVisitorUtils.castToDouble(b);
                }
                return SQLEvalVisitorUtils.castToBigInteger(a).multiply(SQLEvalVisitorUtils.castToBigInteger(b));
            }
            return SQLEvalVisitorUtils.castToDecimal(a).multiply(SQLEvalVisitorUtils.castToDecimal(b));
        }
        return null;
    }

    public static boolean like(String input, String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        StringBuilder regexprBuilder = new StringBuilder(pattern.length() + 4);
        boolean STAT_NOTSET = false;
        boolean STAT_RANGE = true;
        int STAT_LITERAL = 2;
        int stat = 0;
        int blockStart = -1;
        for (int i = 0; i < pattern.length(); ++i) {
            String block;
            char ch = pattern.charAt(i);
            if (stat == 2 && (ch == '%' || ch == '_' || ch == '[')) {
                block = pattern.substring(blockStart, i);
                regexprBuilder.append("\\Q");
                regexprBuilder.append(block);
                regexprBuilder.append("\\E");
                blockStart = -1;
                stat = 0;
            }
            if (ch == '%') {
                regexprBuilder.append(".*");
                continue;
            }
            if (ch == '_') {
                regexprBuilder.append('.');
                continue;
            }
            if (ch == '[') {
                if (stat == 1) {
                    throw new IllegalArgumentException("illegal pattern : " + pattern);
                }
                stat = 1;
                blockStart = i;
                continue;
            }
            if (ch == ']') {
                if (stat != 1) {
                    throw new IllegalArgumentException("illegal pattern : " + pattern);
                }
                block = pattern.substring(blockStart, i + 1);
                regexprBuilder.append(block);
                blockStart = -1;
                continue;
            }
            if (stat == 0) {
                stat = 2;
                blockStart = i;
            }
            if (stat != 2 || i != pattern.length() - 1) continue;
            block = pattern.substring(blockStart, i + 1);
            regexprBuilder.append("\\Q");
            regexprBuilder.append(block);
            regexprBuilder.append("\\E");
        }
        if (!"%".equals(pattern) && !"%%".equals(pattern)) {
            String regexpr = regexprBuilder.toString();
            return Pattern.matches(regexpr, input);
        }
        return true;
    }

    public static boolean visit(SQLEvalVisitor visitor, SQLIdentifierExpr x) {
        x.putAttribute("eval.expr", x);
        return false;
    }

    static {
        SQLEvalVisitorUtils.registerBaseFunctions();
    }
}

