/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.gateway.netty.framework;

import com.palacesun.engine.gateway.netty.framework.GatewayRequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        try {
            GatewayRequestHandler.switchHanderMethod(req);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String data = "\u63a5\u53e3\u63a8\u9001\u5b8c\u6210\uff01";
        ByteBuf buf = this.copiedBuffer(data, CharsetUtil.UTF_8);
        FullHttpResponse response = null;
        response = this.responseOk(HttpResponseStatus.OK, buf);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.writeAndFlush((Object)"GATEWAY_PUSH_OK!").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private FullHttpResponse responseOk(HttpResponseStatus status, ByteBuf buf) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf);
        if (buf != null) {
            response.headers().set("Content-Type", (Object)"text/plain;charset=UTF-8");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        }
        return response;
    }

    private ByteBuf copiedBuffer(String data, Charset utf8) {
        return Unpooled.wrappedBuffer((byte[])data.getBytes());
    }
}

