/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.masking.adapter.StringUtils;
import com.palacesun.masking.tools.ReflectUtil;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DESUtil {
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "DES";
    public static final int DEFAULT_KEY_SIZE = 56;
    private static Properties properties;
    private static String ENCRYPT_LIKE_SPLIT;
    private static final String ENCRYPT_LIKE_OPEN = "1";

    public static String generateKey() throws Exception {
        return DESUtil.byteToHexString(DESUtil.generateKey(56));
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bytes[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME);
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String encryptEcb(String hexKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Throwable {
        String encResult;
        byte[] keyData = DESUtil.hexStringToByteArray(hexKey);
        DESKeySpec desKey = new DESKeySpec(keyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM_NAME);
        SecretKey secretKey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME);
        cipher.init(1, (Key)secretKey, new SecureRandom());
        String prefix = null;
        String enc = paramStr;
        String suffix = null;
        if (!StringUtils.isBlank(keepfirst)) {
            if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                if (!"2".equals(keepfirst)) {
                    return paramStr;
                }
                int first = 0;
                if (StringUtils.isNotBlank(encdigit)) {
                    first = Integer.parseInt(encdigit);
                }
                int last = 0;
                if (StringUtils.isNotBlank(twoindex)) {
                    last = Integer.parseInt(twoindex);
                }
                if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                    return paramStr;
                }
                prefix = paramStr.substring(0, first);
                enc = paramStr.substring(first, paramStr.length() - last);
                suffix = paramStr.substring(paramStr.length() - last);
            } else if (StringUtils.isNotBlank(encdigit)) {
                if (Integer.parseInt(encdigit) >= paramStr.length()) {
                    return paramStr;
                }
                if (Integer.parseInt(encdigit) != 0) {
                    if ("0".equals(keepfirst)) {
                        prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                        enc = paramStr.substring(Integer.parseInt(encdigit));
                    } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                        enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                        suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                    }
                }
            }
        }
        if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < enc.length(); ++i) {
                char c = enc.charAt(i);
                byte[] srcData = (c + "").getBytes(ENCODING);
                byte[] b = cipher.doFinal(srcData);
                String s = DESUtil.byteToHexString(b);
                sb.append(s).append(ENCRYPT_LIKE_SPLIT);
            }
            encResult = sb.deleteCharAt(sb.length() - 1).toString();
        } else {
            byte[] cipherArray = cipher.doFinal(enc.getBytes(ENCODING));
            encResult = DESUtil.byteToHexString(cipherArray);
        }
        if ("0".equals(keepfirst) && null != prefix) {
            return prefix + encResult;
        }
        if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
            return encResult + suffix;
        }
        if ("2".equals(keepfirst)) {
            if (null != prefix) {
                encResult = prefix + encResult;
            }
            if (null != suffix) {
                encResult = encResult + suffix;
            }
        }
        return encResult;
    }

    public static String decryptEcb(String hexKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Throwable {
        String encResult;
        byte[] keyData = DESUtil.hexStringToByteArray(hexKey);
        DESKeySpec desKey = new DESKeySpec(keyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM_NAME);
        SecretKey secretkey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance(ALGORITHM_NAME);
        cipher.init(2, (Key)secretkey, new SecureRandom());
        String prefix = null;
        String enc = paramStr;
        String suffix = null;
        if (!StringUtils.isBlank(encdigit)) {
            if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                if (!"2".equals(keepfirst)) {
                    return paramStr;
                }
                int first = 0;
                if (StringUtils.isNotBlank(encdigit)) {
                    first = Integer.parseInt(encdigit);
                }
                int last = 0;
                if (StringUtils.isNotBlank(twoindex)) {
                    last = Integer.parseInt(twoindex);
                }
                if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                    return paramStr;
                }
                prefix = paramStr.substring(0, first);
                enc = paramStr.substring(first, paramStr.length() - last);
                suffix = paramStr.substring(paramStr.length() - last);
            } else if (StringUtils.isNotBlank(encdigit)) {
                if (Integer.parseInt(encdigit) >= paramStr.length()) {
                    return paramStr;
                }
                if (Integer.parseInt(encdigit) != 0) {
                    if ("0".equals(keepfirst)) {
                        prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                        enc = paramStr.substring(Integer.parseInt(encdigit));
                    } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                        suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                        enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                    }
                }
            }
        }
        if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
            String[] split;
            StringBuilder sb = new StringBuilder();
            for (String s : split = enc.split(ENCRYPT_LIKE_SPLIT)) {
                try {
                    byte[] cipherData = DESUtil.hexStringToByteArray(s);
                    byte[] decryptBytes = cipher.doFinal(cipherData);
                    sb.append(new String(decryptBytes, ENCODING));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            encResult = sb.toString();
        } else {
            byte[] cipherData = DESUtil.hexStringToByteArray(enc);
            encResult = new String(cipher.doFinal(cipherData), ENCODING);
        }
        if ("0".equals(keepfirst) && null != prefix) {
            return prefix + encResult;
        }
        if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
            return encResult + suffix;
        }
        if ("2".equals(keepfirst)) {
            if (null != prefix) {
                encResult = prefix + encResult;
            }
            if (null != suffix) {
                encResult = encResult + suffix;
            }
        }
        return encResult;
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static void main(String[] args) throws Throwable {
        String key = DESUtil.generateKey();
        System.out.println(key);
        String data = "~\u8fd9\u662fyuanshi\u7684\u660e\u6587xinxi\u5728\u8fd9\u91cc\u5462,1\u3002";
        System.out.println(data);
        String encrypt = DESUtil.encryptEcb(key, data, ENCRYPT_LIKE_OPEN, "0", "3", "0", new String[0]);
        System.out.println(encrypt);
        String decrypt = DESUtil.decryptEcb(key, encrypt, ENCRYPT_LIKE_OPEN, "0", "3", "0", new String[0]);
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
        encrypt = ReflectUtil.engine(ALGORITHM_NAME, data, key, ENCRYPT_LIKE_OPEN, "0", "3", "0", true, null);
        System.out.println(encrypt);
        decrypt = ReflectUtil.engine(ALGORITHM_NAME, encrypt, key, ENCRYPT_LIKE_OPEN, "0", "3", "0", false, null);
        System.out.println(decrypt);
        System.out.println(data.equals(decrypt));
    }

    static {
        ENCRYPT_LIKE_SPLIT = EncryptionGatewayManager.getParameterValue("encryption.like.split");
    }
}

