/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.masking.adapter.StringUtils;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;

public class Sm4Util {
    protected static Logger logger = Logger.getLogger(Sm4Util.class.getName());
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final String ALGORITHM_NAME_GCM_NOPADDING = "SM4/GCM/NoPadding";
    public static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    public static final String ALGORITHM_NAME_OFB_PADDING = "SM4/OFB/NoPadding";
    public static final String ALGORITHM_NAME_CFB_PADDING = "SM4/CFB/NoPadding";
    public static final String ALGORITHM_NAME_CCM_PADDING = "SM4/CCM/NoPadding";
    public static final int DEFAULT_KEY_SIZE = 128;
    public static final int MAC_SIZE_BITS = 64;
    public static final String NOTICE = "1234567890abcdef1234";
    public static final CCMBlockCipher ccmCipher = new CCMBlockCipher((BlockCipher)new SM4Engine());
    private static Properties properties;
    private static String ENCRYPT_LIKE_SPLIT;
    private static String ENCRYPT_LABEL;
    private static String ENCRYPT_SEPARATOR;
    private static final byte[] IV;
    private static final String ENCRYPT_LIKE_OPEN = "1";

    public static String generateKey() throws Exception {
        return new String(org.apache.commons.codec.binary.Hex.encodeHex((byte[])Sm4Util.generateKey(128), (boolean)false));
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    private static Cipher generateGcmCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, new IvParameterSpec(IV));
        return cipher;
    }

    private static Cipher generateCcmCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, new IvParameterSpec(IV));
        return cipher;
    }

    private static Cipher generateCfbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName);
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, new IvParameterSpec(IV));
        return cipher;
    }

    private static Cipher generateOfbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName);
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, new IvParameterSpec(IV));
        return cipher;
    }

    public static String encryptEcb(String hexKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Exception {
        try {
            String cipherText = "";
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            String prefix = null;
            String enc = paramStr;
            String suffix = null;
            String encryptModeSwitch = ALGORITHM_NAME;
            if (encryptMode.length > 0) {
                encryptModeSwitch = encryptMode[0];
            }
            if (!StringUtils.isBlank(keepfirst)) {
                if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                    if ("2".equals(keepfirst)) {
                        int first = 0;
                        if (StringUtils.isNotBlank(encdigit)) {
                            first = Integer.parseInt(encdigit);
                        }
                        int last = 0;
                        if (StringUtils.isNotBlank(twoindex)) {
                            last = Integer.parseInt(twoindex);
                        }
                        if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                            return paramStr;
                        }
                        prefix = paramStr.substring(0, first);
                        enc = paramStr.substring(first, paramStr.length() - last);
                        suffix = paramStr.substring(paramStr.length() - last);
                    }
                } else if (StringUtils.isNotBlank(encdigit)) {
                    if (Integer.parseInt(encdigit) >= paramStr.length()) {
                        return paramStr;
                    }
                    if (Integer.parseInt(encdigit) != 0) {
                        if ("0".equals(keepfirst)) {
                            prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                            enc = paramStr.substring(Integer.parseInt(encdigit));
                        } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                            enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                            suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                        }
                    }
                }
            }
            if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
                StringBuilder sb = new StringBuilder();
                List<String> subS = Sm4Util.subS(enc);
                for (int i = 0; i < subS.size(); ++i) {
                    String c = subS.get(i);
                    byte[] srcData = (c + "").getBytes(ENCODING);
                    byte[] cipherArray = new byte[]{};
                    if (!ALGORITHM_NAME.equals(encryptModeSwitch) && !"SM4_ECB".equals(encryptModeSwitch)) {
                        if ("SM4_GCM".equals(encryptModeSwitch)) {
                            cipherArray = Sm4Util.encrypt_Gcm_Padding(keyData, srcData);
                        } else if ("SM4_CBC".equals(encryptModeSwitch)) {
                            cipherArray = Sm4Util.encrypt_Cbc_Padding(keyData, srcData);
                        } else if ("SM4_OFB".equals(encryptModeSwitch)) {
                            cipherArray = Sm4Util.encrypt_Ofb_Padding(keyData, srcData);
                        } else if ("SM4_CFB".equals(encryptModeSwitch)) {
                            cipherArray = Sm4Util.encrypt_Cfb_Padding(keyData, srcData);
                        } else if ("SM4_CCM".equals(encryptModeSwitch)) {
                            cipherArray = Sm4Util.encrypt_Ccm_Padding(keyData, srcData);
                        }
                    } else {
                        cipherArray = Sm4Util.encrypt_Ecb_Padding(keyData, srcData);
                    }
                    cipherText = ByteUtils.toHexString((byte[])cipherArray);
                    sb.append(cipherText).append(ENCRYPT_LIKE_SPLIT);
                }
                cipherText = sb.deleteCharAt(sb.length() - 1).toString();
            } else {
                byte[] srcData = enc.getBytes(ENCODING);
                byte[] cipherArray = new byte[]{};
                if (!ALGORITHM_NAME.equals(encryptModeSwitch) && !"SM4_ECB".equals(encryptModeSwitch)) {
                    if ("SM4_GCM".equals(encryptModeSwitch)) {
                        cipherArray = Sm4Util.encrypt_Gcm_Padding(keyData, srcData);
                    } else if ("SM4_CBC".equals(encryptModeSwitch)) {
                        cipherArray = Sm4Util.encrypt_Cbc_Padding(keyData, srcData);
                    } else if ("SM4_OFB".equals(encryptModeSwitch)) {
                        cipherArray = Sm4Util.encrypt_Ofb_Padding(keyData, srcData);
                    } else if ("SM4_CFB".equals(encryptModeSwitch)) {
                        cipherArray = Sm4Util.encrypt_Cfb_Padding(keyData, srcData);
                    } else if ("SM4_CCM".equals(encryptModeSwitch)) {
                        cipherArray = Sm4Util.encrypt_Ccm_Padding(keyData, srcData);
                    }
                } else {
                    cipherArray = Sm4Util.encrypt_Ecb_Padding(keyData, srcData);
                }
                cipherText = ByteUtils.toHexString((byte[])cipherArray);
            }
            if ("0".equals(keepfirst) && null != prefix) {
                cipherText = prefix + cipherText;
            } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
                cipherText = cipherText + suffix;
            } else if ("2".equals(keepfirst)) {
                if (null != prefix) {
                    cipherText = prefix + cipherText;
                }
                if (null != suffix) {
                    cipherText = cipherText + suffix;
                }
            }
            return cipherText;
        }
        catch (Exception var19) {
            return paramStr;
        }
    }

    public static List<String> subS(String str) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < str.length(); ++i) {
            int codePoint = str.codePointAt(i);
            a.add(String.valueOf(Character.toChars(codePoint)));
            sb.append(Character.toChars(codePoint));
            if (!Character.isSupplementaryCodePoint(codePoint)) continue;
            ++i;
        }
        return a;
    }

    public static String modifyString(String input) {
        if (input.length() < 6) {
            throw new IllegalArgumentException("Input string must be at least 6 characters long.");
        }
        StringBuilder sb = new StringBuilder(input);
        sb.insert(1, 'a');
        sb.insert(4, 'b');
        sb.insert(6, 'c');
        return sb.toString();
    }

    public static byte[] encrypt_Cbc_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    private static Cipher generateCbcCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, (Key)sm4Key, Sm4Util.generateIV());
        return cipher;
    }

    public static AlgorithmParameters generateIV() throws Exception {
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        AlgorithmParameters params = AlgorithmParameters.getInstance(ALGORITHM_NAME);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static byte[] encrypt_Ccm_Padding(byte[] key, byte[] data) throws Exception {
        byte[] nonce = Hex.decode((String)NOTICE);
        ccmCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
        byte[] ciphertext = new byte[ccmCipher.getOutputSize(data.length)];
        int len = ccmCipher.processBytes(data, 0, data.length, ciphertext, 0);
        ccmCipher.doFinal(ciphertext, len);
        return ciphertext;
    }

    public static byte[] encrypt_Cfb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateCfbCipher(ALGORITHM_NAME_CFB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt_Ofb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateOfbCipher(ALGORITHM_NAME_OFB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt_Gcm_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateGcmCipher(ALGORITHM_NAME_GCM_NOPADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String paramStr, String isLike, String keepfirst, String encdigit, String twoindex, String ... encryptMode) throws Exception {
        String decryptStr = "";
        try {
            byte[] srcData = new byte[]{};
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            String prefix = null;
            String enc = paramStr;
            String suffix = null;
            String encryptModeSwitch = ALGORITHM_NAME;
            if (encryptMode.length > 0) {
                encryptModeSwitch = encryptMode[0];
            }
            if (!StringUtils.isBlank(keepfirst)) {
                if (!"0".equals(keepfirst) && !ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                    if ("2".equals(keepfirst)) {
                        int first = 0;
                        if (StringUtils.isNotBlank(encdigit)) {
                            first = Integer.parseInt(encdigit);
                        }
                        int last = 0;
                        if (StringUtils.isNotBlank(twoindex)) {
                            last = Integer.parseInt(twoindex);
                        }
                        if (first + last >= paramStr.length() || first >= paramStr.length() || last >= paramStr.length()) {
                            return paramStr;
                        }
                        prefix = paramStr.substring(0, first);
                        enc = paramStr.substring(first, paramStr.length() - last);
                        suffix = paramStr.substring(paramStr.length() - last);
                    }
                } else if (StringUtils.isNotBlank(encdigit)) {
                    if (Integer.parseInt(encdigit) >= paramStr.length()) {
                        return paramStr;
                    }
                    if (Integer.parseInt(encdigit) != 0) {
                        if ("0".equals(keepfirst)) {
                            prefix = paramStr.substring(0, Integer.parseInt(encdigit));
                            enc = paramStr.substring(Integer.parseInt(encdigit));
                        } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst)) {
                            suffix = paramStr.substring(paramStr.length() - Integer.parseInt(encdigit));
                            enc = paramStr.substring(0, paramStr.length() - Integer.parseInt(encdigit));
                        }
                    }
                }
            }
            if (ENCRYPT_LIKE_OPEN.equals(isLike)) {
                String[] split;
                StringBuilder sb = new StringBuilder();
                for (String s : split = enc.split(ENCRYPT_LIKE_SPLIT)) {
                    byte[] cipherData = ByteUtils.fromHexString((String)s);
                    try {
                        if (!ALGORITHM_NAME.equals(encryptModeSwitch) && !"SM4_ECB".equals(encryptModeSwitch)) {
                            if ("SM4_GCM".equals(encryptModeSwitch)) {
                                srcData = Sm4Util.decrypt_Gcm_Padding(keyData, cipherData);
                            } else if ("SM4_CBC".equals(encryptModeSwitch)) {
                                srcData = Sm4Util.decrypt_Cbc_Padding(keyData, cipherData);
                            } else if ("SM4_OFB".equals(encryptModeSwitch)) {
                                srcData = Sm4Util.decrypt_Ofb_Padding(keyData, cipherData);
                            } else if ("SM4_CFB".equals(encryptModeSwitch)) {
                                srcData = Sm4Util.decrypt_Cfb_Padding(keyData, cipherData);
                            } else if ("SM4_CCM".equals(encryptModeSwitch)) {
                                srcData = Sm4Util.decrypt_Ccm_Padding(keyData, cipherData);
                            }
                        } else {
                            srcData = Sm4Util.decrypt_Ecb_Padding(keyData, cipherData);
                        }
                        decryptStr = new String(srcData, ENCODING);
                        sb.append(decryptStr);
                    }
                    catch (Exception var22) {
                        return ENCRYPT_LABEL + paramStr.replaceAll(ENCRYPT_LIKE_SPLIT, ENCRYPT_SEPARATOR + ENCRYPT_LIKE_SPLIT + ENCRYPT_LABEL) + ENCRYPT_SEPARATOR;
                    }
                }
                decryptStr = sb.toString();
            } else {
                byte[] cipherData = ByteUtils.fromHexString((String)enc);
                if (!ALGORITHM_NAME.equals(encryptModeSwitch) && !"SM4_ECB".equals(encryptModeSwitch)) {
                    if ("SM4_GCM".equals(encryptModeSwitch)) {
                        srcData = Sm4Util.decrypt_Gcm_Padding(keyData, cipherData);
                    } else if ("SM4_CBC".equals(encryptModeSwitch)) {
                        srcData = Sm4Util.decrypt_Cbc_Padding(keyData, cipherData);
                    } else if ("SM4_OFB".equals(encryptModeSwitch)) {
                        srcData = Sm4Util.decrypt_Ofb_Padding(keyData, cipherData);
                    } else if ("SM4_CFB".equals(encryptModeSwitch)) {
                        srcData = Sm4Util.decrypt_Cfb_Padding(keyData, cipherData);
                    } else if ("SM4_CCM".equals(encryptModeSwitch)) {
                        srcData = Sm4Util.decrypt_Ccm_Padding(keyData, cipherData);
                    }
                } else {
                    srcData = Sm4Util.decrypt_Ecb_Padding(keyData, cipherData);
                }
                decryptStr = new String(srcData, ENCODING);
            }
            if ("0".equals(keepfirst) && null != prefix) {
                decryptStr = prefix + decryptStr;
            } else if (ENCRYPT_LIKE_OPEN.equals(keepfirst) && null != suffix) {
                decryptStr = decryptStr + suffix;
            } else if ("2".equals(keepfirst)) {
                if (null != prefix) {
                    decryptStr = prefix + decryptStr;
                }
                if (null != suffix) {
                    decryptStr = decryptStr + suffix;
                }
            }
            return decryptStr;
        }
        catch (Exception var23) {
            return ENCRYPT_LABEL + paramStr + ENCRYPT_SEPARATOR;
        }
    }

    public static byte[] decrypt_Ccm_Padding(byte[] key, byte[] cipherText) throws Exception {
        byte[] nonce = Hex.decode((String)NOTICE);
        ccmCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
        byte[] decryptedText = new byte[ccmCipher.getOutputSize(cipherText.length)];
        int decryptedLen = ccmCipher.processBytes(cipherText, 0, cipherText.length, decryptedText, 0);
        ccmCipher.doFinal(decryptedText, decryptedLen);
        return decryptedText;
    }

    private static byte[] decrypt_Cfb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateCfbCipher(ALGORITHM_NAME_CFB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    private static byte[] decrypt_Ofb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateOfbCipher(ALGORITHM_NAME_OFB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static byte[] decrypt_Cbc_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static byte[] decrypt_Gcm_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateGcmCipher(ALGORITHM_NAME_GCM_NOPADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = Sm4Util.decrypt_Ecb_Padding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static void main(String[] args) {
        try {
            String json = "af91e8e7fd";
            String key = "4E829D9E2BEE7ECB79BFFA8C88A9937B";
            String cipher = Sm4Util.encryptEcb(key, json, "0", "0", "0", "0", new String[0]);
            System.out.println("\u52a0\u5bc6\u4e32---" + cipher);
            json = Sm4Util.decryptEcb(key, "fefaf8c85fb3b82186f88b95c54b074b1", "0", "0", "0", "0", new String[0]);
            System.out.println("\u89e3\u5bc6\u540e\u6570\u636e---" + json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        ENCRYPT_LIKE_SPLIT = EncryptionGatewayManager.getParameterValue("encryption.like.split");
        ENCRYPT_LABEL = EncryptionGatewayManager.getParameterValue("encryption.label");
        ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");
        IV = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2};
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

