/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEntity;
import com.palacesun.masking.tools.sm4fpe.SegmentType;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPECellPhone
extends SM4FPEBase {
    static ArrayList<SM4FPEEntity> cellphoneEntities;
    static String[] cellphoneCCStr1;
    static String[] cellphoneCCStr2;
    static String[] cellphoneCCStr3;
    static String[] cellphoneCCStr4;
    static String[] cellphoneCCStr5;
    static String[] cellphoneMACStr;
    static HashMap cellphoneCCStr1Map;
    static HashMap cellphoneCCStr2Map;
    static HashMap cellphoneCCStr3Map;
    static HashMap cellphoneCCStr4Map;
    static HashMap cellphoneCCStr5Map;
    static HashMap cellphoneMACStrMap;
    private static Pattern mobilephoneNoSimplePattern;

    @Override
    public String encryptEcb(String hexKey, String a) throws Exception {
        String out = this.encrypt(hexKey, a, cellphoneEntities);
        return out;
    }

    @Override
    public String decryptEcb(String hexKey, String input) throws Exception {
        String out = this.decrypt(hexKey, input, cellphoneEntities);
        return out;
    }

    public static boolean isMobilephoneNo(String mobilephoneNo) {
        boolean result = false;
        int length = mobilephoneNo.length();
        if (length >= 11 && length <= 17) {
            if (null == mobilephoneNoSimplePattern) {
                mobilephoneNoSimplePattern = Pattern.compile("\\+?[0-9]{11,17}");
            }
            if (mobilephoneNoSimplePattern.matcher(mobilephoneNo).matches()) {
                if (mobilephoneNo.contains("+")) {
                    int typeLength = 0;
                    if (length == 13) {
                        typeLength = 2;
                        if (cellphoneEntities.get(0).getCharsMap().get(mobilephoneNo.substring(0, typeLength)) != null && cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(typeLength, typeLength + 3)) != null) {
                            result = true;
                        }
                    } else if (length == 14) {
                        typeLength = 3;
                        if (cellphoneEntities.get(1).getCharsMap().get(mobilephoneNo.substring(0, typeLength)) != null && cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(typeLength, typeLength + 3)) != null) {
                            result = true;
                        }
                    } else if (length == 15) {
                        typeLength = 4;
                        if (cellphoneEntities.get(2).getCharsMap().get(mobilephoneNo.substring(0, typeLength)) != null && cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(typeLength, typeLength + 3)) != null) {
                            result = true;
                        }
                    } else if (length == 16) {
                        typeLength = 5;
                        if (cellphoneEntities.get(3).getCharsMap().get(mobilephoneNo.substring(0, typeLength)) != null && cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(typeLength, typeLength + 3)) != null) {
                            result = true;
                        }
                    } else if (length == 17) {
                        typeLength = 6;
                        if (cellphoneEntities.get(4).getCharsMap().get(mobilephoneNo.substring(0, typeLength)) != null && cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(typeLength, typeLength + 3)) != null) {
                            result = true;
                        }
                    }
                } else if (cellphoneEntities.get(5).getCharsMap().get(mobilephoneNo.substring(0, 3)) != null) {
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public int initTypes(String input, int m, SegmentType[] types, ArrayList<SM4FPEEntity> entities) throws Exception {
        int typeIndex = 0;
        int type = 0;
        int typeLength = 0;
        Integer index = null;
        int i = 3;
        if (input.contains("+")) {
            int length = input.length();
            if (length == 13) {
                typeLength = 2;
                type = 0;
                index = (Integer)entities.get(type).getCharsMap().get(input.substring(0, typeLength));
                typeIndex = this.setTypes(types, typeIndex, typeLength, type, index);
            } else if (length == 14) {
                typeLength = 3;
                type = 1;
                index = (Integer)entities.get(type).getCharsMap().get(input.substring(0, typeLength));
                typeIndex = this.setTypes(types, typeIndex, typeLength, type, index);
            } else if (length == 15) {
                typeLength = 4;
                type = 2;
                index = (Integer)entities.get(type).getCharsMap().get(input.substring(0, typeLength));
                typeIndex = this.setTypes(types, typeIndex, typeLength, type, index);
            } else if (length == 16) {
                typeLength = 5;
                type = 3;
                index = (Integer)entities.get(type).getCharsMap().get(input.substring(0, typeLength));
                typeIndex = this.setTypes(types, typeIndex, typeLength, type, index);
            } else if (length == 17) {
                typeLength = 6;
                type = 4;
                index = (Integer)entities.get(type).getCharsMap().get(input.substring(0, typeLength));
                typeIndex = this.setTypes(types, typeIndex, typeLength, type, index);
            }
            typeIndex = this.initMac(input, types, entities, typeIndex, typeLength);
            i = typeLength + types[typeIndex - 1].length;
        } else {
            typeIndex = this.initMac(input, types, entities, typeIndex, 0);
        }
        while (i < input.length()) {
            type = 6;
            index = (Integer)entities.get(type).getCharsMap().get(Character.valueOf(input.charAt(i)));
            types[typeIndex++].type = index != null ? type : 99999;
            ++i;
        }
        return typeIndex++;
    }

    private int setTypes(SegmentType[] types, int typeIndex, int typeLength, int type, Integer index) {
        if (index != null) {
            types[typeIndex].type = type;
            types[typeIndex].length = typeLength;
            ++typeIndex;
        } else {
            types[typeIndex].type = 99999;
            types[typeIndex].length = typeLength;
            ++typeIndex;
        }
        return typeIndex;
    }

    private int initMac(String input, SegmentType[] types, ArrayList<SM4FPEEntity> entities, int typeIndex, int startIndex) {
        Integer index = (Integer)entities.get(5).getCharsMap().get(input.substring(startIndex, startIndex + 3));
        if (index != null) {
            types[typeIndex].type = 5;
            types[typeIndex].length = 3;
        } else {
            types[typeIndex].type = 99999;
            types[typeIndex].length = 3;
        }
        return ++typeIndex;
    }

    @Override
    String generateInputRandom(String input) {
        Random random = new Random();
        input = input + cellphoneEntities.get(0).getList().get(random.nextInt(cellphoneEntities.get(0).getList().size()));
        input = input + cellphoneEntities.get(5).getList().get(random.nextInt(cellphoneEntities.get(5).getList().size()));
        for (int j = 0; j < 8; ++j) {
            input = input + cellphoneEntities.get(6).getList().get(random.nextInt(cellphoneEntities.get(6).getList().size()));
        }
        return input;
    }

    public static boolean check(String input) {
        return SM4FPECellPhone.isMobilephoneNo(input);
    }

    public static ArrayList<SM4FPEEntity> getSm4FPEEntities() {
        return cellphoneEntities;
    }

    static {
        int i;
        cellphoneEntities = new ArrayList();
        Security.addProvider((Provider)new BouncyCastleProvider());
        cellphoneCCStr1 = new String[]{"+1", "+7"};
        cellphoneCCStr2 = new String[]{"+20", "+27", "+30", "+31", "+32", "+33", "+34", "+36", "+39", "+40", "+41", "+43", "+44", "+45", "+46", "+47", "+48", "+49", "+51", "+52", "+53", "+54", "+55", "+56", "+57", "+58", "+60", "+61", "+62", "+63", "+64", "+65", "+66", "+81", "+82", "+84", "+86", "+90", "+91", "+92", "+93", "+94", "+95", "+98"};
        cellphoneCCStr3 = new String[]{"+212", "+213", "+216", "+218", "+220", "+221", "+222", "+223", "+224", "+225", "+226", "+227", "+228", "+229", "+230", "+231", "+232", "+233", "+234", "+235", "+236", "+237", "+238", "+239", "+240", "+241", "+242", "+244", "+245", "+247", "+248", "+249", "+250", "+251", "+252", "+253", "+254", "+255", "+256", "+257", "+258", "+259", "+260", "+261", "+262", "+263", "+264", "+265", "+266", "+267", "+268", "+269", "+290", "+291", "+297", "+298", "+299", "+350", "+351", "+352", "+353", "+354", "+355", "+356", "+357", "+358", "+359", "+370", "+371", "+372", "+373", "+374", "+375", "+376", "+377", "+378", "+380", "+381", "+385", "+386", "+387", "+389", "+420", "+421", "+423", "+500", "+501", "+502", "+503", "+504", "+505", "+506", "+507", "+508", "+509", "+590", "+591", "+592", "+593", "+595", "+596", "+597", "+598", "+599", "+672", "+674", "+675", "+676", "+677", "+678", "+679", "+680", "+682", "+683", "+685", "+686", "+687", "+688", "+689", "+691", "+692", "+850", "+852", "+853", "+855", "+856", "+880", "+886", "+960", "+961", "+962", "+963", "+964", "+965", "+966", "+967", "+968", "+972", "+973", "+974", "+975", "+976", "+977", "+992", "+993", "+994", "+995", "+996", "+998"};
        cellphoneCCStr4 = new String[]{"+1242", "+1246", "+1264", "+1268", "+1340", "+1345", "+1441", "+1473", "+1649", "+1664", "+1670", "+1671", "+1684", "+1758", "+1767", "+1784", "+1809", "+1868", "+1869", "+1876"};
        cellphoneCCStr5 = new String[]{"+14397"};
        cellphoneMACStr = new String[]{"176", "133", "182", "181", "136", "188", "152", "135", "183", "134", "158", "153", "147", "157", "170", "185", "155", "139", "131", "138", "177", "159", "156", "151", "180", "132", "150", "187", "186", "130", "137", "189", "178", "184"};
        cellphoneCCStr1Map = new HashMap();
        for (i = 0; i < cellphoneCCStr1.length; ++i) {
            cellphoneCCStr1Map.put(cellphoneCCStr1[i], i);
        }
        cellphoneCCStr2Map = new HashMap();
        for (i = 0; i < cellphoneCCStr2.length; ++i) {
            cellphoneCCStr2Map.put(cellphoneCCStr2[i], i);
        }
        cellphoneCCStr3Map = new HashMap();
        for (i = 0; i < cellphoneCCStr3.length; ++i) {
            cellphoneCCStr3Map.put(cellphoneCCStr3[i], i);
        }
        cellphoneCCStr4Map = new HashMap();
        for (i = 0; i < cellphoneCCStr4.length; ++i) {
            cellphoneCCStr4Map.put(cellphoneCCStr4[i], i);
        }
        cellphoneCCStr5Map = new HashMap();
        for (i = 0; i < cellphoneCCStr5.length; ++i) {
            cellphoneCCStr5Map.put(cellphoneCCStr5[i], i);
        }
        cellphoneMACStrMap = new HashMap();
        for (i = 0; i < cellphoneMACStr.length; ++i) {
            cellphoneMACStrMap.put(cellphoneMACStr[i], i);
        }
        cellphoneEntities.add(new SM4FPEEntity(0, SM4FPECellPhone.toArrayList(cellphoneCCStr1), cellphoneCCStr1Map, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(1, SM4FPECellPhone.toArrayList(cellphoneCCStr2), cellphoneCCStr2Map, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(2, SM4FPECellPhone.toArrayList(cellphoneCCStr3), cellphoneCCStr3Map, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(3, SM4FPECellPhone.toArrayList(cellphoneCCStr4), cellphoneCCStr4Map, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(4, SM4FPECellPhone.toArrayList(cellphoneCCStr5), cellphoneCCStr5Map, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(5, SM4FPECellPhone.toArrayList(cellphoneMACStr), cellphoneMACStrMap, SM4FPEBase.MatchType.ONCE));
        cellphoneEntities.add(new SM4FPEEntity(6, SM4FPECellPhone.toArrayList(digitChars), digitCharsMap));
        SM4FPECellPhone.checkDuplicate(cellphoneEntities);
    }
}

