/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.thkms.util.gmhelper;

import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM3Utils {
    private static final String ENCODING = "UTF-8";

    public static String encrypt(String src, String key) throws Exception {
        return ByteUtils.toHexString((byte[])SM3Utils.getEncryptByKey(src, key));
    }

    private static byte[] getEncryptByKey(String src, String key) throws Exception {
        byte[] srcByte = src.getBytes(ENCODING);
        byte[] keyByte = key.getBytes(ENCODING);
        KeyParameter keyParameter = new KeyParameter(keyByte);
        SM3Digest sm3 = new SM3Digest();
        HMac hMac = new HMac((Digest)sm3);
        hMac.init((CipherParameters)keyParameter);
        hMac.update(srcByte, 0, srcByte.length);
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }

    public static boolean verify(String src, String sm3HexStr) throws Exception {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = SM3Utils.getEncryptBySrcByte(src.getBytes(ENCODING));
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    public static boolean verify(String src, String key, String sm3HexStr) throws Exception {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = SM3Utils.getEncryptByKey(src, key);
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    private static byte[] getEncryptBySrcByte(byte[] srcByte) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        byte[] encryptByte = new byte[sm3.getDigestSize()];
        sm3.doFinal(encryptByte, 0);
        return encryptByte;
    }

    public static void main(String[] args) throws Exception {
        String srcStr = "jm_4bd0294a787b0793cdf6c6fb158a4809#jm_993eb7d065caa0acc8c118c40d93b5d3#jm_b47bef632df37a9c5ce743da5ec60c7b#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f";
        String key = "ghca";
        String hexStrByKey = SM3Utils.encrypt(srcStr, key);
        System.out.println("\u5e26\u5bc6\u94a5\u52a0\u5bc6\u540e\u7684\u5bc6\u6587\uff1a" + hexStrByKey);
        System.out.println("\u660e\u6587(\u5e26\u5bc6\u94a5)\u4e0e\u5bc6\u6587\u6821\u9a8c\u7ed3\u679c\uff1a" + SM3Utils.verify(srcStr, key, hexStrByKey));
    }
}

