/*
 * Decompiled with CFR 0.152.
 */
package util;

import bean.DataBase;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;

public class RedisUtil {
    public static final String DELIMITER = ":";
    public static final int MILLIS = 2000;

    public static byte[] serialize(Serializable object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCachingVersionKey(DataBase dataBase) {
        return dataBase.getIp_port() + ":cachingversions";
    }

    public static String getCacheVersionKey(DataBase dataBase) {
        return dataBase.getIp_port() + ":cacheversion";
    }

    public static String getPrefix(DataBase dataBase, String versionValue) {
        return dataBase.getIp_port() + DELIMITER + versionValue;
    }

    public static String getSchemaNamelistKey(DataBase dataBase, String versionValue) {
        return RedisUtil.getPrefix(dataBase, versionValue) + ":schemaNamelist";
    }

    public static String getTableNamelistKey(DataBase dataBase, String versionValue, String schemaName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + ":tableNamelist";
    }

    public static String getViewNamelistKey(DataBase dataBase, String versionValue, String schemaName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + ":viewNamelist";
    }

    public static String getSynonymNamelistKey(DataBase dataBase, String versionValue, String schemaName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + ":synonymNamelist";
    }

    public static String getTableKey(DataBase dataBase, String versionValue, String schemaName, String tableName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + DELIMITER + tableName + ":table";
    }

    public static String getViewKey(DataBase dataBase, String versionValue, String schemaName, String tableName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + DELIMITER + tableName + ":view";
    }

    public static String getSynonymKey(DataBase dataBase, String versionValue, String schemaName, String synonymName) {
        return RedisUtil.getPrefix(dataBase, versionValue) + DELIMITER + schemaName + DELIMITER + synonymName + ":synonym";
    }

    public static Table unserialize(byte[] serializedObject2) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject2);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Table table2 = (Table)ois.readObject();
            return table2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static View unserializeView(byte[] serializedObject) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            View view = (View)ois.readObject();
            return view;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Synonym unserializeSynonym(byte[] serializedObject) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Synonym synonym = (Synonym)ois.readObject();
            return synonym;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Set<String> getTableKeys(DataBase dataBase, String tableName) {
        return null;
    }
}

