/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;
import util.getdata.CacheData;

public class CacheDm
extends CacheData {
    public CacheDm(DataBase dataBase, CountDownLatch cdl) {
        super(dataBase, cdl);
    }

    @Override
    public void run() {
        System.out.println("dm\u5f00\u59cb\u7f13\u5b58");
        try {
            this.cacheWriteToRedis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                JdbcCacheUtil.closeConnection(this.connection);
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            this.getCdl().countDown();
            System.out.println("dm\u7ed3\u675f\u7f13\u5b58");
        }
    }

    @Override
    public List<Schema> cacheToMemory() throws SQLException {
        this.connection = JdbcCacheUtil.getDmConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
        this.statement = this.connection.createStatement();
        List<Schema> schemaList = this.init(this.statement);
        return schemaList;
    }

    @Override
    public List<Schema> getSchema(Statement statement) throws SQLException {
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        String sql = "select distinct OBJECT_NAME TABLE_SCHEMA from all_objects where object_type = 'SCH'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Schema schema = new Schema(resultSet.getString("TABLE_SCHEMA"));
            schema.setRealName(resultSet.getString("TABLE_SCHEMA"));
            schemaList.add(schema);
        }
        resultSet.close();
        return schemaList;
    }

    @Override
    public List<Table> getTable(Statement statement, String schema) throws SQLException {
        ArrayList<Table> tableList = new ArrayList<Table>();
        String sql = "select TABLE_NAME from dba_tables where owner='" + schema + "' and TABLESPACE_NAME<>'TEMP'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Table table = new Table(resultSet.getString("TABLE_NAME"), schema);
            table.setRealName(resultSet.getString("TABLE_NAME"));
            tableList.add(table);
        }
        resultSet.close();
        return tableList;
    }

    @Override
    public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
        ArrayList<Column> columnList = new ArrayList<Column>();
        String sql = "  select \t\n\ta.owner,\n\ta.table_name,\n\ta.column_name,\n\ta.data_type,\n\ta.data_length as length,\n\ta.data_precision as scale,\t\n\tcase when instr(a.data_type,'(')>0 then a.data_type else a.data_type || '(' || a.data_length || (\n\t\tcase when a.data_precision is null then '' else ',' || a.data_precision end \n\t) || ')' end as column_type , '' as remark, nvl(c.pk,0) pk\nfrom all_tab_columns A\nLEFT JOIN (\n select A.OWNER,A.TABLE_NAME,B.COLUMN_NAME,1 PK from \"SYS\".\"DBA_CONSTRAINTS\" a \n left join \"SYS\".\"DBA_CONS_COLUMNS\" b \n on a.OWNER=b.OWNER AND a.CONSTRAINT_NAME=a.CONSTRAINT_NAME\n and a.table_name=b.table_name\n where a.constraint_type='P'\n)C on a.owner=c.owner and a.table_name=c.table_name and a.column_name=c.column_name\n where a.owner='" + schema + "' and a.Table_Name='" + table + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Column column = new Column();
            column.setColumnName(resultSet.getString("COLUMN_NAME"));
            column.setSchema(schema);
            column.setTable(table);
            column.setDataType(resultSet.getString("DATA_TYPE"));
            column.setColumnType(resultSet.getString("COLUMN_TYPE"));
            column.setLength(resultSet.getObject("LENGTH") + "");
            Object scale = resultSet.getObject("SCALE");
            column.setDigits(scale == null ? "" : scale.toString());
            String remark = resultSet.getString("REMARK");
            column.setRemark(remark == null ? "" : remark);
            column.setPk(resultSet.getInt("PK"));
            columnList.add(column);
        }
        resultSet.close();
        return columnList;
    }

    @Override
    public List<View> getView(Statement statement, String schema) throws SQLException {
        ArrayList<View> views = new ArrayList<View>();
        String sql = "select VIEW_NAME ,TEXT from DBA_VIEWS where OWNER = '" + schema + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String table_name = resultSet.getString("VIEW_NAME");
            String view_definition = resultSet.getString("TEXT").replaceAll("`", "");
            views.add(new View(table_name, view_definition));
        }
        resultSet.close();
        return views;
    }

    public List<Synonym> getSynonym(Statement statement, String schema) throws SQLException {
        ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
        String sql = "SELECT SYNONYM_NAME , TABLE_NAME FROM DBA_SYNONYMS WHERE TABLE_OWNER = '" + schema + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String SYNONYM_NAME = resultSet.getString("SYNONYM_NAME");
            String TABLE_NAME = resultSet.getString("TABLE_NAME");
            synonyms.add(new Synonym(SYNONYM_NAME, TABLE_NAME));
        }
        resultSet.close();
        return synonyms;
    }

    public List<Schema> init(Statement statement) throws SQLException {
        ArrayList schemas = this.getSchema(statement);
        if (schemas != null && schemas.size() != 0) {
            List<Table> tables = this.getTables(statement);
            List<View> views = this.getViews(statement);
            List<Synonym> synonyms = this.getSynonyms(statement);
            for (Schema schema : schemas) {
                ArrayList<Table> tbs = new ArrayList<Table>();
                for (Table table : tables) {
                    if (!table.getSchema().equals(schema.getName())) continue;
                    tbs.add(table);
                }
                schema.setTableList(tbs);
                ArrayList<View> vws = new ArrayList<View>();
                for (View x3 : views) {
                    if (!x3.getSchema().equals(schema.getName())) continue;
                    vws.add(x3);
                }
                schema.setViewList(vws);
                ArrayList<Synonym> arrayList = new ArrayList<Synonym>();
                for (Synonym x4 : synonyms) {
                    if (!x4.getSchema().equals(schema.getName())) continue;
                    arrayList.add(x4);
                }
                schema.setSynonymList(arrayList);
            }
            return schemas == null ? new ArrayList() : schemas;
        }
        return new ArrayList<Schema>();
    }

    public List<View> getViews(Statement statement) throws SQLException {
        ArrayList<View> views = new ArrayList<View>();
        String sql = "select OWNER,VIEW_NAME ,TEXT from DBA_VIEWS";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String schema = resultSet.getString("OWNER");
            String table_name = resultSet.getString("VIEW_NAME");
            String view_definition = resultSet.getString("TEXT").replaceAll("`", "");
            views.add(new View(schema, table_name, view_definition));
        }
        resultSet.close();
        return views;
    }

    public List<Synonym> getSynonyms(Statement statement) throws SQLException {
        ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
        String sql = "SELECT OWNER, SYNONYM_NAME , TABLE_NAME FROM DBA_SYNONYMS  ";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String SYNONYM_NAME = resultSet.getString("SYNONYM_NAME");
            String TABLE_NAME = resultSet.getString("TABLE_NAME");
            String SCHEMA_NAME = resultSet.getString("OWNER");
            synonyms.add(new Synonym(SCHEMA_NAME, TABLE_NAME, SYNONYM_NAME));
        }
        resultSet.close();
        return synonyms;
    }

    public List<Table> getTables(Statement statement) throws SQLException {
        new ArrayList();
        String sql = "  select \t\n\ta.owner,\n\ta.table_name,\n\ta.column_name,\n\ta.data_type,\n\ta.data_length as length,\n\ta.data_precision as scale,\t\n\tcase when instr(a.data_type,'(')>0 then a.data_type else a.data_type || '(' || a.data_length || (\n\t\tcase when a.data_precision is null then '' else ',' || a.data_precision end \n\t) || ')' end as column_type , '' as remark, nvl(c.pk,0) pk\nfrom all_tab_columns A\nleft join (\n select distinct A.OWNER,A.TABLE_NAME,B.COLUMN_NAME,1 PK from \"SYS\".\"DBA_CONSTRAINTS\" a \n left join \"SYS\".\"DBA_CONS_COLUMNS\" b \n on a.OWNER=b.OWNER and a.CONSTRAINT_NAME=a.CONSTRAINT_NAME\n and a.table_name=b.table_name\n where a.constraint_type='P'\n)C on a.owner=c.owner and a.table_name=c.table_name and a.column_name=c.column_name\norder by a.owner,a.table_name,a.column_id\n";
        ArrayList<Table> tables = new ArrayList<Table>();
        Table table = null;
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String schema = resultSet.getString("OWNER");
            String tableName = resultSet.getString("TABLE_NAME");
            if (table == null || !table.getName().equals(tableName) || !table.getSchema().equals(schema)) {
                table = new Table(tableName, schema);
                table.setRealName(tableName);
                table.setColumnList(new ArrayList<Column>());
                tables.add(table);
            }
            Column column = new Column();
            column.setSchema(schema);
            column.setTable(tableName);
            column.setColumnName(resultSet.getString("COLUMN_NAME"));
            column.setDataType(resultSet.getString("DATA_TYPE"));
            column.setColumnType(resultSet.getString("COLUMN_TYPE"));
            column.setLength(resultSet.getObject("LENGTH") + "");
            Object scale = resultSet.getObject("SCALE");
            column.setDigits(scale == null ? "" : scale.toString());
            String remark = resultSet.getString("REMARK");
            column.setRemark(remark == null ? "" : remark);
            column.setPk(resultSet.getInt("PK"));
            table.getColumnList().add(column);
        }
        resultSet.close();
        return tables;
    }
}

