/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatabaseCache {
    private DataBase dataBase;
    private Set<String> columns;
    private Map<String, Schema> schemas;
    private Map<String, Synonym> synonyms;
    private Map<String, Table> tables;
    private Map<String, View> views;
    private boolean ignoreCase = false;

    public DatabaseCache(DataBase dataBase) {
        this.dataBase = dataBase;
        this.schemas = new HashMap<String, Schema>();
        this.columns = new HashSet<String>();
        this.tables = new HashMap<String, Table>();
        this.synonyms = new HashMap<String, Synonym>();
        this.views = new HashMap<String, View>();
        this.ignoreCase = !dataBase.isCaseSensitive();
    }

    public DatabaseCache(DataBase dataBase, boolean ignoreCase) {
        this(dataBase);
        this.ignoreCase = ignoreCase;
    }

    public DataBase getDataBase() {
        return this.dataBase;
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public Map<String, View> getViews() {
        return this.views;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void init() {
        if (this.dataBase.getSchemaList() != null) {
            for (Schema schema : this.dataBase.getSchemaList()) {
                List<View> views;
                if (schema == null) continue;
                List<Synonym> synonymList = schema.getSynonymList();
                if (synonymList != null && synonymList.size() > 0) {
                    for (Synonym synonym : synonymList) {
                        this.synonyms.put(synonym.getSchema() + "." + synonym.getName(), synonym);
                    }
                }
                if ((views = schema.getViewList()) != null && views.size() > 0) {
                    for (View view : views) {
                        String viewId = this.getSchemaTableId(view.getSchema(), view.getName());
                        this.views.put(viewId, view);
                    }
                }
                this.schemas.put(this.getId(schema.getName()), schema);
                if (schema.getTableList() == null) continue;
                for (Table table : schema.getTableList()) {
                    if (table == null) continue;
                    String key = this.getSchemaTableId(schema.getName(), table.getName());
                    this.tables.put(key, table);
                    if (table.getColumnList() == null) continue;
                    for (Column column : table.getColumnList()) {
                        String name = schema.getName() + "." + table.getName() + "." + column.getColumnName();
                        this.columns.add(name);
                    }
                }
            }
        }
    }

    public Schema getSchema(String schemaName) {
        String key = this.getId(schemaName);
        return this.schemas.get(key);
    }

    public List<Column> getColumns(String schemaName, String tableName) {
        String key = this.getSchemaTableId(schemaName, tableName);
        Table table = this.tables.get(key);
        return table == null ? null : table.getColumnList();
    }

    public String getSchemaTableId(String schemaName, String tableName) {
        return this.getId(schemaName + "--->" + tableName);
    }

    public String getId(String key) {
        return this.ignoreCase ? key.toLowerCase() : key;
    }

    public Map<String, Synonym> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Map<String, Synonym> synonyms) {
        this.synonyms = synonyms;
    }

    public boolean containsColumn(String name) {
        return this.columns.contains(name);
    }
}

