/*
 * Decompiled with CFR 0.152.
 */
package util.log;

import java.util.concurrent.LinkedBlockingQueue;
import util.log.LogInfo;
import util.log.LogMsg;
import util.log.LogWriter;

public class LogHandler {
    private LinkedBlockingQueue<LogMsg> queue;
    private final LogWriter writer;
    private final String name;

    public LogHandler(String name, LinkedBlockingQueue<LogMsg> queue) {
        this.name = name;
        this.queue = queue;
        String logfile = "sql_" + name + ".log";
        this.writer = new LogWriter(logfile);
    }

    public boolean write(LogInfo data) {
        if (this.writer.open()) {
            byte[] bytes = data.buffer();
            if (bytes == null) {
                return false;
            }
            LogMsg msg = new LogMsg();
            msg.data = bytes;
            msg.writer = this.writer;
            msg.name = this.name;
            msg.state = true;
            this.queue.add(msg);
            return true;
        }
        return false;
    }

    public void close() {
        LogMsg msg = new LogMsg();
        msg.data = null;
        msg.writer = this.writer;
        msg.name = this.name;
        msg.state = false;
        this.queue.add(msg);
    }
}

