/*
 * Decompiled with CFR 0.152.
 */
package util.log;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import util.log.LogConfig;
import util.log.SQLLogger;

public class LogWriter {
    private String logfile;
    private int state = 0;
    private RandomAccessFile file;
    private boolean closed = false;

    public LogWriter(String logfile) {
        this.logfile = logfile;
    }

    public boolean open() {
        if (this.state == 1) {
            return true;
        }
        try {
            String dir = "";
            try {
                File directory;
                dir = LogConfig.getDirectory();
                if (dir != null && !dir.endsWith("/") && !(directory = new File(dir = dir + "/")).exists()) {
                    try {
                        directory.mkdirs();
                    }
                    catch (Exception ex) {
                        SQLLogger.log(ex.getMessage());
                    }
                }
                if (dir == null) {
                    dir = "";
                }
            }
            catch (Exception ex) {
                SQLLogger.log(ex.getMessage());
            }
            this.state = 1;
            this.file = new RandomAccessFile(dir + this.logfile, "rw");
            this.file.seek(this.file.length());
            return true;
        }
        catch (Exception e) {
            SQLLogger.log(e.getMessage());
            return false;
        }
    }

    public boolean write(byte[] buffer) {
        try {
            this.file.write(buffer);
            return true;
        }
        catch (Exception e) {
            SQLLogger.log(e.getMessage());
            return false;
        }
    }

    public void close() {
        try {
            this.state = -1;
            this.closed = true;
            this.file.close();
        }
        catch (IOException e) {
            SQLLogger.log(e.getMessage());
        }
    }

    public void flush() {
        if (this.closed) {
            this.close();
        }
    }
}

