/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.common;

import bean.Column;
import bean.DataBase;
import bean.Table;
import bean.View;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import util.log.SQLLogger;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.names.NameWrapper;

public class Context {
    private DataBase dataBase;
    private String schema;
    public TableStat.Mode sqlType;
    private static Map<String, Map<String, SQLSelect>> cacheSchemaViewMap;
    private final Map<String, TableInfo> tableMap;
    private String dbType;
    private static Set<String> errorViews;
    private static ReadWriteLock errorLock;
    private NameWrapper nameWrapper;

    public Context() {
        cacheSchemaViewMap = new HashMap<String, Map<String, SQLSelect>>();
        this.tableMap = new HashMap<String, TableInfo>();
    }

    public void initialize(DataBase db, String sch, String dbType) {
        this.dataBase = db;
        this.schema = sch;
        this.dbType = dbType;
        this.nameWrapper = NameWrapper.create(DbType.of(dbType), this.dataBase.simpleCache);
    }

    private SQLSelect parseView(View view) {
        if (view.getCreate_sql() != null && view.getCreate_sql().length() > 0) {
            try {
                List<SQLStatement> statements = SQLUtils.parseStatements(view.getCreate_sql(), this.dbType);
                if (statements.size() > 0) {
                    SQLStatement statement = statements.get(0);
                    if (statement instanceof SQLCreateViewStatement) {
                        SQLCreateViewStatement vst = (SQLCreateViewStatement)statement;
                        SQLSelect select = vst.getSubQuery();
                        return select;
                    }
                    if (statement instanceof SQLSelectStatement) {
                        SQLSelectStatement selectStatement = (SQLSelectStatement)statement;
                        SQLSelect select = selectStatement.getSelect();
                        return select;
                    }
                }
            }
            catch (Exception e) {
                SQLLogger.log(e.getMessage());
            }
        }
        return null;
    }

    public List<Column> getColumns(String schemaName, String tableName) {
        if (this.dataBase == null) {
            return new ArrayList<Column>();
        }
        NameWrapper wrapper = NameWrapper.create(DbType.of(this.dataBase.getDbType()), this.dataBase.simpleCache);
        Table table = wrapper.getTable(schemaName, tableName);
        return table != null && table.getColumnList().size() > 0 ? table.getColumnList() : new ArrayList<Column>();
    }

    public DataBase getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(DataBase dataBase) {
        this.dataBase = dataBase;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<TableInfo> getTables() {
        return new ArrayList<TableInfo>(this.tableMap.values());
    }

    public Map<String, TableInfo> getTableMap() {
        return this.tableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLSelect getView(String schema, String name) {
        try {
            errorLock.readLock().lock();
            Map<String, SQLSelect> viewMap = cacheSchemaViewMap.get(schema);
            if (viewMap != null) {
                SQLSelect var4;
                SQLSelect sQLSelect = var4 = viewMap.get(name);
                return sQLSelect;
            }
        }
        finally {
            errorLock.readLock().unlock();
        }
        View view = this.nameWrapper.getView(schema, name);
        if (view != null && view.getCreate_sql() != null && !view.getCreate_sql().isEmpty()) {
            SQLSelect var6;
            SQLSelect sqlSelect = this.parseView(view);
            try {
                errorLock.writeLock().lock();
                Map<String, SQLSelect> map = cacheSchemaViewMap.get(schema);
                if (map == null) {
                    map = new HashMap<String, SQLSelect>();
                    cacheSchemaViewMap.put(schema, map);
                }
                map.put(name, sqlSelect);
                var6 = sqlSelect;
            }
            finally {
                errorLock.writeLock().unlock();
            }
            return var6;
        }
        return null;
    }

    public void append(TableMemo tableMemo) {
        tableMemo.atom = true;
        String name = tableMemo.getAtomName();
        if (!this.tableMap.containsKey(name)) {
            TableInfo table = new TableInfo();
            table.setTable(tableMemo);
            this.tableMap.put(name, table);
            table.addMemo(tableMemo);
        } else {
            TableInfo table = this.tableMap.get(name);
            table.addMemo(tableMemo);
        }
    }

    public String getDbType() {
        return this.dbType;
    }

    static {
        errorViews = new HashSet<String>();
        errorLock = new ReentrantReadWriteLock(true);
    }
}

