/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.common.scope;

import bean.Column;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.ID;
import util.sqlparse.visitor.common.Owner;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.memo.ValueMemo;
import util.sqlparse.visitor.common.scope.ClauseScope;
import util.sqlparse.visitor.common.scope.ReplaceInfo;
import util.sqlparse.visitor.common.scope.TableScope;
import util.sqlparse.visitor.common.utils.SeqMap;

public class Scope
extends ID {
    public static final int SUCCESS_CODE = 0;
    private static final String ALL_COLUMN_START = "*";
    public static final int ERROR_CODE = -1;
    public List<SQLResult> results = new ArrayList<SQLResult>();
    public Context context;
    protected Scope current = this;
    public Scope parent;
    public SQLObject ref;
    protected List<Scope> children = new ArrayList<Scope>();
    protected Set<String> schemas = new HashSet<String>(6);
    private boolean fieldState;
    public boolean fromField;
    public boolean top = false;
    public boolean join = false;
    public ScopeDialector dialector;
    protected SeqMap<String, FieldMemo> fieldMap = new SeqMap();
    protected SeqMap<String, TableMemo> tableMap = new SeqMap();
    protected List<ValueMemo> values = new ArrayList<ValueMemo>();
    private boolean debug = false;
    public boolean union = false;
    public boolean isolated = true;
    public boolean isCheckIsolated = false;
    public ReplaceInfo replaceInfo;

    public boolean isFieldState() {
        return this.fieldState;
    }

    public void openFieldState() {
        this.fieldState = true;
    }

    public void closeFieldState() {
        this.fieldState = false;
    }

    public void addTable(TableMemo table) {
        String qualified = table.getQualifiedName();
        if (!this.tableMap.containsKey(qualified)) {
            this.tableMap.put(qualified, table);
        }
    }

    public void addTableCheckConflict(TableMemo table) {
        this.removeTableConflict(table);
        this.addTable(table);
    }

    public void removeTableConflict(TableMemo table) {
        String qualified = table.getQualifiedName();
        if (this.tableMap.containsKey(qualified)) {
            TableMemo existTable = (TableMemo)this.tableMap.get(qualified);
            if (!existTable.atom) {
                return;
            }
            if (this.isEqual(existTable.name, existTable.alias) && !this.isEqual(table.name, table.alias)) {
                this.tableMap.remove(qualified);
                this.removeTableScopeRelation(qualified);
                if (existTable.atom) {
                    this.current.context.getTableMap().remove(existTable.getAtomName());
                }
            }
        }
    }

    private void removeTableScopeRelation(String qualified) {
        TableMemo parentTable;
        TableScope tableScope = this.current.getNearestParentTableScope();
        if (tableScope != null && (parentTable = tableScope.table) != null) {
            for (int i = 0; i < parentTable.getChildren().size(); ++i) {
                TableMemo temp = parentTable.getChildren().get(i);
                if (!this.isEqual(temp.getQualifiedName(), qualified)) continue;
                parentTable.getChildren().remove(i);
            }
        }
    }

    public FieldMemo addField(FieldMemo field) {
        field.scope = this;
        new FieldMemo();
        if (this.dialector.addField(field)) {
            return field;
        }
        String qualifiedName = field.getQualifiedName();
        if (!this.fieldMap.containsKey(qualifiedName)) {
            this.fieldMap.put(qualifiedName, field);
            return field;
        }
        FieldMemo fieldInfo = (FieldMemo)this.fieldMap.get(qualifiedName);
        if (field.isSelectItem) {
            fieldInfo.isSelectItem = true;
            fieldInfo.id = field.id;
        }
        if (field.atom) {
            fieldInfo.atom = field.atom;
        }
        fieldInfo.exprs.addAll(field.exprs);
        fieldInfo.aliasFields.addAll(field.aliasFields);
        field.children.remove(fieldInfo);
        this.mergeChildren(field, fieldInfo);
        return fieldInfo;
    }

    private void mergeChildren(FieldMemo field, FieldMemo fieldInfo) {
        for (FieldMemo temp : field.children) {
            FieldMemo find = null;
            for (FieldMemo x : fieldInfo.children) {
                if (!this.isEqual(x.getQualifiedName(), temp.getQualifiedName())) continue;
                find = x;
                break;
            }
            if (find != null || fieldInfo == temp || this.isEqual(fieldInfo.getQualifiedName(), temp.getQualifiedName())) continue;
            fieldInfo.children.add(temp);
        }
    }

    public void enterScope(Scope scope) {
        this.current.append(scope);
        if (this.debug) {
            System.out.println("[E]" + this.current.id + "->" + scope.id + "     " + scope.ref.getClass().toString() + "\n     " + scope.ref);
        }
        this.current = scope;
        if (this.dialector != null) {
            this.current.dialector = this.dialector.clone(this.current);
        }
    }

    public void reset() {
        this.current = this;
    }

    public void enterScope(SQLObject sqlObject) {
        for (Scope child : this.current.children) {
            if (!child.ref.equals(sqlObject)) continue;
            if (this.debug) {
                System.out.println("[E]" + this.current.id + "->" + child.id + "     " + child.ref.getClass().toString() + "\n     " + child.ref);
            }
            this.current = child;
            return;
        }
    }

    public Scope getScope(SQLObject sqlObject) {
        for (Scope child : this.current.children) {
            if (!child.ref.equals(sqlObject)) continue;
            return child;
        }
        return null;
    }

    public void exitScope() {
        if (this.debug) {
            if (this.current.parent != null) {
                System.out.println("[X]" + this.current.id + "->" + this.current.parent.id + "     " + this.current.ref.getClass().toString());
            } else {
                System.out.println("[X]" + this.current.id + "->root");
            }
        }
        this.current = this.current.parent;
        if (this.current == null) {
            this.current = this;
        }
    }

    public void append(Scope child) {
        this.children.add(child);
        child.context = this.context;
        child.parent = this.current;
        child.isCheckIsolated = this.isCheckIsolated;
    }

    public Scope getCurrent() {
        return this.current;
    }

    public String getDefaultSchema() {
        return this.context.getSchema();
    }

    public boolean isPrimitive(SQLExpr expr) {
        List<SQLExpr> exprs;
        if (expr instanceof SQLSubqueryTableSource) {
            return false;
        }
        if (expr instanceof SQLMethodInvokeExpr && (exprs = ((SQLMethodInvokeExpr)expr).getArguments()).size() > 0) {
            for (SQLExpr sqlExpr : exprs) {
                if (this.isPrimitive(sqlExpr)) continue;
                return false;
            }
        }
        if (expr instanceof SQLCaseExpr) {
            SQLCaseExpr caseExpr = (SQLCaseExpr)expr;
            for (SQLCaseExpr.Item item : caseExpr.getItems()) {
                if (this.isPrimitive(item.getConditionExpr()) || !this.isPrimitive(item.getValueExpr())) continue;
                return false;
            }
        }
        if (!(expr instanceof SQLBinaryOpExpr)) {
            if (expr instanceof SQLInSubQueryExpr) {
                return false;
            }
            if (expr instanceof SQLExistsExpr) {
                return false;
            }
            return !(expr instanceof SQLQueryExpr);
        }
        SQLBinaryOpExpr opExpr = (SQLBinaryOpExpr)expr;
        SQLExpr left = opExpr.getLeft();
        SQLExpr right = opExpr.getRight();
        return this.isPrimitive(left) && this.isPrimitive(right);
    }

    public boolean isAllColumn(SQLExpr x) {
        SQLIdentifierExpr identifierExpr;
        if (x instanceof SQLAllColumnExpr) {
            return true;
        }
        if (x instanceof SQLPropertyExpr) {
            SQLPropertyExpr prop = (SQLPropertyExpr)x;
            if (prop.getName() == null) {
                return false;
            }
            if (prop.getName().equals(ALL_COLUMN_START)) {
                return true;
            }
        }
        return x instanceof SQLIdentifierExpr && (identifierExpr = (SQLIdentifierExpr)x).getName().equals(ALL_COLUMN_START);
    }

    public TableMemo getTable(SQLObject x) {
        ArrayList<Scope> feet = new ArrayList<Scope>();
        TableMemo table = this.getTableRecursive(x, feet);
        if (table == null) {
            if (this.tableMap.size() <= 0) {
                return this.getTableDownStream(x, feet);
            }
            Iterator var4 = this.tableMap.entrySet().iterator();
            if (var4.hasNext()) {
                Map.Entry stringTableMemoEntry = var4.next();
                return (TableMemo)stringTableMemoEntry.getValue();
            }
        }
        return table;
    }

    private TableMemo getTableDownStream(SQLObject x, List<Scope> feet) {
        for (Scope child : this.children) {
            TableMemo table = child.getTable(x);
            if (table != null) {
                return table;
            }
            table = this.getTableDownStream(x, feet);
            if (table == null) continue;
            return null;
        }
        return null;
    }

    private TableMemo getTableRecursive(SQLObject x, List<Scope> feet) {
        ArrayList<TableMemo> path;
        Feet ft;
        String name = null;
        SQLExpr ownerExpr = null;
        if (x instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr idExpr = (SQLIdentifierExpr)x;
            name = idExpr.getName();
        } else if (x instanceof SQLPropertyExpr) {
            SQLPropertyExpr propExpr = (SQLPropertyExpr)x;
            name = propExpr.getName();
            ownerExpr = propExpr.getOwner();
        } else if (x instanceof SQLNullExpr) {
            SQLNullExpr nullExpr = (SQLNullExpr)x;
            name = nullExpr.toString();
        }
        Owner owner = this.getOwner(ownerExpr);
        if (owner.table != null) {
            String ns = owner.getQualifiedName();
            Iterator table = null;
            for (Iterator z : this.tableMap.values()) {
                if (!this.isEqual(((TableMemo)((Object)z)).alias, owner.table)) continue;
                table = z;
                break;
            }
            if (table != null) {
                return table;
            }
            ArrayList<Scope> subScopes = new ArrayList<Scope>();
            for (Scope z : this.children) {
                if (z.fromField) continue;
                subScopes.add(z);
            }
            for (Scope sub : subScopes) {
                if (sub.isCheckIsolated && sub.isolated || !sub.tableMap.containsKey(ns)) continue;
                return (TableMemo)sub.tableMap.get(ns);
            }
            if (this.parent != null) {
                return this.parent.getTableRecursive(x, feet);
            }
            return null;
        }
        for (TableMemo table : this.tableMap.values()) {
            FieldMemo fieldRef;
            if (table.atom) {
                for (Column column : this.context.getColumns(table.schema, table.name)) {
                    if (!this.isEqual(column.getColumnName(), name)) continue;
                    return table;
                }
            }
            if (table.refTable == null || table.refTable.scope == null || (fieldRef = table.refTable.scope.getFieldByAlias(name)) == null) continue;
            return table;
        }
        if (this.children != null && this.children.size() > 0 && (ft = this.getFieldByAliasBranch(name, path = new ArrayList<TableMemo>())) != null && ft.path.size() > 0) {
            return ft.path.get(0);
        }
        if (this.parent != null) {
            return this.parent.getTableRecursive(x, feet);
        }
        return null;
    }

    private Feet getFieldByAliasBranch(String name, List<TableMemo> path) {
        for (Scope child : this.children) {
            Feet feet;
            if (child.top || child.fromField || child.isCheckIsolated && child.isolated) continue;
            if (child.fieldMap.size() > 0) {
                FieldMemo field = child.getFieldByAliasInternal(name);
                if (field == null) continue;
                feet = new Feet();
                feet.field = field;
                feet.path = path;
                return feet;
            }
            if (child.children.size() <= 0) continue;
            ArrayList<TableMemo> paths = new ArrayList<TableMemo>(path);
            if (child instanceof TableScope) {
                paths.add(((TableScope)child).table);
            }
            if ((feet = child.getFieldByAliasBranch(name, paths)) == null) continue;
            return feet;
        }
        return null;
    }

    private FieldMemo getFieldByAliasInternal(String name) {
        if (name == null) {
            return null;
        }
        for (FieldMemo value : this.fieldMap.values()) {
            if (!this.isEqual(name, value.alias)) continue;
            return value;
        }
        return null;
    }

    public ValueMemo getFieldValueInfo(SQLExpr expr) {
        if (expr == null) {
            return null;
        }
        FieldMemo field = this.getFieldByExpr(expr);
        if (field != null) {
            ValueMemo value = new ValueMemo();
            value.field = field;
            value.ref = expr;
            return value;
        }
        return null;
    }

    public List<SQLExpr> getSubFieldExprs(SQLExpr x) {
        ArrayList<SQLExpr> exprs = new ArrayList<SQLExpr>();
        this.getSubFieldExprs(x, exprs);
        return exprs;
    }

    private void getSubFieldExprs(SQLObject x, List<SQLExpr> exprs) {
        if (!(x == null || x instanceof SQLSelectQueryBlock || x instanceof SQLInSubQueryExpr || x instanceof SQLExistsExpr || x instanceof SQLSelectQuery)) {
            SQLExpr expr;
            if (x instanceof SQLPropertyExpr) {
                exprs.add((SQLPropertyExpr)x);
            } else if (x instanceof SQLIdentifierExpr) {
                exprs.add((SQLIdentifierExpr)x);
            } else if (x instanceof OracleSysdateExpr) {
                exprs.add((OracleSysdateExpr)x);
            } else if (x instanceof SQLOver) {
                SQLOver over = (SQLOver)x;
                this.getSubFieldExprsByExprs(over.getPartitionBy(), exprs);
                this.getSQLOrderExprs(over.getOrderBy(), exprs);
                this.getSQLOrderExprs(over.getDistributeBy(), exprs);
                this.getSQLOrderExprs(over.getSortBy(), exprs);
                this.getSubFieldExprs(over.getWindowingBetweenBegin());
                this.getSubFieldExprs(over.getWindowingBetweenEnd());
            } else if (x instanceof SQLCaseExpr.Item) {
                SQLCaseExpr.Item item = (SQLCaseExpr.Item)x;
                this.getSubFieldExprs(item.getConditionExpr(), exprs);
                this.getSubFieldExprs(item.getValueExpr(), exprs);
            } else if (x instanceof SQLExpr && (expr = (SQLExpr)x).getChildren() != null && expr.getChildren().size() > 0) {
                for (SQLObject sqlObject : expr.getChildren()) {
                    this.getSubFieldExprs(sqlObject, exprs);
                }
            }
        }
    }

    private void getSQLOrderExprs(SQLOrderBy order, List<SQLExpr> exprs) {
        if (order != null) {
            for (SQLSelectOrderByItem item : order.getItems()) {
                exprs.addAll(this.getSubFieldExprs(item.getExpr()));
            }
        }
    }

    private void getSubFieldExprsByExprs(List<SQLExpr> sqlExprs, List<SQLExpr> exprs) {
        if (sqlExprs != null) {
            for (SQLExpr sqlExpr : sqlExprs) {
                this.getSubFieldExprs(sqlExpr, exprs);
            }
        }
    }

    public Owner getOwner(SQLObject x) {
        Owner owner = new Owner();
        if (x == null) {
            owner.schema = this.getDefaultSchema();
        }
        if (x instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr idExpr = (SQLIdentifierExpr)x;
            owner.table = this.dialector.wrap(idExpr.getName());
            owner.schema = this.dialector.wrap(this.getDefaultSchema());
        } else if (x instanceof SQLPropertyExpr) {
            SQLPropertyExpr propExpr = (SQLPropertyExpr)x;
            owner.table = this.dialector.wrap(propExpr.getName());
            owner.schema = this.dialector.wrap(propExpr.getOwnerName());
        } else if (x instanceof SQLAllColumnExpr) {
            owner.table = null;
            owner.schema = this.dialector.wrap(this.getDefaultSchema());
        }
        return owner;
    }

    public Owner getAllOwner(SQLExpr e) {
        Owner owner = new Owner();
        owner.schema = this.getDefaultSchema();
        if (e instanceof SQLAllColumnExpr) {
            owner.schema = this.context.getSchema();
        } else if (e instanceof SQLPropertyExpr) {
            SQLPropertyExpr propExpr = (SQLPropertyExpr)e;
            SQLExpr expr = propExpr.getOwner();
            if (expr instanceof SQLIdentifierExpr) {
                owner.alias = ((SQLIdentifierExpr)expr).getName();
            } else {
                owner.alias = ((SQLPropertyExpr)expr).getName();
                owner.schema = ((SQLPropertyExpr)expr).getOwnerName();
            }
        }
        return owner;
    }

    public List<FieldMemo> expandAllColumns(TableMemo table, boolean isSub) {
        FieldNameList fields;
        block18: {
            block20: {
                block22: {
                    block21: {
                        block19: {
                            boolean continueExpand;
                            fields = new FieldNameList();
                            if (this.dialector != null && !(continueExpand = this.dialector.expandAllColumns(table, isSub, fields))) {
                                return fields;
                            }
                            if (table != null) break block19;
                            ArrayList<TableMemo> topTables = new ArrayList<TableMemo>();
                            for (TableMemo tableMemo : this.tableMap.orderValues()) {
                                if (tableMemo.refTable == null) continue;
                                topTables.add(tableMemo);
                            }
                            if (topTables.size() > 0) {
                                for (TableMemo tableMemo : topTables) {
                                    List<FieldMemo> subFields = this.cloneFields(this.expandAllColumns(tableMemo.refTable, tableMemo.refTable.isSub), tableMemo, true);
                                    fields.addAll(subFields);
                                }
                            }
                            ArrayList<TableMemo> memTables = new ArrayList<TableMemo>();
                            for (TableMemo x : this.tableMap.orderValues()) {
                                if (x.isSub || x.refTable != null) continue;
                                memTables.add(x);
                            }
                            if (memTables.size() > 0) {
                                for (TableMemo memTable : memTables) {
                                    List<FieldMemo> subFields = this.cloneFields(this.expandAllColumns(memTable, memTable.isSub), memTable, false);
                                    fields.addAll(subFields);
                                }
                            }
                            for (Scope child : this.children) {
                                if (child.fromField) continue;
                                child.expandScopeColumns(fields);
                            }
                            break block18;
                        }
                        if (table.isSub) break block20;
                        if (table.refTable == null) break block21;
                        for (TableMemo childTable : table.refTable.getChildren()) {
                            if (!childTable.topTable) continue;
                            ArrayList<FieldMemo> arrayList = new ArrayList<FieldMemo>();
                            ArrayList<FieldMemo> cloneFields = new ArrayList<FieldMemo>();
                            for (FieldMemo x : childTable.scope.fieldMap.orderValues()) {
                                if (!x.isSelectItem) continue;
                                cloneFields.add(x);
                            }
                            for (FieldMemo field : cloneFields) {
                                FieldMemo cloneField = field.copy();
                                cloneField.alias = field.alias;
                                cloneField.table = table;
                                cloneField.refField = field;
                                arrayList.add(cloneField);
                            }
                            fields.addAll(arrayList);
                            return fields;
                        }
                        break block18;
                    }
                    if (!table.atom && table.scope.fieldMap.size() > 0) {
                        ArrayList<FieldMemo> fieldMemos = new ArrayList<FieldMemo>();
                        for (FieldMemo fieldMemo : table.scope.fieldMap.orderValues()) {
                            if (!fieldMemo.isSelectItem) continue;
                            fieldMemos.add(fieldMemo);
                        }
                        fields.addAll(fieldMemos);
                        return fields;
                    }
                    List<FieldMemo> tbFields = this.dialector.getColumns(table);
                    if (tbFields == null || tbFields.size() <= 0) break block22;
                    for (FieldMemo fieldMemo : tbFields) {
                        fields.add(fieldMemo);
                    }
                    break block18;
                }
                List<Column> columns = this.context.getColumns(table.schema, table.name);
                if (columns == null || columns.size() <= 0) break block18;
                for (Column column : columns) {
                    FieldMemo field = new FieldMemo();
                    field.table = table;
                    field.alias = this.current.dialector.wrapColumn(table.schema, table.name, column.getColumnName());
                    field.name = this.current.dialector.wrapColumn(table.schema, table.name, column.getColumnName());
                    field.isSelectItem = true;
                    fields.add(field);
                }
                break block18;
            }
            if (table.topTable) {
                List<FieldMemo> branchFields = this.getParentTableFields(table, table.scope);
                fields.addAll(branchFields);
            } else {
                for (Scope child : table.scope.children) {
                    child.expandScopeColumns(fields);
                    if (!table.scope.union) continue;
                    break;
                }
            }
        }
        return fields;
    }

    private List<FieldMemo> cloneFields(List<FieldMemo> fields, TableMemo table, boolean isRefField) {
        if (fields != null && fields.size() != 0) {
            ArrayList<FieldMemo> cloneFields = new ArrayList<FieldMemo>();
            for (FieldMemo fieldMemo : fields) {
                FieldMemo cloneField = fieldMemo.copy();
                cloneField.alias = fieldMemo.alias;
                cloneField.table = table;
                if (isRefField) {
                    cloneField.refField = fieldMemo;
                }
                cloneFields.add(cloneField);
            }
            return cloneFields;
        }
        return new ArrayList<FieldMemo>();
    }

    private void expandScopeColumns(List<FieldMemo> fields) {
        if (this.fieldMap.size() > 0) {
            TableScope scope = this.getNearestParentTableScope();
            ArrayList<FieldMemo> selfFields = new ArrayList<FieldMemo>();
            for (FieldMemo x : this.fieldMap.orderValues()) {
                if (!x.isSelectItem) continue;
                selfFields.add(x);
            }
            if (scope != null) {
                List<FieldMemo> subFields = this.cloneFields(selfFields, scope.table, false);
                fields.addAll(subFields);
                return;
            }
        }
        for (Scope child : this.children) {
            child.expandScopeColumns(fields);
            if (!this.union) continue;
            break;
        }
    }

    public TableMemo getParentTable(String schemaName, String table) {
        boolean childrenTop = false;
        boolean parentChildrenTop = false;
        if (this.parent != null) {
            TableMemo memo;
            String name;
            for (Scope x : this.parent.children) {
                if (!x.top) continue;
                parentChildrenTop = true;
                break;
            }
            for (Scope x : this.children) {
                if (!x.top) continue;
                childrenTop = true;
                break;
            }
            if (this.parent.tableMap.containsKey(name = this.dialector.wrap(schemaName + "." + table))) {
                return (TableMemo)this.parent.tableMap.get(name);
            }
            if (parentChildrenTop ? (memo = this.parent.getParentTopTable(name)) != null && memo.topTable : childrenTop && (memo = this.current.getParentTopTable(name)) != null && memo.topTable) {
                return memo;
            }
            if (this.parent.parent != null) {
                return this.parent.getParentTable(schemaName, table);
            }
        }
        return null;
    }

    private TableMemo getParentTopTable(String name) {
        boolean childrenTop = false;
        for (Scope child : this.children) {
            TableMemo memo;
            if (!child.top) continue;
            for (Scope x : child.children) {
                if (!x.top) continue;
                childrenTop = true;
            }
            if (child.tableMap.size() == 0 ? childrenTop && (memo = child.getParentTopTable(name)) != null && memo.topTable : (memo = (TableMemo)child.tableMap.get(name)) != null && memo.topTable) {
                return memo;
            }
            childrenTop = false;
        }
        return null;
    }

    private List<FieldMemo> getBranchTableFields(TableMemo table, Scope parent) {
        ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>();
        for (Scope child : parent.children) {
            if (child.fieldMap.size() <= 0) {
                return this.getBranchTableFields(table, child);
            }
            for (FieldMemo branchField : child.fieldMap.orderValues()) {
                if (!branchField.isSelectItem || (branchField.table == null || !branchField.table.equals(table)) && !branchField.tables.contains(table)) continue;
                FieldMemo field = branchField.copy();
                field.alias = branchField.alias;
                field.table = table;
                fields.add(field);
            }
        }
        return fields;
    }

    private List<FieldMemo> getParentTableFields(TableMemo table, Scope scope) {
        ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>();
        if (scope == null) {
            return fields;
        }
        if (scope.fieldMap.size() > 0) {
            for (FieldMemo branchField : scope.fieldMap.orderValues()) {
                if ((branchField.table == null || !branchField.table.equals(table)) && !branchField.tables.contains(table)) continue;
                FieldMemo field = branchField.copy();
                field.children.addAll(branchField.children);
                field.isSelectItem = true;
                field.refField = branchField;
                field.table = table;
                fields.add(field);
            }
        } else if (scope.parent != null) {
            fields.addAll(this.getParentTableFields(table, scope.parent));
        }
        return fields;
    }

    public List<TableMemo> getBranchTables() {
        ArrayList<TableMemo> tables = new ArrayList<TableMemo>();
        if (this.tableMap.size() > 0) {
            tables.addAll(this.tableMap.values());
        } else {
            for (Scope child : this.children) {
                tables.addAll(child.getBranchTables());
            }
        }
        return tables;
    }

    public List<FieldMemo> getBranchAllFields(TableMemo table) {
        ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>();
        for (Scope child : this.children) {
            if (child.fieldMap.size() > 0) {
                for (FieldMemo value : child.fieldMap.values()) {
                    if (table != null && !value.tables.contains(table)) continue;
                    FieldMemo field = value.copy();
                    field.table = table;
                    fields.add(field);
                }
                continue;
            }
            fields.addAll(child.getBranchAllFields(table));
        }
        return fields;
    }

    public TableScope getNearestParentTableScope() {
        Scope cursor = this;
        while (cursor != null) {
            if (cursor instanceof TableScope) {
                return (TableScope)cursor;
            }
            cursor = cursor.parent;
        }
        return null;
    }

    public void getSubBranchFields(List<FieldMemo> fields) {
        if (this.children.size() != 0) {
            for (Scope child : this.children) {
                if (child instanceof ClauseScope) {
                    fields.addAll(child.getFieldMap().values());
                    continue;
                }
                child.getSubBranchFields(fields);
            }
        }
    }

    public FieldMemo getFieldByExpr(SQLExpr expr) {
        FieldMemo field = null;
        for (FieldMemo value : this.fieldMap.values()) {
            boolean found = false;
            for (SQLObject sqlObject : value.exprs) {
                if (sqlObject != expr) continue;
                found = true;
                break;
            }
            if (!found) continue;
            field = value;
            break;
        }
        if (field != null) {
            return field;
        }
        return this.parent != null ? this.parent.getFieldByExpr(expr) : null;
    }

    public FieldMemo getFieldByName(String name) {
        FieldMemo field = this.getFieldByNameInternal(name);
        if (field != null) {
            return field;
        }
        field = this.getFieldByNameBranch(name);
        if (field != null) {
            return field;
        }
        if (this.parent != null) {
            field = this.getFieldByNameTop(name);
        }
        return field;
    }

    public FieldMemo getFieldByAlias(String name) {
        if (name != null && name.length() != 0) {
            for (FieldMemo x : this.fieldMap.values()) {
                if (x.alias == null || !this.isEqual(x.alias, name)) continue;
                return x;
            }
            return null;
        }
        return null;
    }

    private FieldMemo getFieldByNameTop(String name) {
        FieldMemo field;
        Scope child = null;
        for (Scope x : this.parent.children) {
            if (!x.top) continue;
            child = x;
            break;
        }
        if (child != null && (field = super.getFieldByNameTopBranch(name)) != null) {
            return field;
        }
        return this.parent.parent != null ? this.parent.getFieldByNameTop(name) : null;
    }

    private FieldMemo getFieldByNameTopBranch(String name) {
        if (!this.top) {
            return null;
        }
        FieldMemo field = this.getFieldByNameInternal(name);
        if (field != null) {
            return field;
        }
        if (this.fieldMap.size() == 0 && this.children.size() > 0) {
            for (Scope child : this.children) {
                if (!child.top || (field = child.getFieldByNameTopBranch(name)) == null) continue;
                return field;
            }
        }
        return null;
    }

    private FieldMemo getFieldByNameInternal(String name) {
        for (FieldMemo x : this.fieldMap.values()) {
            if (!x.isSelectItem || !this.isEqual(x.name, name)) continue;
            return x;
        }
        return null;
    }

    private FieldMemo getFieldByNameBranch(String name) {
        FieldMemo field = null;
        for (Scope child : this.children) {
            if (child.top || !(child.fieldMap.size() > 0 ? (field = child.getFieldByNameInternal(name)) != null : child.children.size() > 0 && (field = child.getFieldByNameBranch(name)) != null)) continue;
            return field;
        }
        return null;
    }

    public void getFieldsByExprs(List<SQLExpr> exprs, List<FieldMemo> fields) {
        for (SQLExpr expr : exprs) {
            FieldMemo field = this.getFieldByExpr(expr);
            if (field == null) {
                if (!this.debug) continue;
                System.out.println("null" + expr.getParent().toString());
                continue;
            }
            fields.add(field);
        }
    }

    public List<FieldMemo> getSubRelationFields(FieldMemo field) {
        FieldMemo refField;
        List<FieldMemo> relations = this.getSubRelationFieldsInternal(field);
        if (field.table != null && field.table.refTable != null && (refField = field.table.refTable.scope.getFieldByNameTopBranch(field.alias)) != null) {
            relations.add(refField);
        }
        if (relations != null) {
            for (FieldMemo relation : relations) {
                relation.outside = true;
            }
        }
        return relations;
    }

    private List<FieldMemo> getSubRelationFieldsInternal(FieldMemo field) {
        if (field.table == null) {
            return new ArrayList<FieldMemo>();
        }
        if (!field.table.isSub && !field.complex) {
            return new ArrayList<FieldMemo>();
        }
        List<FieldMemo> list = new ArrayList<FieldMemo>();
        if (!field.complex) {
            Scope tableScope;
            if (field.table == null) {
                return new ArrayList<FieldMemo>();
            }
            if (field.table.scope.isCheckIsolated && field.table.scope.join && (tableScope = this.getTableScope(field)) != null) {
                return this.getJoinSubRelationFieldsInteral(tableScope, field);
            }
            if (field.table.scope.isCheckIsolated && (tableScope = this.getTableScope(field)) != null && tableScope.union) {
                this.getUnionSubRelationFieldsInteral(tableScope, field, list);
                return list;
            }
            list = this.getSubRelationFieldsInteral(field.table.scope, field);
        } else {
            for (Scope child : this.children) {
                if (child.isCheckIsolated && child.isolated) continue;
                if (child.fieldMap.size() == 0) {
                    list.addAll(child.getSubRelationFieldsInternal(field));
                    continue;
                }
                for (FieldMemo value : child.fieldMap.values()) {
                    if (!value.alias.equals(field.name)) continue;
                    list.add(value);
                }
            }
        }
        return list;
    }

    private Scope getTableScope(FieldMemo field) {
        Scope tableScope = null;
        for (Scope child : field.table.scope.children) {
            if (field.table.ref == null || child.ref == null || !this.isEqual(field.table.ref.toString(), child.ref.toString())) continue;
            tableScope = child;
        }
        return tableScope;
    }

    private List<FieldMemo> getSubRelationFieldsInteral(Scope scope, FieldMemo field) {
        ArrayList<FieldMemo> list = new ArrayList<FieldMemo>();
        for (Scope child : scope.children) {
            if (child.isCheckIsolated && child.isolated) continue;
            if (child.isCheckIsolated && child.union) {
                this.getUnionSubRelationFieldsInteral(child, field, list);
                continue;
            }
            if (child.fieldMap.size() == 0) {
                list.addAll(child.getSubRelationFieldsInteral(child, field));
                continue;
            }
            for (FieldMemo value : child.fieldMap.values()) {
                if (field.name == null || !scope.dialector.isColumnEqual(field.name, value.alias) || !value.isSelectItem) continue;
                list.add(value);
            }
        }
        return list;
    }

    private List<FieldMemo> getJoinSubRelationFieldsInteral(Scope scope, FieldMemo field) {
        ArrayList<FieldMemo> list = new ArrayList<FieldMemo>();
        for (Scope child : scope.children) {
            if (child.isCheckIsolated && child.isolated) continue;
            if (child.union) {
                this.getUnionSubRelationFieldsInteral(child, field, list);
            } else if (child.fieldMap.size() == 0) {
                list.addAll(child.getJoinSubRelationFieldsInteral(child, field));
            } else {
                for (FieldMemo value : child.fieldMap.values()) {
                    if (field.name == null || !field.name.equals(value.alias) || !value.isSelectItem) continue;
                    list.add(value);
                }
            }
            if (list.size() <= 0) continue;
            return list;
        }
        return list;
    }

    private int getUnionSubRelationFieldsInteral(Scope scope, FieldMemo field, List<FieldMemo> list) {
        int loop = 0;
        int index = 0;
        while (scope.children.size() != loop) {
            Scope child = scope.children.get(loop);
            if (child.isCheckIsolated && child.isolated) {
                ++loop;
                continue;
            }
            if (child.fieldMap.size() == 0) {
                index = child.getUnionSubRelationFieldsInteral(child, field, list);
                if (index < 0) {
                    return index;
                }
            } else {
                ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>(child.fieldMap.values());
                if (loop == 0) {
                    index = this.getIndex(field, list, fields);
                    if (index < 0) {
                        return index;
                    }
                } else if (fields.size() > index) {
                    list.add((FieldMemo)fields.get(index));
                }
            }
            ++loop;
        }
        return index;
    }

    private int getIndex(FieldMemo field, List<FieldMemo> list, List<FieldMemo> fields) {
        for (int j = 0; j < fields.size(); ++j) {
            FieldMemo value = fields.get(j);
            if (field.name == null || !field.name.equals(value.alias) || !value.isSelectItem) continue;
            list.add(value);
            return j;
        }
        return -1;
    }

    public boolean getSubFieldsForWith(List<FieldMemo> fields) {
        for (Scope child : this.children) {
            if (child.getFieldMap().size() <= 0) continue;
            ArrayList<FieldMemo> childFields = new ArrayList<FieldMemo>();
            for (FieldMemo x : child.getFieldMap().orderValues()) {
                if (!x.isSelectItem) continue;
                childFields.add(x);
            }
            fields.addAll(childFields);
            return true;
        }
        for (Scope child : this.children) {
            if (!child.getSubFieldsForWith(fields)) continue;
            return true;
        }
        return false;
    }

    public void getUnionFieldsForWithRecursive(List<List<FieldMemo>> list) {
        for (Scope child : this.children) {
            if (child.ref instanceof SQLUnionQuery) {
                child.getUnionFieldsForWithRecursive(list);
                continue;
            }
            if (child.getFieldMap().size() <= 0) continue;
            ArrayList<FieldMemo> childFields = new ArrayList<FieldMemo>();
            for (FieldMemo x : child.getFieldMap().orderValues()) {
                if (!x.isSelectItem) continue;
                childFields.add(x);
            }
            list.add(childFields);
        }
    }

    public void getUnionFieldsForWith(List<List<FieldMemo>> unionFieldlist) {
        Scope tableScopChild;
        if (this.children.size() > 0 && (tableScopChild = this.children.get(0)) != null && tableScopChild.union) {
            tableScopChild.getUnionFieldsForWithRecursive(unionFieldlist);
        }
    }

    public boolean isFromField(SQLObject x) {
        Scope pCursor = this.parent;
        while (pCursor != null) {
            if (pCursor.fromField) {
                return true;
            }
            pCursor = pCursor.parent;
        }
        for (SQLObject cursor = x.getParent(); cursor != null; cursor = cursor.getParent()) {
            if (!(cursor instanceof SQLSelectItem)) continue;
            return true;
        }
        return false;
    }

    public final List<ValueMemo> getValues() {
        return this.values;
    }

    public SeqMap<String, FieldMemo> getFieldMap() {
        return this.fieldMap;
    }

    public SeqMap<String, TableMemo> getTableMap() {
        return this.tableMap;
    }

    public final List<Scope> getChildren() {
        return this.children;
    }

    public boolean isCaseSensitive() {
        return this.context.getDataBase() != null ? this.context.getDataBase().isCaseSensitive() : false;
    }

    private boolean isEqual(String name1, String name2) {
        return this.dialector.isEqual(name1, name2);
    }

    public ReplaceInfo getReplaceInfo() {
        return this.replaceInfo;
    }

    public void setReplaceInfo(ReplaceInfo replaceInfo) {
        this.replaceInfo = replaceInfo;
    }

    class FieldNameList
    extends ArrayList<FieldMemo> {
        Set<String> names = new HashSet<String>();

        FieldNameList() {
        }

        @Override
        public boolean add(FieldMemo field) {
            if (!this.names.contains(field.alias)) {
                super.add(field);
                this.names.add(field.alias);
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends FieldMemo> fields) {
            if (fields != null && fields.size() != 0) {
                for (FieldMemo fieldMemo : fields) {
                    this.add(fieldMemo);
                }
                return true;
            }
            return true;
        }
    }

    class Feet {
        FieldMemo field;
        List<TableMemo> path;

        Feet() {
        }
    }
}

