/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.dm;

import bean.DataBase;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropEventStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoadIndexIntoCacheStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmAlterTriggerStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmAlterViewStatment;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmCreatePackageStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmCreateSynonymStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmExecuteImmediateStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmLockTableStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmMultiInsertStatement;
import com.alibaba.druid.sql.dialect.dm.ast.stmt.DmPrintStatement;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.dm.parser.SQLStatementParser;
import util.sqlparse.visitor.dm.visitor.FormatVisitor;
import util.sqlparse.visitor.dm.visitor.ValueReplacer;
import util.sqlparse.visitor.dm.visitor.WhereVisitor;

public class SQLParser {
    public SQLResult parse(String sql, DataBase dataBase, String schema) {
        if (sql != null && sql.length() != 0) {
            return SQLStatementParser.parse(sql, dataBase, schema);
        }
        throw new IllegalArgumentException("sql");
    }

    public SQLResult parse(SQLStatement statement, DataBase dataBase, String schema) {
        if (statement == null) {
            throw new IllegalArgumentException("statement");
        }
        return SQLStatementParser.parse(statement, dataBase, schema);
    }

    public static StatementType getStatementType(SQLStatement statement) {
        if (statement instanceof SQLSelectStatement) {
            return StatementType.select;
        }
        if (statement instanceof SQLUpdateStatement) {
            return StatementType.update;
        }
        if (statement instanceof SQLDeleteStatement) {
            return StatementType.delete;
        }
        if (!(statement instanceof SQLInsertStatement) && !(statement instanceof DmMultiInsertStatement)) {
            if (statement instanceof SQLReplaceStatement) {
                return StatementType.replace;
            }
            if (statement instanceof SQLMergeStatement) {
                return StatementType.merge;
            }
            if (statement instanceof SQLTruncateStatement) {
                return StatementType.truncate;
            }
            if (statement instanceof SQLCreateTableStatement) {
                return StatementType.createTable;
            }
            if (statement instanceof SQLAlterTableStatement) {
                return StatementType.alterTable;
            }
            if (statement instanceof SQLDropTableStatement) {
                return StatementType.dropTable;
            }
            if (statement instanceof SQLCreateIndexStatement) {
                return StatementType.createIndex;
            }
            if (statement instanceof SQLAlterIndexStatement) {
                return StatementType.alterIndex;
            }
            if (statement instanceof SQLDropIndexStatement) {
                return StatementType.dropIndex;
            }
            if (statement instanceof SQLCreateViewStatement) {
                return StatementType.createView;
            }
            if (!(statement instanceof SQLAlterViewStatement) && !(statement instanceof DmAlterViewStatment)) {
                if (statement instanceof SQLDropViewStatement) {
                    return StatementType.dropView;
                }
                if (statement instanceof SQLCreateProcedureStatement) {
                    return StatementType.createProc;
                }
                if (statement instanceof SQLAlterProcedureStatement) {
                    return StatementType.alterProc;
                }
                if (statement instanceof SQLDropProcedureStatement) {
                    return StatementType.dropProc;
                }
                if (statement instanceof SQLCreateFunctionStatement) {
                    return StatementType.createFunction;
                }
                if (statement instanceof SQLAlterFunctionStatement) {
                    return StatementType.alterFunction;
                }
                if (statement instanceof SQLDropFunctionStatement) {
                    return StatementType.dropFunction;
                }
                if (statement instanceof SQLCreateTriggerStatement) {
                    return StatementType.createTrigger;
                }
                if (statement instanceof SQLDropTriggerStatement) {
                    return StatementType.dropTrigger;
                }
                if (statement instanceof DmAlterTriggerStatement) {
                    return StatementType.alterTrigger;
                }
                if (statement instanceof SQLDropEventStatement) {
                    return StatementType.dropEvent;
                }
                if (statement instanceof SQLRevokeStatement) {
                    return StatementType.revoke;
                }
                if (statement instanceof SQLGrantStatement) {
                    return StatementType.grant;
                }
                if (statement instanceof SQLCallStatement) {
                    return StatementType.callProc;
                }
                if (statement instanceof SQLShowIndexesStatement) {
                    return StatementType.showIndex;
                }
                if (statement instanceof SQLLoadIndexIntoCacheStatement) {
                    return StatementType.loadIndexIntoCache;
                }
                if (statement instanceof DmCreateSchemaStatement) {
                    return StatementType.createSchema;
                }
                if (statement instanceof DmCreateSynonymStatement) {
                    return StatementType.createSynonym;
                }
                if (statement instanceof SQLDropUserStatement) {
                    return StatementType.dropUser;
                }
                if (statement instanceof DmExecuteImmediateStatement) {
                    return StatementType.executeImmediate;
                }
                if (statement instanceof DmLockTableStatement) {
                    return StatementType.lockTable;
                }
                if (statement instanceof DmPrintStatement) {
                    return StatementType.print;
                }
                if (statement instanceof SQLSetStatement) {
                    return StatementType.set;
                }
                if (statement instanceof SQLBlockStatement) {
                    return StatementType.block;
                }
                return statement instanceof DmCreatePackageStatement ? StatementType.createPackage : StatementType.other;
            }
            return StatementType.alterView;
        }
        return StatementType.insert;
    }

    public void replace(List<ValueInfo> values, Map<String, String> replaceValue) {
        ValueReplacer replacer = new ValueReplacer(replaceValue);
        replacer.replaceValues(values);
    }

    public void replace(List<ValueInfo> values, List<Map> whereList) {
        ValueReplacer replacer = new ValueReplacer(whereList);
        replacer.replaceValuesWithList(values);
    }

    public List<String> where(String sql) {
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, DbType.dm);
        WhereVisitor visitor = new WhereVisitor();
        visitor.perform(statements);
        return visitor.getWheres();
    }

    public String format(String sql) {
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, DbType.dm);
        FormatVisitor visitor = new FormatVisitor();
        visitor.perform(statements);
        return statements.get(0).toString();
    }
}

