/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.dm.parser;

import bean.DataBase;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.dm.SQLParser;
import util.sqlparse.visitor.dm.parser.SQLStatementParser;
import util.sqlparse.visitor.dm.visitor.CompoundVisitor;
import util.sqlparse.visitor.dm.visitor.DmScopeDialector;

public class CompoundSQLStatementParser
extends SQLStatementParser {
    @Override
    public SQLResult parseStatement(SQLStatement statement, DataBase dataBase, String schema) {
        Context context = new Context();
        context.initialize(dataBase, schema, "dm");
        Scope scope = new Scope();
        scope.dialector = new DmScopeDialector(scope);
        scope.context = context;
        CompoundVisitor scopeVisitor = new CompoundVisitor(scope);
        scopeVisitor.perform(Arrays.asList(statement));
        SQLResult result = this.collectResults(scope);
        result.sqlType = TableStat.Mode.Other;
        result.statement = statement;
        result.statementType = SQLParser.getStatementType(result.statement);
        return result;
    }

    private SQLResult collectResults(Scope scope) {
        SQLResult result = new SQLResult();
        DataBase db = scope.context.getDataBase();
        HashMap<String, TableInfo> tableMap = new HashMap<String, TableInfo>();
        HashMap<String, FieldInfo> fieldMap = new HashMap<String, FieldInfo>();
        ArrayList<FieldInfo> moutputs = new ArrayList<FieldInfo>();
        ArrayList<ValueInfo> mvalues = new ArrayList<ValueInfo>();
        ArrayList<TableMemo> mtableMemos = new ArrayList<TableMemo>();
        ArrayList<FieldMemo> moutputMemos = new ArrayList<FieldMemo>();
        ArrayList<FieldMemo> mfieldMemos = new ArrayList<FieldMemo>();
        for (SQLResult sr : scope.results) {
            if (sr == null) continue;
            this.collectTables(tableMap, sr);
            this.collectFields(fieldMap, sr, scope);
            this.collectOutputs(moutputs, sr);
            this.collectTableMemos(mtableMemos, sr);
            this.collectOutputMemos(moutputMemos, sr);
            this.collectFieldMemos(mfieldMemos, sr);
        }
        result.tables = new ArrayList(tableMap.values());
        result.fields = new ArrayList(fieldMap.values());
        result.values = mvalues;
        result.tableMemos = mtableMemos;
        result.outputMemos = moutputMemos;
        result.fieldMemos = mfieldMemos;
        result.outputs = moutputs;
        return result;
    }

    private void collectTables(Map<String, TableInfo> tableMap, SQLResult sr) {
        List<TableInfo> tables = sr.tables;
        if (tables != null) {
            for (TableInfo table : tables) {
                String atomName;
                if (table == null || (atomName = table.getAtomName()) == null) continue;
                if (!tableMap.containsKey(atomName)) {
                    tableMap.put(atomName, table);
                    continue;
                }
                TableInfo t = tableMap.get(atomName);
                List<TableMemo> memos = table.getMemos();
                if (memos == null) continue;
                for (TableMemo memo : memos) {
                    t.addMemo(memo);
                }
            }
        }
    }

    private void collectFields(Map<String, FieldInfo> fieldMap, SQLResult sr, Scope scope) {
        List<FieldInfo> fields = sr.fields;
        if (fields != null) {
            for (FieldInfo field : fields) {
                if (field == null) continue;
                String name = field.fullPathName(scope.dialector);
                if (scope.context.getDataBase().simpleCache == null || !scope.context.getDataBase().containsColumn(name, scope.context.getDataBase().isCaseSensitive() && field.getName().startsWith("\"")) || name == null) continue;
                if (!fieldMap.containsKey(name)) {
                    fieldMap.put(name, field);
                    continue;
                }
                FieldInfo t = fieldMap.get(name);
                List<FieldMemo> memos = field.getMemos();
                if (memos == null) continue;
                for (FieldMemo memo : memos) {
                    t.addMemo(memo);
                }
            }
        }
    }

    private void collectTableMemos(List<TableMemo> mtableMemos, SQLResult sr) {
        List<TableMemo> tableMemos = sr.tableMemos;
        if (tableMemos != null && tableMemos.size() > 0) {
            mtableMemos.addAll(tableMemos);
        }
    }

    private void collectOutputs(List<FieldInfo> moutputs, SQLResult sr) {
        List<FieldInfo> outputs = sr.outputs;
        if (outputs != null && outputs.size() > 0) {
            moutputs.addAll(outputs);
        }
    }

    private void collectOutputMemos(List<FieldMemo> moutputMemos, SQLResult sr) {
        List<FieldMemo> outputMemos = sr.outputMemos;
        if (outputMemos != null && outputMemos.size() > 0) {
            moutputMemos.addAll(outputMemos);
        }
    }

    private void collectFieldMemos(List<FieldMemo> mfieldMemos, SQLResult sr) {
        List<FieldMemo> fieldMemos = sr.fieldMemos;
        if (fieldMemos != null && fieldMemos.size() > 0) {
            mfieldMemos.addAll(fieldMemos);
        }
    }
}

