/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import java.util.ArrayList;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonValue;
import util.sqlparse.visitor.mongo.BsonNode;
import util.sqlparse.visitor.mongo.MongoNode;

public class BsonArrayNode
extends BsonNode {
    private BsonArray value;
    public List<MongoNode> children = new ArrayList<MongoNode>();

    public BsonArrayNode() {
    }

    public BsonArrayNode(String name, BsonArray array) {
        super(name);
        this.value = array;
        for (BsonValue bsonValue : array.asArray()) {
            MongoNode node = BsonNode.create(name, bsonValue);
            node.setParent(this);
            this.children.add(node);
        }
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public void value(Object raw, Object ... other) {
        if (raw instanceof BsonArray) {
            this.value = (BsonArray)raw;
        }
    }

    public <T extends MongoNode> T get(int index) {
        return (T)this.children.get(index);
    }

    public List<MongoNode> children() {
        return this.children;
    }

    public void add(MongoNode node) {
        this.children.add(node);
        if (this.value == null) {
            this.value = new BsonArray();
        }
        this.value.add(node.data());
    }

    public void add(int index, MongoNode node) {
        this.children.add(index, node);
        if (this.value == null) {
            this.value = new BsonArray();
        }
        this.value.add(index, node.data());
    }

    public void set(int index, MongoNode node) {
        this.children.set(index, node);
        this.value.set(index, node.data());
    }

    public void remove(int index) {
        this.children.remove(index);
        this.value.remove(index);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public BsonValue data() {
        return this.value;
    }

    @Override
    public BsonNode.BsonNodeType type() {
        return BsonNode.BsonNodeType.Array;
    }

    @Override
    public BsonArrayNode clone() {
        BsonArray value = this.value.clone();
        return new BsonArrayNode(null, value);
    }

    public BsonValue getValue() {
        return this.value;
    }
}

