/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import util.sqlparse.visitor.mongo.BsonNode;

public class BsonBasicNode
extends BsonNode {
    private BsonValue value;

    public BsonValue getValue() {
        return this.value;
    }

    public void setValue(BsonValue value) {
        this.value = value;
    }

    public BsonBasicNode() {
    }

    public BsonBasicNode(String name, BsonValue value) {
        super(name);
        if (!value.isArray() && !value.isDocument()) {
            this.value = value;
        }
    }

    @Override
    public Object value() {
        if (this.value.isBinary()) {
            return this.value.asBinary().getData();
        }
        if (this.value.isBoolean()) {
            return this.value.asBoolean().getValue();
        }
        if (this.value.isDouble()) {
            return this.value.asDouble().getValue();
        }
        if (this.value.isInt64()) {
            return this.value.asInt64().getValue();
        }
        if (this.value.isInt32()) {
            return this.value.asInt32().getValue();
        }
        if (this.value.isDateTime()) {
            return this.value.asDateTime().getValue();
        }
        if (this.value.isString()) {
            return this.value.asString().getValue();
        }
        if (this.value.isDecimal128()) {
            return this.value.asDecimal128().getValue();
        }
        if (this.value.isNull()) {
            return null;
        }
        if (this.value.isTimestamp()) {
            return this.value.asTimestamp().getValue();
        }
        if (this.value.isSymbol()) {
            return this.value.asSymbol().getSymbol();
        }
        if (this.value.isObjectId()) {
            return this.value.asObjectId().getValue();
        }
        return this.value.isDBPointer() ? this.value.asDBPointer().getId() : null;
    }

    @Override
    public void value(Object raw, Object ... other) {
        if (this.value.isBinary()) {
            this.value = new BsonBinary((byte[])raw);
        } else if (this.value.isBoolean()) {
            this.value = new BsonBoolean(((Boolean)raw).booleanValue());
        } else if (this.value.isDouble()) {
            BsonDouble bsonDouble = this.value.asDouble();
            this.value = new BsonDouble(((Double)raw).doubleValue());
        } else if (this.value.isInt64()) {
            this.value = new BsonInt64(((Long)raw).longValue());
        } else if (this.value.isInt32()) {
            this.value = new BsonInt32(((Integer)raw).intValue());
        } else if (this.value.isDateTime()) {
            this.value = new BsonDateTime(((Long)raw).longValue());
        } else if (this.value.isString()) {
            this.value = new BsonString((String)raw);
        } else if (this.value.isDecimal128()) {
            this.value = new BsonDecimal128((Decimal128)raw);
        } else if (this.value.isNull()) {
            this.value = new BsonNull();
        } else if (this.value.isTimestamp()) {
            this.value = new BsonTimestamp(((Long)raw).longValue());
        } else if (this.value.isSymbol()) {
            this.value = new BsonSymbol((String)raw);
        } else if (this.value.isObjectId()) {
            this.value = new BsonObjectId((ObjectId)raw);
        } else if (this.value.isDBPointer()) {
            this.value = new BsonDbPointer((String)raw, (ObjectId)other[0]);
        }
    }

    @Override
    public BsonValue data() {
        return this.value;
    }

    @Override
    public BsonNode.BsonNodeType type() {
        return BsonNode.BsonNodeType.Basic;
    }

    @Override
    public BsonBasicNode clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

