/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import util.sqlparse.visitor.mongo.BsonArrayNode;
import util.sqlparse.visitor.mongo.BsonBasicNode;
import util.sqlparse.visitor.mongo.BsonJsNode;
import util.sqlparse.visitor.mongo.BsonJsScopeNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.Identifier;
import util.sqlparse.visitor.mongo.MongoNode;

public abstract class BsonNode
implements MongoNode {
    protected String name;
    protected MongoNode parent;

    public static MongoNode create(String name, BsonValue value) {
        BsonNode node = null;
        node = value.isDocument() ? new BsonObjectNode(name, value.asDocument()) : (value.isArray() ? new BsonArrayNode(name, value.asArray()) : (value.isJavaScript() ? new BsonJsNode(name, value.asJavaScript()) : (value.isJavaScriptWithScope() ? new BsonJsScopeNode(name, value.asJavaScriptWithScope()) : new BsonBasicNode(name, value))));
        return node;
    }

    public static MongoNode create(BsonValue value) {
        return BsonNode.create(null, value);
    }

    public BsonNode() {
    }

    public BsonNode(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public MongoNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MongoNode parent) {
        this.parent = parent;
    }

    @Override
    public boolean isKeyword() {
        if (this.name == null) {
            return false;
        }
        if (this.name.startsWith(Identifier.LSID.code)) {
            return true;
        }
        return this.name.startsWith(Identifier.DB.code) ? true : this.name.startsWith("$");
    }

    public String toString() {
        BsonValue value = this.data();
        if (value.isDocument()) {
            return this.toString(value.asDocument());
        }
        if (value.isArray()) {
            StringBuilder sb = new StringBuilder();
            for (BsonValue bsonValue : value.asArray()) {
                if (!bsonValue.isDocument()) continue;
                String json = this.toString(bsonValue.asDocument());
                sb.append(json).append("\r\n\r\n");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 4, sb.length());
            }
            return sb.toString();
        }
        return value.toString();
    }

    private String toString(BsonDocument value) {
        JsonWriterSettings settings = new JsonWriterSettings(JsonMode.RELAXED);
        return value.toJson(settings);
    }

    @Override
    public abstract BsonNodeType type();

    @Override
    public abstract MongoNode clone() throws CloneNotSupportedException;

    public static enum BsonNodeType {
        Basic,
        Key,
        Object,
        Array,
        Javascript,
        JavaScriptWithNode;

    }
}

