package com.chenyang.nse.bussiness.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource({"classpath:proxyconfig.properties"})
@ConfigurationProperties(
   prefix = "proxy"
)
public class ProxyConfig {
   String sendAppUserOriginalUri = "";
   String sendGatewayUserOriginalUri = "";
   String sendGlobalOriginalConfig = "";
   String noticeEngineAndMaskingInfoUri = "";

   public String getSendAppUserOriginalUri() {
      return this.sendAppUserOriginalUri;
   }

   public String getSendGatewayUserOriginalUri() {
      return this.sendGatewayUserOriginalUri;
   }

   public String getSendGlobalOriginalConfig() {
      return this.sendGlobalOriginalConfig;
   }

   public String getNoticeEngineAndMaskingInfoUri() {
      return this.noticeEngineAndMaskingInfoUri;
   }

   public void setSendAppUserOriginalUri(final String sendAppUserOriginalUri) {
      this.sendAppUserOriginalUri = sendAppUserOriginalUri;
   }

   public void setSendGatewayUserOriginalUri(final String sendGatewayUserOriginalUri) {
      this.sendGatewayUserOriginalUri = sendGatewayUserOriginalUri;
   }

   public void setSendGlobalOriginalConfig(final String sendGlobalOriginalConfig) {
      this.sendGlobalOriginalConfig = sendGlobalOriginalConfig;
   }

   public void setNoticeEngineAndMaskingInfoUri(final String noticeEngineAndMaskingInfoUri) {
      this.noticeEngineAndMaskingInfoUri = noticeEngineAndMaskingInfoUri;
   }

   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof ProxyConfig)) {
         return false;
      } else {
         ProxyConfig other = (ProxyConfig)o;
         if (!other.canEqual(this)) {
            return false;
         } else {
            Object this$sendAppUserOriginalUri = this.getSendAppUserOriginalUri();
            Object other$sendAppUserOriginalUri = other.getSendAppUserOriginalUri();
            if (this$sendAppUserOriginalUri == null) {
               if (other$sendAppUserOriginalUri != null) {
                  return false;
               }
            } else if (!this$sendAppUserOriginalUri.equals(other$sendAppUserOriginalUri)) {
               return false;
            }

            Object this$sendGatewayUserOriginalUri = this.getSendGatewayUserOriginalUri();
            Object other$sendGatewayUserOriginalUri = other.getSendGatewayUserOriginalUri();
            if (this$sendGatewayUserOriginalUri == null) {
               if (other$sendGatewayUserOriginalUri != null) {
                  return false;
               }
            } else if (!this$sendGatewayUserOriginalUri.equals(other$sendGatewayUserOriginalUri)) {
               return false;
            }

            Object this$sendGlobalOriginalConfig = this.getSendGlobalOriginalConfig();
            Object other$sendGlobalOriginalConfig = other.getSendGlobalOriginalConfig();
            if (this$sendGlobalOriginalConfig == null) {
               if (other$sendGlobalOriginalConfig != null) {
                  return false;
               }
            } else if (!this$sendGlobalOriginalConfig.equals(other$sendGlobalOriginalConfig)) {
               return false;
            }

            Object this$noticeEngineAndMaskingInfoUri = this.getNoticeEngineAndMaskingInfoUri();
            Object other$noticeEngineAndMaskingInfoUri = other.getNoticeEngineAndMaskingInfoUri();
            if (this$noticeEngineAndMaskingInfoUri == null) {
               if (other$noticeEngineAndMaskingInfoUri != null) {
                  return false;
               }
            } else if (!this$noticeEngineAndMaskingInfoUri.equals(other$noticeEngineAndMaskingInfoUri)) {
               return false;
            }

            return true;
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof ProxyConfig;
   }

   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      Object $sendAppUserOriginalUri = this.getSendAppUserOriginalUri();
      result = result * 59 + ($sendAppUserOriginalUri == null ? 43 : $sendAppUserOriginalUri.hashCode());
      Object $sendGatewayUserOriginalUri = this.getSendGatewayUserOriginalUri();
      result = result * 59 + ($sendGatewayUserOriginalUri == null ? 43 : $sendGatewayUserOriginalUri.hashCode());
      Object $sendGlobalOriginalConfig = this.getSendGlobalOriginalConfig();
      result = result * 59 + ($sendGlobalOriginalConfig == null ? 43 : $sendGlobalOriginalConfig.hashCode());
      Object $noticeEngineAndMaskingInfoUri = this.getNoticeEngineAndMaskingInfoUri();
      result = result * 59 + ($noticeEngineAndMaskingInfoUri == null ? 43 : $noticeEngineAndMaskingInfoUri.hashCode());
      return result;
   }

   public String toString() {
      return "ProxyConfig(sendAppUserOriginalUri=" + this.getSendAppUserOriginalUri() + ", sendGatewayUserOriginalUri=" + this.getSendGatewayUserOriginalUri() + ", sendGlobalOriginalConfig=" + this.getSendGlobalOriginalConfig() + ", noticeEngineAndMaskingInfoUri=" + this.getNoticeEngineAndMaskingInfoUri() + ")";
   }
}
