package com.chenyang.nse.bussiness.controller;

import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.service.HelloService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HelloController {
   @Autowired
   private HelloService helloService;

   @RequestMapping({"/masking"})
   public String hello() {
      this.helloService.getInfo();
      return "hello this is a springboot!";
   }

   @GetMapping({"/get"})
   public String testGet() {
      return "我是 GET 请求";
   }

   @GetMapping({"/get/params"})
   public String test(@RequestParam("name") String name) {
      return "名称" + name;
   }

   @GetMapping({"/get/{id}"})
   public String testGet1(@PathVariable("id") Integer id) {
      return "id:" + id;
   }

   @GetMapping({"/get/model"})
   public Map<String, Object> testGet2(@ModelAttribute TBaseUser user) {
      Map<String, Object> map = new HashMap();
      user = new TBaseUser();
      user.setUsername("lilei111222333444");
      user.setPassword("123456");
      map.put("user", user);
      map.put("code", 200);
      map.put("msg", "请求成功~");
      return map;
   }

   @GetMapping({"/get/result"})
   public Result testResult(@ModelAttribute TBaseUser user) {
      Map<String, Object> map = new HashMap();
      List<TBaseUser> list1 = new ArrayList();
      user = new TBaseUser();
      user.setUsername("lilei");
      user.setPassword("123456");
      list1.add(user);
      list1.add(user);
      List<TBaseUser> list2 = new ArrayList();
      list2.add(user);
      list2.add(user);
      Result re = new Result();
      re.setFlag(true);
      re.setCode("POP_00014");
      re.setMsg(MesUtil.getMsg("POP_00014", new String[0]));
      map.put("name", "用户组名称");
      map.put("name", "用户组描述");
      map.put("rolelist", list1);
      map.put("menulist", list2);
      re.setData(map);
      return re;
   }

   @GetMapping({"/get/json/data"})
   public Map<String, Object> testGet3(@RequestBody TBaseUser user) {
      Map<String, Object> map = new HashMap();
      map.put("user", user);
      map.put("code", 200);
      map.put("msg", "请求成功~");
      return map;
   }
}
