package com.chenyang.nse.bussiness.controller;

import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingImgInfo;
import com.chenyang.nse.bussiness.service.core.TCoreMaskingImgInfoService;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@EnableAsync
@Controller
@RequestMapping({"/img"})
public class MaskingImgController {
   @Autowired
   private TCoreMaskingImgInfoService tCoreMaskingImgInfoService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      String ip = request.getHeader("x-forwarded-for");
      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("WL-Proxy-Client-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getHeader("X-Real-IP");
      }

      if (null == ip || 0 == ip.length() || "unknown".equalsIgnoreCase(ip)) {
         ip = request.getRemoteAddr();
      }

      model.addAttribute("ip", ip);
      return "core/dataproject/desensitizationtask/desensitizationtask_img";
   }

   @ResponseBody
   @RequestMapping({"/uploadImg"})
   public String uploadPicture(@RequestParam(value = "file",required = false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
      new HashMap();
      File targetFile = null;
      String url = "";
      String fileName = file.getOriginalFilename();
      if (fileName != null && fileName != "") {
         String returnUrl = "/data/infa_work_report/image_masking_source";
         String fileF = fileName.substring(fileName.lastIndexOf("."), fileName.length());
         fileName = (new Date()).getTime() + "_" + (new Random()).nextInt(1000) + fileF;
         File file1 = new File(returnUrl);
         if (!file1.exists() && !file1.isDirectory()) {
            file1.mkdir();
         }

         targetFile = new File(file1, fileName);

         try {
            file.transferTo(targetFile);
            url = fileName;
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return url;
   }

   @ResponseBody
   @RequestMapping({"/readimg"})
   public void readimg(@RequestParam("path") String fileName, @RequestParam("flag") String flag, HttpServletRequest request, HttpServletResponse response) {
      String path = "";
      if ("0".equals(flag)) {
         path = "/data/infa_work_report/image_masking_source/" + fileName;
      } else {
         path = "/data/infa_work_report/image_masking_target/" + fileName;
      }

      File filePic = new File(path);
      if (filePic.exists()) {
         try {
            FileInputStream is = new FileInputStream(filePic);
            int i = is.available();
            byte[] data = new byte[i];
            is.read(data);
            is.close();
            response.setContentType("image/*");
            OutputStream toClient = response.getOutputStream();
            toClient.write(data);
            is.close();
            toClient.close();
            toClient.flush();
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @ResponseBody
   @RequestMapping({"/mosaic"})
   public String mosaic(@RequestParam("path") String fileName, @RequestParam("ip") String ip, @RequestParam("logincount") int logincount, @RequestParam("maskingcontentflag") String maskingcontentflag, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_source/" + fileName;
      TCoreMaskingImgInfo tCoreMaskingImgInfo = null;
      if (!"0:0:0:0:0:0:0:1".equals(ip) && !"127.0.0.1".equals(ip)) {
         if (logincount == 0) {
            tCoreMaskingImgInfo = new TCoreMaskingImgInfo();
            tCoreMaskingImgInfo.setIp(ip);
            tCoreMaskingImgInfo.setLogincount(1);
            tCoreMaskingImgInfo.setCreatedate(new Date());
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         } else {
            tCoreMaskingImgInfo = this.tCoreMaskingImgInfoService.querynumByip(ip);
            tCoreMaskingImgInfo.setLogincount(logincount);
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         }

         this.tCoreMaskingImgInfoService.saveOrUpdate(tCoreMaskingImgInfo);
      }

      if ("1".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf);
      } else if ("2".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf);
      } else if (maskingcontentflag.indexOf("1") != -1 && maskingcontentflag.indexOf("2") != -1) {
         String commandlf1 = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " 1_" + fileName + "  mask";
         CommandTool.commandRtn(commandlf1);
         path = "/data/infa_work_report/image_masking_target/1_" + fileName;
         String commandlf2 = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  mask";
         CommandTool.commandRtn(commandlf2);

         try {
            File filePic = new File(path);
            if (filePic.exists()) {
               filePic.delete();
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return "success";
   }

   @ResponseBody
   @RequestMapping({"/coverblack"})
   public String coverblack(@RequestParam("path") String fileName, @RequestParam("ip") String ip, @RequestParam("logincount") int logincount, @RequestParam("maskingcontentflag") String maskingcontentflag, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_source/" + fileName;
      TCoreMaskingImgInfo tCoreMaskingImgInfo = null;
      if (!"0:0:0:0:0:0:0:1".equals(ip) && !"127.0.0.1".equals(ip)) {
         if (logincount == 0) {
            tCoreMaskingImgInfo = new TCoreMaskingImgInfo();
            tCoreMaskingImgInfo.setIp(ip);
            tCoreMaskingImgInfo.setLogincount(1);
            tCoreMaskingImgInfo.setCreatedate(new Date());
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         } else {
            tCoreMaskingImgInfo = this.tCoreMaskingImgInfoService.querynumByip(ip);
            tCoreMaskingImgInfo.setLogincount(logincount);
            tCoreMaskingImgInfo.setUpdatedate(new Date());
         }

         this.tCoreMaskingImgInfoService.saveOrUpdate(tCoreMaskingImgInfo);
      }

      if ("1".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf);
      } else if ("2".equals(maskingcontentflag)) {
         String commandlf = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf);
      } else if (maskingcontentflag.indexOf("1") != -1 && maskingcontentflag.indexOf("2") != -1) {
         String commandlf1 = "/data/infa_imgmaksing/imgfiguremasking.sh " + path + " 2_" + fileName + "  black";
         CommandTool.commandRtn(commandlf1);
         path = "/data/infa_work_report/image_masking_target/2_" + fileName;
         String commandlf2 = "/data/infa_imgmaksing/imgcardmasking.sh " + path + " " + fileName + "  black";
         CommandTool.commandRtn(commandlf2);

         try {
            File filePic = new File(path);
            if (filePic.exists()) {
               filePic.delete();
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return "success";
   }

   @ResponseBody
   @RequestMapping({"/maskingfileexist"})
   public String maskingfileexist(@RequestParam("path") String fileName, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_target/" + fileName;

      try {
         File filePic = new File(path);
         return filePic.exists() ? "1" : "0";
      } catch (Exception var6) {
         return "0";
      }
   }

   @ResponseBody
   @RequestMapping({"/checkipnum"})
   public int checkipnum(String ip, HttpServletRequest request, HttpServletResponse response) {
      TCoreMaskingImgInfo querynumByip = this.tCoreMaskingImgInfoService.querynumByip(ip);
      if (querynumByip == null) {
         return 0;
      } else {
         int logincount = querynumByip.getLogincount();
         return logincount;
      }
   }

   @ResponseBody
   @RequestMapping({"/delimg"})
   public String delimg(@RequestParam("path") String fileName, HttpServletRequest request, HttpServletResponse response) {
      String path = "/data/infa_work_report/image_masking_target/" + fileName;

      try {
         File filePic = new File(path);
         if (filePic.exists()) {
            filePic.delete();
         }

         return "success";
      } catch (Exception var6) {
         return "fail";
      }
   }
}
