package com.chenyang.nse.bussiness.controller;

import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@EnableAsync
@Controller
@RequestMapping({"/RSAEncrypt"})
public class RSAEncryptController {
   @Autowired
   private DesensitizationtaskService desensitizationtaskService;

   @ResponseBody
   @RequestMapping({"/getPublickey"})
   public String getPublickey(@RequestParam(value = "encryptType",required = false) String encryptType, HttpServletRequest request, HttpServletResponse response) {
      String publickey = "";
      List<TCoreSecretkey> tCoreSecretkeylist = this.desensitizationtaskService.selectSecretkeyByName(encryptType);
      if (tCoreSecretkeylist.size() > 0) {
         publickey = ((TCoreSecretkey)tCoreSecretkeylist.get(0)).getPublickey();
      }

      return publickey;
   }

   @ResponseBody
   @RequestMapping({"/getPrivatekey"})
   public String getPrivatekey(@RequestParam(value = "encryptType",required = false) String encryptType, HttpServletRequest request, HttpServletResponse response) {
      String privatekey = "";
      List<TCoreSecretkey> tCoreSecretkeylist = this.desensitizationtaskService.selectSecretkeyByName(encryptType);
      if (tCoreSecretkeylist.size() > 0) {
         privatekey = ((TCoreSecretkey)tCoreSecretkeylist.get(0)).getPrivatekey();
      }

      return privatekey;
   }
}
