package com.chenyang.nse.bussiness.controller;

import java.io.Serializable;

public class Result<T> implements Serializable {
   private boolean flag;
   private String code;
   private String msg;
   private T data;

   public Result(boolean flag, String code, String message, Object data) {
      this.flag = flag;
      this.code = code;
      this.msg = message;
      this.data = (T)data;
   }

   public Result(boolean flag, String code, String message) {
      this.flag = flag;
      this.code = code;
      this.msg = message;
   }

   public Result() {
      this.flag = true;
      this.code = "20000";
      this.msg = "操作成功!";
   }

   public boolean isFlag() {
      return this.flag;
   }

   public void setFlag(boolean flag) {
      this.flag = flag;
   }

   public String getCode() {
      return this.code;
   }

   public void setCode(String code) {
      this.code = code;
   }

   public String getMsg() {
      return this.msg;
   }

   public void setMsg(String msg) {
      this.msg = msg;
   }

   public T getData() {
      return this.data;
   }

   public void setData(T data) {
      this.data = data;
   }

   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof Result)) {
         return false;
      } else {
         Result<?> other = (Result)o;
         if (!other.canEqual(this)) {
            return false;
         } else if (this.isFlag() != other.isFlag()) {
            return false;
         } else {
            Object this$code = this.getCode();
            Object other$code = other.getCode();
            if (this$code == null) {
               if (other$code != null) {
                  return false;
               }
            } else if (!this$code.equals(other$code)) {
               return false;
            }

            Object this$msg = this.getMsg();
            Object other$msg = other.getMsg();
            if (this$msg == null) {
               if (other$msg != null) {
                  return false;
               }
            } else if (!this$msg.equals(other$msg)) {
               return false;
            }

            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null) {
               if (other$data != null) {
                  return false;
               }
            } else if (!this$data.equals(other$data)) {
               return false;
            }

            return true;
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof Result;
   }

   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      result = result * 59 + (this.isFlag() ? 79 : 97);
      Object $code = this.getCode();
      result = result * 59 + ($code == null ? 43 : $code.hashCode());
      Object $msg = this.getMsg();
      result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
      Object $data = this.getData();
      result = result * 59 + ($data == null ? 43 : $data.hashCode());
      return result;
   }

   public String toString() {
      return "Result(flag=" + this.isFlag() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
   }
}
