package com.chenyang.nse.bussiness.controller.acceptinfo;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/acceptinfo"})
public class UserNameUrlInfoController {
   private static Map<String, Object> map = null;

   @PostMapping({"/saveuserinfo"})
   public void saveUserInfo(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
      String flag = (String)params.get("maskGHCA");
      String requestUrl = (String)params.get("requestUrl");
      String url = (String)params.get("url");
      Map paramslist = (Map)params.get("params");
      map = new HashMap();
      map.put("maskGHCA", flag);
      map.put("requestUrl", requestUrl);
      map.put("url", url);
      map.put("params", paramslist);
   }

   @ResponseBody
   @GetMapping({"/getuserinfo"})
   public Response getUserInfo(HttpServletRequest request, HttpServletResponse response) {
      return RespHelper.successResp(map);
   }

   @ResponseBody
   @GetMapping({"/exportconfig"})
   public void exportConfig(@RequestParam("loginUrl") String loginUrl, @RequestParam("usernamefiled") String usernamefiled, HttpServletRequest request, HttpServletResponse response) throws IOException {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String loginfilepath = props.getProperty("loginfilepath");
      FileOutputStream oFile = new FileOutputStream(loginfilepath, false);
      Properties props1 = new Properties();
      props1.setProperty("loginUrl", loginUrl);
      props1.setProperty("usernamefiled", usernamefiled);
      props1.store(oFile, "loginfile");
      oFile.close();

      try {
         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=login.properties");
         InputStream inputStream = new FileInputStream(new File(loginfilepath));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
