package com.chenyang.nse.bussiness.controller.api;

public enum ResultEm {
   RT_CODE_20000_STR("20000", "成功"),
   RT_CODE_20001_STR("20001", "失败"),
   RT_CODE_20002_STR("20002", "用户名或密码错误"),
   RT_CODE_20003_STR("20003", "权限不足"),
   RT_CODE_20004_STR("20004", "远程调用失败"),
   RT_CODE_20005_STR("20005", "重复操作"),
   RT_CODE_20006_STR("20006", "没有对应的数据"),
   RT_CODE_20007_STR("20007", "系统异常"),
   RT_CODE_20008_STR("20008", "用户名已存在，不能重复进行注册"),
   UNDEFINE("-1", "undefine Exception");

   private String code;
   private String msg;

   private ResultEm(String code, String msg) {
      this.code = code;
      this.msg = msg;
   }

   public static String msg(String code) {
      for(ResultEm m : values()) {
         if (m.getCode() == code) {
            return m.getMsg();
         }
      }

      return UNDEFINE.getMsg();
   }

   public String getCode() {
      return this.code;
   }

   public void setCode(String code) {
      this.code = code;
   }

   public String getMsg() {
      return this.msg;
   }

   public void setMsg(String msg) {
      this.msg = msg;
   }
}
