package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseButton;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.console.ButtonService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/button"})
public class ButtonController {
   @Autowired
   private ButtonService buttonService;
   @Autowired
   private OperationService operationService;

   @RequestMapping({"/checkNameExit"})
   @ResponseBody
   public ResultVO checkNameExit(String addmenuid, String buttonname, String operatename, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean result = this.buttonService.checkNameExit(addmenuid, buttonname);
      String message = this.buttonService.checkUrlExit(operatename);
      ResultVO vo = new ResultVO(message, result);
      return vo;
   }

   @RequestMapping({"/checkNameExitEdit"})
   @ResponseBody
   public ResultVO checkNameExitEdit(String addmenuid, String buttonname, String operatename, String oldbutton, String oldurl, HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO vo = null;
      if (oldbutton.equals(buttonname) && oldurl.equals(operatename)) {
         vo = new ResultVO("1", false);
      } else if (!oldbutton.equals(buttonname) && oldurl.equals(operatename)) {
         boolean result = this.buttonService.checkNameExit(addmenuid, buttonname);
         vo = new ResultVO("1", result);
      } else if (oldbutton.equals(buttonname) && !oldurl.equals(operatename)) {
         String message = this.buttonService.checkUrlExit(operatename);
         vo = new ResultVO(message, false);
      } else {
         boolean result = this.buttonService.checkNameExit(addmenuid, buttonname);
         String message = this.buttonService.checkUrlExit(operatename);
         vo = new ResultVO(message, result);
      }

      return vo;
   }

   @RequestMapping({"/add"})
   public void add(String addmenuid, String flag, TBaseButton button, HttpServletRequest request, HttpServletResponse response, Model model) {
      button.setMenuid(addmenuid);
      button.setCreatetime(new Date());
      button.setFlag(flag);
      TConsoleLog record = new TConsoleLog();
      if (null == button.getId()) {
         record.setLogmessage("增加按钮");
      } else {
         record.setLogmessage("修改按钮");
      }

      this.buttonService.save(button);
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("菜单管理");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setOperationObject(button.getButtonname());
      this.operationService.add(record);
   }

   @RequestMapping({"/querybuttonbyid"})
   @ResponseBody
   public TBaseButton queryButtonById(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      TBaseButton tBaseButton = this.buttonService.queryButtonById(id);
      return tBaseButton;
   }

   @RequestMapping({"/removebutton"})
   @ResponseBody
   public void removebutton(String id, String menuname, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.buttonService.deletebutton(id);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("菜单管理");
      record.setLogmessage("删除按钮");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setOperationObject(menuname);
      this.operationService.add(record);
   }
}
