package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.vo.DictionartFileVO;
import com.chenyang.nse.bussiness.entity.vo.ExportExcel;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.core.DictionartFileService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping({"/core/dictionaryexcel"})
public class DictionartFileController {
   @Autowired
   private DictionartFileService dictionartFileService;
   @Autowired
   private DictionaryService dictionaryService;

   @PostMapping({"/export"})
   @ResponseBody
   public Response export(HttpServletResponse response, @RequestBody(required = false) Map typecode) {
      List<DictionartFileVO> list = this.dictionartFileService.queryDictionaryFile((String)typecode.get("typecode"));
      ExportExcel<DictionartFileVO> ee = new ExportExcel<DictionartFileVO>();
      String[] headers = new String[]{"分类", "分类编码", "值", "名称", "父值"};
      String fileName = "发现规则知识库";
      ee.exportExcel(headers, list, fileName, response);
      return RespHelper.successResp();
   }

   @PostMapping({"/importfile"})
   @ResponseBody
   public Response importfile(@RequestParam("fileUpload") MultipartFile excelFile, String smart, HttpServletRequest request) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      InputStream in = null;
      String fileName = excelFile.getOriginalFilename();
      if (ObjectUtils.isEmpty(excelFile) && ObjectUtils.isEmpty(smart)) {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      } else {
         try {
            in = excelFile.getInputStream();
            Workbook wb = null;
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            if (".xls".equals(fileType)) {
               wb = new HSSFWorkbook(in);
            } else if (".xlsx".equals(fileType)) {
               wb = new XSSFWorkbook(in);
            }

            Sheet sheet = wb.getSheetAt(0);
            int rowsNum = sheet.getLastRowNum();
            int num = 0;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println("取文件时间：" + sdf.format(new Date()));
            long startTime = System.currentTimeMillis();
            List<TConsoleDictionary> list1 = new ArrayList();

            for(int i = 1; i < rowsNum + 1; ++i) {
               Row row = sheet.getRow(i);
               TConsoleDictionary tConsoleDictionary = new TConsoleDictionary();
               new TConsoleDictionarytype();
               if (row != null) {
                  String typeCode = row.getCell(1).toString();
                  if (typeCode.indexOf(".") != -1) {
                     tConsoleDictionary.setTypecode("".equals(typeCode.substring(0, typeCode.indexOf("."))) ? null : typeCode.substring(0, typeCode.indexOf(".")));
                  } else {
                     tConsoleDictionary.setTypecode("".equals(row.getCell(1).toString()) ? null : row.getCell(1).toString());
                  }

                  if (row.getCell(2) != null) {
                     row.getCell(2).setCellType(1);
                     tConsoleDictionary.setValue("".equals(row.getCell(2).toString()) ? null : row.getCell(2).toString());
                  }

                  if (row.getCell(3) != null) {
                     row.getCell(3).setCellType(1);
                     tConsoleDictionary.setName("".equals(row.getCell(3).toString()) ? null : row.getCell(3).toString());
                  }

                  list1.add(tConsoleDictionary);
               }
            }

            long endTime = System.currentTimeMillis();
            System.out.println("程序运行时间： " + (endTime - startTime) + "ms");
            String typecode = ((TConsoleDictionary)list1.get(0)).getTypecode();
            this.dictionartFileService.empty1(smart, typecode);
            this.dictionartFileService.saveTableData(list1);
         } catch (IOException e) {
            e.printStackTrace();
         }

         return RespHelper.successResp();
      }
   }

   public void empty(String smart) {
   }

   @ResponseBody
   @RequestMapping({"/queryBycode"})
   public List<TConsoleDictionarytype> queryBycode(String code, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleDictionarytype> list = this.dictionaryService.queryBycode(code);
      return list;
   }
}
