package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.DutyTableInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.FieldPermissionsInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.UserJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.vo.DutyInfoReqVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.service.console.RoleService;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.DutyUserService;
import com.chenyang.nse.bussiness.service.core.impl.DmpDesensitizationServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/dutyinfo"})
public class DutyInfoController {
   @Autowired
   DutyUserService dutyUserService;
   @Autowired
   private RoleService roleService;
   @Autowired
   private UserService userService;
   @Autowired
   private DmpDesensitizationServiceImpl dmpDesensitizationService;

   @RequestMapping({"/add"})
   @ResponseBody
   public Response<String> addDutyInfo(@RequestBody Map<String, Object> params) {
      Map<String, Object> tableinfo = (Map)params.get("tableinfo");
      Map<String, Object> userinfo = (Map)params.get("userinfo");
      List<Map<String, Object>> fieldlist = (List)params.get("fieldlist");
      String id = (String)tableinfo.get("id");
      DutyTableInfo dutyTableInfo = null;
      if (StringUtils.isBlank(id)) {
         dutyTableInfo = new DutyTableInfo();
         dutyTableInfo.setId(UUID.randomUUID().toString());
      } else {
         dutyTableInfo = this.dutyUserService.queryDutyTableById(id);
      }

      dutyTableInfo.setDatasystemid((String)tableinfo.get("datasystemid"));
      dutyTableInfo.setSchemaname((String)tableinfo.get("schemaname"));
      dutyTableInfo.setTablename((String)tableinfo.get("tablename"));
      dutyTableInfo.setProjectid((String)tableinfo.get("projectid"));
      if (StringUtils.isBlank(id)) {
         this.dutyUserService.saveDutyTableInfo(dutyTableInfo);
      }

      UserJoinFieldInfo userJoinFieldInfo = new UserJoinFieldInfo();
      userJoinFieldInfo.setId(UUID.randomUUID().toString());
      userJoinFieldInfo.setJointype((String)userinfo.get("jointype"));
      userJoinFieldInfo.setJoinid((String)userinfo.get("joinid"));
      userJoinFieldInfo.setDutytableid(dutyTableInfo.getId());
      List<UserJoinFieldInfo> userJoinFieldInfos = this.dutyUserService.queryUserJoinFieldInfo(dutyTableInfo.getId(), (String)userinfo.get("joinid"));
      if (userJoinFieldInfos.size() == 0) {
         this.dutyUserService.saveUserJoinFieldInfo(userJoinFieldInfo);
      } else {
         userJoinFieldInfo.setId(((UserJoinFieldInfo)userJoinFieldInfos.get(0)).getId());
      }

      this.dutyUserService.removefieldPermissionsInfo(dutyTableInfo.getId(), userJoinFieldInfo.getId());

      for(Map<String, Object> map : fieldlist) {
         FieldPermissionsInfo fieldPermissionsInfo = new FieldPermissionsInfo();
         fieldPermissionsInfo.setColumnname((String)map.get("columnname"));
         fieldPermissionsInfo.setRemarks((String)map.get("remarks"));
         fieldPermissionsInfo.setCflag((String)map.get("cflag"));
         fieldPermissionsInfo.setRflag((String)map.get("rflag"));
         fieldPermissionsInfo.setUflag((String)map.get("uflag"));
         fieldPermissionsInfo.setDflag((String)map.get("dflag"));
         fieldPermissionsInfo.setBusinessid(String.valueOf(map.get("businessid")));
         fieldPermissionsInfo.setSkillid(String.valueOf(map.get("skillid")));
         fieldPermissionsInfo.setUserjoinid(userJoinFieldInfo.getId());
         fieldPermissionsInfo.setDutytableid(dutyTableInfo.getId());
         this.dutyUserService.saveFieldPermissionsInfo(fieldPermissionsInfo);
         this.dutyUserService.updateFieldInfo(dutyTableInfo.getId(), fieldPermissionsInfo.getColumnname(), fieldPermissionsInfo.getBusinessid(), fieldPermissionsInfo.getSkillid());
      }

      return RespHelper.<String>successResp();
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public Response<HashMap<String, Object>> query(@RequestBody Map<String, Object> params) {
      String datasystemid = (String)params.get("datasystemid");
      String schemaname = (String)params.get("schemaname");
      String tablename = (String)params.get("tablename");
      String projectid = (String)params.get("projectid");
      String joinid = (String)params.get("joinid");
      HashMap<String, Object> result = new HashMap();
      String tableid = "";
      List<DutyTableInfo> list = this.dutyUserService.queryExists(datasystemid, schemaname, tablename, projectid);
      if (list.size() > 0) {
         DutyTableInfo dutyTableInfo = (DutyTableInfo)list.get(0);
         tableid = dutyTableInfo.getId();
         List<UserJoinFieldInfo> userJoinFieldInfos = this.dutyUserService.queryUserJoinFieldInfo(dutyTableInfo.getId(), joinid);
         if (userJoinFieldInfos != null && userJoinFieldInfos.size() > 0) {
            UserJoinFieldInfo user = (UserJoinFieldInfo)userJoinFieldInfos.get(0);
            List<FieldPermissionsInfo> fieldlist = this.dutyUserService.queryFieldPermissionsInfo(user.getId());
            result.put("fieldList", fieldlist);
         }

         result.put("id", dutyTableInfo.getId());
      } else {
         result.put("id", "");
      }

      if (!result.containsKey("fieldList")) {
         List<FieldPermissionsInfo> fieldList = this.getFieldList(datasystemid, schemaname, tablename, tableid);
         result.put("fieldList", fieldList);
      }

      return RespHelper.<HashMap<String, Object>>successResp(result);
   }

   public List<FieldPermissionsInfo> getFieldList(String datasystemid, String schemaname, String tablename, String tableid) {
      List<ColumnInfoVO> columnInfoVOS = this.dmpDesensitizationService.queryColumnInfo(datasystemid, schemaname, tablename);
      List<FieldPermissionsInfo> fieldlist = new ArrayList();
      FieldPermissionsInfo fieldPermissionsInfo = null;

      for(ColumnInfoVO columnInfoVO : columnInfoVOS) {
         fieldPermissionsInfo = new FieldPermissionsInfo();
         fieldPermissionsInfo.setColumnname(columnInfoVO.getColumnname());
         fieldPermissionsInfo.setRemarks(columnInfoVO.getRemarks());
         fieldPermissionsInfo.setCflag("0");
         fieldPermissionsInfo.setRflag("0");
         fieldPermissionsInfo.setUflag("0");
         fieldPermissionsInfo.setDflag("0");
         if (!"".equals(tableid)) {
            List<FieldPermissionsInfo> list = this.dutyUserService.queryFieldAll(tableid, columnInfoVO.getColumnname());
            if (list.size() != 0) {
               FieldPermissionsInfo field = (FieldPermissionsInfo)list.get(0);
               fieldPermissionsInfo.setBusinessid(field.getBusinessid());
               fieldPermissionsInfo.setSkillid(field.getSkillid());
            }
         } else {
            fieldPermissionsInfo.setBusinessid("");
            fieldPermissionsInfo.setSkillid("");
         }

         fieldlist.add(fieldPermissionsInfo);
      }

      return fieldlist;
   }

   @RequestMapping({"/selectdutyrole"})
   @ResponseBody
   public Response<List<Map<String, Object>>> selectDutyRole(@RequestBody DutyInfoReqVO vo) {
      List<Map<String, Object>> result = new ArrayList();
      HashMap<String, Object> map = null;
      switch (vo.getRoletype()) {
         case "1":
            for(TBaseRole tBaseRole : this.roleService.queryAll()) {
               map = new HashMap();
               map.put("showname", tBaseRole.getRolename());
               map.put("joinid", tBaseRole.getId());
               result.add(map);
            }
            break;
         case "2":
            for(TBaseUser tBaseUser : this.userService.queryAll()) {
               map = new HashMap();
               map.put("showname", tBaseUser.getRealname());
               map.put("joinid", tBaseUser.getId());
               result.add(map);
            }
      }

      return RespHelper.<List<Map<String, Object>>>successResp(result);
   }
}
