package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.MailInformation;
import com.chenyang.nse.bussiness.service.core.MailService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/email"})
public class EmailController {
   private static Logger logger = LoggerFactory.getLogger(ControlledAssetController.class);
   @Autowired
   private MailService mailService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   @Value("${spring.mail.username}")
   private String from;
   @Autowired
   private JavaMailSenderImpl jms;

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response query(@RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<MailInformation> list = this.mailService.queryAll();
      ddmauditLogger.info(MesUtil.getMsg("DDM_01702", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      return RespHelper.successResp(list);
   }

   @RequestMapping({"/initEdit"})
   @ResponseBody
   public Response<MailInformation> initEmail(@RequestParam Map<String, String> params) {
      String id = String.valueOf(params.get("id"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_01704", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      if (id != null && id.toString().length() != 0) {
         MailInformation email = this.mailService.initEmail(id);
         return RespHelper.<MailInformation>successResp(email);
      } else {
         return RespHelper.<MailInformation>paramErrResp();
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response<MailInformation> addEmail(@RequestBody MailInformation mailInformation, HttpServletRequest request) {
      if (StringUtils.isBlank(mailInformation.getId())) {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01704", new String[]{CommonUtils.loginUsername(), mailInformation.getSendemail()}));
      } else {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01703", new String[]{CommonUtils.loginUsername(), mailInformation.getSendemail()}));
      }

      this.mailService.addEmail(mailInformation);
      return RespHelper.<MailInformation>successResp(mailInformation);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      String name = (String)params.get("sendEmail");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01705", new String[]{CommonUtils.loginUsername(), name}));
      this.mailService.remove(id);
      return RespHelper.successResp();
   }

   @RequestMapping({"test"})
   public Response testSendEmail(@RequestParam String email) {
      try {
         List<MailInformation> mailList = this.mailService.queryAll();
         if (mailList.size() > 0) {
            MailInformation mail = (MailInformation)mailList.get(0);
            Properties mailProperties = new Properties();
            mailProperties.put("mail.smtp.starttls.enable", true);
            mailProperties.put("mail.smtp.ssl.trust", mail.getHost());
            if (org.apache.commons.lang.StringUtils.isNotBlank(mail.getSslflag()) && mail.getSslflag().equals("1")) {
               mailProperties.put("mail.smtp.socketFactory", "javax.net.ssl.SSLSocketFactory");
               mailProperties.put("mail.smtp.socketFactory.fallback", false);
            }

            this.jms.setJavaMailProperties(mailProperties);
            this.jms.setHost(mail.getHost());
            this.jms.setPort(mail.getPort());
            this.jms.setUsername(mail.getSendemail());
            this.jms.setPassword(mail.getSendpassword());
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(mail.getSendemail());
            message.setTo(email);
            message.setSubject("测试邮件");
            message.setText("测试邮件。");
            this.jms.send(message);
         }
      } catch (Exception e) {
         e.printStackTrace();
         return RespHelper.exceptionResp(e);
      }

      return RespHelper.successResp();
   }

   @RequestMapping({"sendSimpleEmail"})
   public String sendSimpleEmail() {
      try {
         SimpleMailMessage message = new SimpleMailMessage();
         message.setFrom(this.from);
         message.setTo("12388482@qq.com");
         message.setSubject("一封简单的邮件");
         message.setText("使用Spring Boot发送简单邮件。");
         this.jms.send(message);
         return "发送成功";
      } catch (Exception e) {
         e.printStackTrace();
         return e.getMessage();
      }
   }
}
