package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreImporttask;
import com.chenyang.nse.bussiness.entity.param.SaveExTaskParam;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.core.ExportWorkflowService;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping({"/core/exportworkflow"})
public class ExportWorkflowController {
   private static Logger logger = LoggerFactory.getLogger(ExportWorkflowController.class);
   @Autowired
   private ExportWorkflowService exportWorkflowService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/exporttask/exportworkflow";
   }

   @ResponseBody
   @RequestMapping({"/querytask"})
   public DataGridVO<TCoreImporttask> querytask(String flag, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> flag_list = new ArrayList();
      if (flag != null) {
         flag_list.add(flag);
      } else {
         flag_list.add("20");
         flag_list.add("30");
      }

      List<TCoreImporttask> list = this.exportWorkflowService.queryTask(pageInfo, flag_list);
      DataGridVO<TCoreImporttask> vo = new DataGridVO<TCoreImporttask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/add"})
   public void add(TCoreImporttask texportTask, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.exportWorkflowService.add(texportTask);
   }

   @RequestMapping({"/uploadfile"})
   @ResponseBody
   public ResultVO uploadfile(@RequestParam("file") CommonsMultipartFile file, @RequestParam("engineid") String engineid, @RequestParam("taskname") String taskname, @RequestParam("filepath") String filepath, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean result_status = this.exportWorkflowService.uploadfile(taskname, engineid, filepath, file);
      return result_status ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/taskExport"})
   @ResponseBody
   public ResultVO taskExport(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean result_status = this.exportWorkflowService.taskExport(taskid);
      return result_status ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/taskExecute"})
   @ResponseBody
   public ResultVO taskExecute(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean result_status = this.exportWorkflowService.taskExecute(taskid);
      return result_status ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/creattask"})
   public String creattask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreImporttask task = this.exportWorkflowService.selectByPrimaryKey(taskid);
      model.addAttribute("task", task);
      String sourceDbname = this.exportWorkflowService.querySourceDbName(taskid);
      String targetDbname = this.exportWorkflowService.queryTargetDbName(taskid);
      model.addAttribute("sourceDbname", sourceDbname);
      model.addAttribute("targetDbname", targetDbname);
      return "core/exporttask/creattask";
   }

   @RequestMapping({"/allLinks"})
   @ResponseBody
   public List<Map<String, String>> allLinks(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      InfoProperty engine = this.exportWorkflowService.getInfoProperty(engineid);
      List<String> links = InfoExecUtil.exeAllLinks(engine.getPmrepexepath());
      List<Map<String, String>> list = new ArrayList();

      for(String item : links) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @RequestMapping({"/addlink"})
   public void addlink(TCoreDatasystem datasource, String engineid, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      InfoProperty engine = this.exportWorkflowService.getInfoProperty(engineid);
      String password = "1".equals(datasource.getFlag()) ? AesTool.decrypt(datasource.getPassword(), "ghca") : datasource.getPassword();
      InfoExecUtil.createDb(engine.getPmrepexepath(), datasource.getDbtype(), datasource.getUsername(), password, datasource.getSysname(), datasource.getDbservername(), "UTF-8");
   }

   @RequestMapping({"/savetask"})
   public void savetask(SaveExTaskParam saveExTaskParam, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.exportWorkflowService.savetask(saveExTaskParam);
   }
}
