package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldDetailReportVO;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/fielddetailreport"})
public class FieldDetailReportController {
   @Autowired
   private RedisService redisService;
   @Autowired
   private DataScopeService dataScopeService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, String columnid) {
      model.addAttribute("columnid", columnid);
      return "core/datascope/report/fielddetail";
   }

   @RequestMapping({"/getfielddetail"})
   @ResponseBody
   public List<FieldDetailReportVO> getFieldDetail(HttpServletRequest request, HttpServletResponse response, String columnid) {
      new ArrayList();
      List<FieldDetailReportVO> result = this.dataScopeService.getFieldDetail(columnid);
      if (result != null) {
         FieldDetailReportVO fieldDetailReportVO = (FieldDetailReportVO)((FieldDetailReportVO)result.get(0)).clone();
         Object obj = this.redisService.get(fieldDetailReportVO.getNames() + "+" + fieldDetailReportVO.getTschemas());
         new ArrayList();
         List<TCoreFieldSensitiveMemory> tCoreFieldSensitiveMemorylist = (List)obj;
         if (tCoreFieldSensitiveMemorylist != null && tCoreFieldSensitiveMemorylist.size() > 0) {
            for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : tCoreFieldSensitiveMemorylist) {
               if (tCoreFieldSensitiveMemory.getColumnname().equals(fieldDetailReportVO.getFields())) {
                  fieldDetailReportVO.setRulename(tCoreFieldSensitiveMemory.getRuie());
                  fieldDetailReportVO.setType("发现规则");
               }
            }
         }

         result.add(fieldDetailReportVO);
      }

      return result;
   }
}
