package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewComplianceDirectoryProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewDataScopeProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewSensitiveLevelProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/projectreport"})
public class FieldlistReportController {
   @Autowired
   private DataScopeService dataScopeService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, String projectid, String type) {
      model.addAttribute("projectid", projectid);
      model.addAttribute("type", type);
      return "core/datascope/report/projectfieldlist";
   }

   @RequestMapping({"/getfieldlistComplianceDirectoryProject"})
   @ResponseBody
   public DataGridVO<TViewComplianceDirectoryProject> getFieldList(PageInfo pageInfo, int rows, int page, String projectid, String type, String directory_name, String tablename, String columnname) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      new ArrayList();
      List<TViewComplianceDirectoryProject> result = this.dataScopeService.getTViewComplianceDirectoryProject(pageInfo, projectid, type, directory_name, tablename, columnname);
      return new DataGridVO<TViewComplianceDirectoryProject>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getfieldlistSensitiveLevelProject"})
   @ResponseBody
   public DataGridVO<TViewSensitiveLevelProject> getfieldlistScopeProject(PageInfo pageInfo, int rows, int page, String projectid, String type, String directory_name, String tablename, String columnname) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      new ArrayList();
      List<TViewSensitiveLevelProject> result = this.dataScopeService.getTViewSensitiveLevelProject(pageInfo, projectid, type, directory_name, tablename, columnname);
      return new DataGridVO<TViewSensitiveLevelProject>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getfieldlistScopeProject"})
   @ResponseBody
   public DataGridVO<TViewDataScopeProject> getfieldlistSensitiveLevelProject(PageInfo pageInfo, int rows, int page, String projectid, String type, String directory_name, String tablename, String columnname) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      new ArrayList();
      List<TViewDataScopeProject> result = this.dataScopeService.getTViewDataScopeProject(pageInfo, projectid, type, directory_name, tablename, columnname);
      return new DataGridVO<TViewDataScopeProject>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getprojectlist"})
   @ResponseBody
   public List<TCoreProjectInfo> getProjectList(HttpServletRequest request, HttpServletResponse response) {
      new ArrayList();
      List<TCoreProjectInfo> result = this.dataScopeService.getProjectList();
      return result;
   }

   @RequestMapping({"/getrulelist"})
   @ResponseBody
   public List<ReportCheckboxVO> getRuleList(HttpServletRequest request, HttpServletResponse response, String type) {
      new ArrayList();
      List result;
      if ("0".equals(type)) {
         result = this.dataScopeService.getComplianceDirectoryList();
      } else if ("1".equals(type)) {
         result = this.dataScopeService.getCoreDataScopeList();
      } else if ("2".equals(type)) {
         result = this.dataScopeService.getTCoreSensitiveLevelList();
      } else {
         result = this.dataScopeService.getComplianceDirectoryList();
      }

      ReportCheckboxVO reportCheckboxVO = new ReportCheckboxVO();
      reportCheckboxVO.setId("0");
      reportCheckboxVO.setName("ALL");
      result.add(0, reportCheckboxVO);
      return result;
   }
}
