package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.AssignmentNameVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.SearchFieldService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/findfieldtask"})
public class FindFieldtaskController {
   @Autowired
   private SearchFieldService searchFieldService;
   @Autowired
   private DiscoverytaskService discoverytasknService;
   @Autowired
   private OperationService operationService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datascope/findfieldtask";
   }

   @ResponseBody
   @RequestMapping({"/findfieldtasklist"})
   public DataGridVO<AssignmentNameVO> findfieldtasklist(PageInfo pageInfo, String taskname, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      new HashMap();
      List<AssignmentNameVO> list = this.searchFieldService.assignmentNameVO(pageInfo, taskname);
      DataGridVO<AssignmentNameVO> vo = new DataGridVO<AssignmentNameVO>(pageInfo.getCount(), list);
      return vo;
   }
}
