package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.GenImportService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import com.power.xml.entity.Info;
import com.power.xml.entity.SourceInfo;
import com.power.xml.entity.TargetInfo;
import com.power.xml.external.PowerXml;
import com.power.xml.utility.DomUtils;
import com.power.xml.utility.IgnoreDTDEntityResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/genimport"})
public class GenImportController {
   @Autowired
   private GenImportService genImportService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/genimport/genimportxml";
   }

   @RequestMapping({"/generatexmlstep"})
   public String generatexmlstep(String step, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/genimport/createstep/" + step;
   }

   @RequestMapping({"dowloadpage"})
   public String dowloadpage(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/genimport/createstep/downloadpage";
   }

   @ResponseBody
   @RequestMapping({"/generatexml"})
   public ResultVO genimport(HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO rv = new ResultVO();
      rv.setResult(true);
      rv.setMessage("创建成功");
      return rv;
   }

   @ResponseBody
   @RequestMapping({"/generatexml_1"})
   public ResultVO genimport_1(@RequestParam Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO rv = new ResultVO();
      String savePath = "E:\\xmltest\\dym\\";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      savePath = props.getProperty("xmlLocation");
      String monitorDir = props.getProperty("monitorFile");
      FileTool.createFolder(savePath);
      int powercenterVersion = 0;
      if (map.get("powercenterVersion") != null) {
         powercenterVersion = Integer.parseInt((String)map.get("powercenterVersion"));
      }

      String DBType = (String)map.get("DBType");
      String DBTypeValue = (String)map.get("DBTypeValue");
      String domain = (String)map.get("domain");
      String repository = (String)map.get("repository");
      String codepage = (String)map.get("codepage");
      String integration = (String)map.get("integration");
      String folder = (String)map.get("folder");
      String datasourceid = (String)map.get("datasourceid");
      String sschema = (String)map.get("sschema");
      String schemaortable = (String)map.get("schemaortable");
      String stable = (String)map.get("stable");
      String sourceconn = (String)map.get("sourceconn");
      String tschema = (String)map.get("tschema");
      String targetconn = (String)map.get("targetconn");
      String istruncate = (String)map.get("istruncate");
      String writetype = (String)map.get("writetype");
      int ismulti = 0;
      if (map.get("ismulti") != null) {
         ismulti = Integer.parseInt((String)map.get("ismulti"));
      }

      JSONArray addcolumnlist = JSONArray.parseArray((String)map.get("addcolumnlist"));
      int log_runs = 0;
      if (map.get("log_runs") != null) {
         log_runs = Integer.parseInt((String)map.get("log_runs"));
      }

      int stop_errors = 0;
      if (map.get("stop_errors") != null) {
         stop_errors = Integer.parseInt((String)map.get("stop_errors"));
      }

      int commit_interval = 0;
      if (map.get("commit_interval") != null) {
         commit_interval = Integer.parseInt((String)map.get("commit_interval"));
      }

      int log_view = 0;
      if ("true".equals(map.get("log_view"))) {
         log_view = 1;
      }

      System.out.println("powercenterVersion:" + powercenterVersion);
      System.out.println("DBType:" + DBType);
      System.out.println("DBTypeValue:" + DBTypeValue);
      System.out.println("domain:" + domain);
      System.out.println("repository:" + repository);
      System.out.println("codepage:" + codepage);
      System.out.println("integration:" + integration);
      System.out.println("folder:" + folder);
      System.out.println("datasourceid:" + datasourceid);
      System.out.println("sschema:" + sschema);
      System.out.println("schemaortable:" + schemaortable);
      System.out.println("stable:" + stable);
      System.out.println("sourceconn:" + sourceconn);
      System.out.println("tschema:" + tschema);
      System.out.println("targetconn:" + targetconn);
      System.out.println("istruncate:" + istruncate);
      System.out.println("writetype:" + writetype);
      System.out.println("addcolumnlist:" + addcolumnlist);
      System.out.println("log_runs:" + log_runs);
      System.out.println("stop_errors:" + stop_errors);
      System.out.println("commit_interval:" + commit_interval);
      System.out.println("log_view:" + log_view);
      TCoreDatasystem tcoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
      Date startdate = new Date();
      String targetFilePath = savePath + "import.xml";
      System.out.println("-------------------------开始加载-------------------------");

      try {
         Config config = new Config();
         config.setFolderName(folder);
         config.setDomainName(domain);
         config.setServerName(integration);
         config.setRepositoryName(repository);
         config.setReadMode(0);
         config.setWriteMode(0);
         config.setMappletDir(savePath + "mapplet");
         config.setXmlLocation(targetFilePath);
         config.setIsrecover(0);
         config.setSessionLogCount(log_runs);
         String sourceSchema = sschema.toUpperCase();
         String targetSchema = tschema.toUpperCase();
         String oracleUsername = tcoreDatasystem.getUsername().toUpperCase();
         Map<String, String> datamap = this.EdataMappingType();
         List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo((String)datamap.get(DBType.toUpperCase()), "10");
         Map<String, String> data_s = new HashMap();
         Map<String, Map<String, String>> data_t = new HashMap();
         Map<String, Map<String, String>> data_s_length = new HashMap();
         Map<String, Map<String, String>> data_t_length = new HashMap();
         Map<String, Map<String, String>> data_t_x_length = new HashMap();

         for(Map<String, String> maps : map_s) {
            if ("1".equals(maps.get("sourcedefault"))) {
               data_s.put(((String)maps.get("sourcefieldname")).toLowerCase(), maps.get("targetfieldname"));
            }
         }

         for(Map<String, String> maps : map_s) {
            if ("1".equals(maps.get("sourcedefault"))) {
               data_s_length.put(((String)maps.get("sourcefieldname")).toLowerCase(), maps);
            }
         }

         for(Map<String, String> mapt : map_s) {
            if (mapt.get("isdefault") != null && "1".equals(mapt.get("isdefault"))) {
               data_t.put(mapt.get("targetfieldname"), mapt);
            }

            if ("1".equals(mapt.get("sourcedefault"))) {
               data_t_length.put(((String)mapt.get("sourcefieldname")).toLowerCase(), mapt);
            }

            data_t_x_length.put((mapt.get("sourcefieldname") == null ? "" : (String)mapt.get("sourcefieldname")).toLowerCase() + (mapt.get("targetfieldname") == null ? "" : (String)mapt.get("targetfieldname")).toLowerCase(), mapt);
         }

         List<Info> infoList = new ArrayList();
         List<DBTableVO> dbtable = this.dataSystemService.queryTablename(datasourceid, sschema);

         for(int i = 0; i < dbtable.size(); ++i) {
            boolean isaddtable = false;
            if (schemaortable.equals("table")) {
               String[] addtable = stable.split(",");

               for(int j = 0; j < addtable.length; ++j) {
                  if (((DBTableVO)dbtable.get(i)).getTablename().equals(addtable[j])) {
                     isaddtable = true;
                  }
               }
            } else {
               isaddtable = true;
            }

            if (isaddtable) {
               String tableName = ((DBTableVO)dbtable.get(i)).getTablename();
               SourceInfo sourceInfo = new SourceInfo();
               sourceInfo.setName(tableName);
               sourceInfo.setSchema(sourceSchema);
               sourceInfo.setDataBaseType(tcoreDatasystem.getDbtype());
               sourceInfo.setConnectName(sourceconn);
               Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasourceid);
               List<ColumnInfoVO> collist = JdbcTool.getColumnInfoVO(conn, sschema, tableName);
               List<ColumnInfo> sourceColumnInfoList = new ArrayList();
               List<ColumnInfo> targetColumnInfoList = new ArrayList();
               boolean issomedb = true;
               boolean targetisfile = false;
               int sortnum = 0;

               for(ColumnInfoVO columninfovo : collist) {
                  ++sortnum;
                  String qualifierType = (String)data_s.get(this.delparentheses(columninfovo.getTypename().toLowerCase()));
                  String source_hq = columninfovo.getTypename();
                  switch (DBType) {
                     case "MSSQLSERVER":
                        String source = JdbcTool.sqlServerTypeTran(columninfovo.getTypename(), columninfovo.getDatatype()).toLowerCase();
                        qualifierType = (String)data_s.get(source.toLowerCase());
                        columninfovo.setTypename(source);
                     default:
                        ColumnInfo columninfo = new ColumnInfo();
                        columninfo.setColumnName(columninfovo.getColumnname());
                        columninfo.setDataType(this.delparentheses(columninfovo.getTypename().toUpperCase()));
                        columninfo.setPrecision(columninfovo.getColumnsize());
                        columninfo.setScale(columninfovo.getDecimaldigits());
                        System.out.println(columninfo.getColumnName() + "," + columninfo.getDataType() + "," + columninfo.getPrecision() + "," + columninfo.getScale());
                        if ("YES".equals(columninfovo.getIsnullable())) {
                           columninfo.setNullable(0);
                        } else {
                           columninfo.setNullable(1);
                        }

                        columninfo.setQualifierType(qualifierType);
                        Map<String, String> maptarget = (Map)data_t.get(qualifierType);
                        TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByInsert(source_hq, sortnum, issomedb, targetisfile, maptarget, columninfovo);
                        String source1 = this.delparentheses(columninfovo.getTypename().toLowerCase());
                        String sourcelength = (String)((Map)data_s_length.get(source1)).get("sourcelength");
                        String sourcescancale = (String)((Map)data_s_length.get(source1)).get("sourcescancale");
                        String pwcsqlength = (String)((Map)data_s_length.get(source1)).get("pwcsqlength");
                        String pwcsqscale = (String)((Map)data_s_length.get(source1)).get("pwcsqscale");
                        String pwcdateformat = (String)((Map)data_s_length.get(source1)).get("pwcdateformat");
                        columninfo.setScale(sourcescancale != null && !sourcescancale.equals("") ? sourcescancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
                        columninfo.setPrecision(sourcelength != null && !sourcelength.equals("") ? sourcelength : tCoreMaskingTaskTableInfo.getColumnLength());
                        if (pwcsqlength != null && !pwcsqlength.equals("")) {
                           columninfo.setSqprecision(pwcsqlength);
                           columninfo.setSqscale(pwcsqscale);
                        }

                        if (pwcdateformat != null && !pwcdateformat.equals("") && config.getReadMode() == 1) {
                           columninfo.setDateTimeFormat(pwcdateformat);
                        }

                        sourceColumnInfoList.add(columninfo);
                        targetColumnInfoList.add(columninfo);
                  }
               }

               sourceInfo.setColumnInfoList(sourceColumnInfoList);
               TargetInfo targetInfo = new TargetInfo();
               targetInfo.setName(tableName);
               targetInfo.setSchema(targetSchema);
               targetInfo.setDataBaseType(tcoreDatasystem.getDbtype());
               targetInfo.setConnectName(targetconn);

               for(int j = 0; j < addcolumnlist.size(); ++j) {
                  JSONObject addcolumnobj = addcolumnlist.getJSONObject(j);
                  String columnname = addcolumnobj.getString("columnname");
                  String columnlength = addcolumnobj.getString("columnlength");
                  String columnscale = addcolumnobj.getString("columnscale");
                  String columntype = addcolumnobj.getString("columntype");
                  ColumnInfoVO columninfovo = new ColumnInfoVO();
                  columninfovo.setTypename(columntype);
                  columninfovo.setDatatype(tcoreDatasystem.getDbtype());
                  columninfovo.setColumnname(columnname);
                  columninfovo.setColumnsize(columnlength);
                  columninfovo.setDecimaldigits(columnscale);
                  columninfovo.setIsnullable("YES");
                  columninfovo.setPrimarykey("0");
                  columninfovo.setForeignkey("0");
                  String qualifierType = (String)data_s.get(this.delparentheses(columninfovo.getTypename().toLowerCase()));
                  if ("string".equalsIgnoreCase(qualifierType)) {
                     String columnvalue = addcolumnobj.getString("columnvalue");
                     addcolumnobj.put("columnvalue", "'" + columnvalue + "'");
                  }

                  addcolumnobj.put("columnqualifier", qualifierType);
                  String source_hq = columninfovo.getTypename();
                  switch (DBType) {
                     case "MSSQLSERVER":
                        String source = JdbcTool.sqlServerTypeTran(columninfovo.getTypename(), columninfovo.getDatatype()).toLowerCase();
                        qualifierType = (String)data_s.get(source.toLowerCase());
                        columninfovo.setTypename(source);
                     default:
                        ColumnInfo columninfo = new ColumnInfo();
                        columninfo.setColumnName(columninfovo.getColumnname().toUpperCase());
                        columninfo.setDataType(this.delparentheses(columninfovo.getTypename().toUpperCase()));
                        columninfo.setPrecision(columninfovo.getColumnsize());
                        columninfo.setScale(columninfovo.getDecimaldigits());
                        System.out.println(columninfo.getColumnName() + "," + columninfo.getDataType() + "," + columninfo.getPrecision() + "," + columninfo.getScale());
                        if ("YES".equals(columninfovo.getIsnullable())) {
                           columninfo.setNullable(0);
                        } else {
                           columninfo.setNullable(1);
                        }

                        columninfo.setQualifierType(qualifierType);
                        Map<String, String> maptarget = (Map)data_t.get(qualifierType);
                        TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByInsert(source_hq, sortnum, issomedb, targetisfile, maptarget, columninfovo);
                        String source1 = this.delparentheses(columninfovo.getTypename().toLowerCase());
                        if (data_s_length.get(source1) == null) {
                           rv.setResult(false);
                           rv.setMessage("不支持增字段类型！");
                           return rv;
                        }

                        String sourcelength = (String)((Map)data_s_length.get(source1)).get("sourcelength");
                        String sourcescancale = (String)((Map)data_s_length.get(source1)).get("sourcescancale");
                        String pwcsqlength = (String)((Map)data_s_length.get(source1)).get("pwcsqlength");
                        String pwcsqscale = (String)((Map)data_s_length.get(source1)).get("pwcsqscale");
                        String pwcdateformat = (String)((Map)data_s_length.get(source1)).get("pwcdateformat");
                        columninfo.setScale(sourcescancale != null && !sourcescancale.equals("") ? sourcescancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
                        columninfo.setPrecision(sourcelength != null && !sourcelength.equals("") ? sourcelength : tCoreMaskingTaskTableInfo.getColumnLength());
                        if (pwcsqlength != null && !pwcsqlength.equals("")) {
                           columninfo.setSqprecision(pwcsqlength);
                           columninfo.setSqscale(pwcsqscale);
                        }

                        if (pwcdateformat != null && !pwcdateformat.equals("") && config.getReadMode() == 1) {
                           columninfo.setDateTimeFormat(pwcdateformat);
                        }

                        targetColumnInfoList.add(columninfo);
                  }
               }

               targetInfo.setColumnInfoList(targetColumnInfoList);
               if (istruncate.equals("true")) {
                  targetInfo.setIsTruncate(0);
               } else {
                  targetInfo.setIsTruncate(1);
               }

               targetInfo.setWriteType(0);
               Info info = new Info();
               info.setTaskname(tableName);
               info.setSourceInfo(sourceInfo);
               info.setTargetInfo(targetInfo);
               infoList.add(info);
               if (i % 10 == 0) {
                  double d = (double)i / (double)dbtable.size() * (double)100.0F;
                  BigDecimal bigDecimal = new BigDecimal(d);
                  double d2 = bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue();
                  System.out.println("已加载:" + d2 + "%");
               }
            }
         }

         System.out.println("已加载:100%");
         System.out.println("开始生成xml文件");
         PowerXml.generatePowerXml4ThirdParty(infoList, config, codepage, DBType, powercenterVersion, stop_errors, commit_interval, log_view, ismulti, addcolumnlist);
         Date enddate = new Date();
         long aa = enddate.getTime() - startdate.getTime();
         System.out.println("执行成功,总计用时:" + aa + "ms");
         System.out.println("---------------------------end----------------------------");
         InputStream in = XmlTool.class.getClassLoader().getResourceAsStream("infofile" + File.separator + "con_import.xml");
         SAXReader reader = new SAXReader();
         reader.setEntityResolver(new IgnoreDTDEntityResolver());
         Document doc = reader.read(in);
         in.close();
         Element ruleElement = (Element)doc.selectSingleNode("IMPORTPARAMS/FOLDERMAP");
         Attribute targetrepositoryname = ruleElement.attribute("TARGETREPOSITORYNAME");
         targetrepositoryname.setValue(repository);
         Attribute targetfoldername = ruleElement.attribute("TARGETFOLDERNAME");
         targetfoldername.setValue(folder);
         Attribute sourcerepositoryname = ruleElement.attribute("SOURCEREPOSITORYNAME");
         sourcerepositoryname.setValue(repository);
         Attribute sourcefoldername = ruleElement.attribute("SOURCEFOLDERNAME");
         sourcefoldername.setValue(folder);
         DomUtils.writeXml(doc, savePath + "con_import.xml");
         System.out.println("成功生成con_import.xml");
         FileTool.createFile(savePath + "log.txt");
         System.out.println("成功生成log.txt");
         String content = "$INFA_HOME/server/bin/pmrep objectimport -i ./import.xml -c ./con_import.xml -l ./log.txt";
         FileTool.clearFileContent(savePath + "import.sh");
         FileTool.writeContentToFile(savePath + "import.sh", content);
         System.out.println("成功生成import.sh");
         rv.setResult(true);
         rv.setMessage("创建成功");
      } catch (Exception e) {
         rv.setResult(false);
         rv.setMessage("创建失败");
         e.printStackTrace();
         System.out.println("配置文件读取异常!");
      }

      return rv;
   }

   @RequestMapping({"/downloadzip"})
   public String downloadzip(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
      System.out.println("in downloadzip");
      String savePath = "E:\\xmltest\\dym\\";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      savePath = props.getProperty("xmlLocation");
      String xmlPath = savePath + "import.xml";
      String conPath = savePath + "con_import.xml";
      String logPath = savePath + "log.txt";
      String shPath = savePath + "import.sh";
      String fileName = "test.zip";
      response.setContentType("text/html; charset=UTF-8");
      response.setContentType("application/octet-stream");
      response.setHeader("Content-disposition", "attachment;filename=" + fileName);
      OutputStream out = response.getOutputStream();
      String zipName = "infa.zip";
      String zipFilePath = savePath + File.separator + zipName;
      List<String> filePaths = new ArrayList();
      filePaths.add(xmlPath);
      filePaths.add(conPath);
      filePaths.add(logPath);
      filePaths.add(shPath);
      File zip = new File(zipFilePath);
      if (!zip.exists()) {
         zip.createNewFile();
      }

      ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
      this.zipFile(savePath, zipName, zipFilePath, filePaths, zos);
      zos.close();
      response.setHeader("Content-disposition", "attachment;filename=" + zipName);
      BufferedInputStream bis = new BufferedInputStream(new FileInputStream(zipFilePath));
      byte[] buff = new byte[bis.available()];
      bis.read(buff);
      bis.close();
      out.write(buff);
      out.flush();
      out.close();
      return null;
   }

   private String zipFile(String zipBasePath, String zipName, String zipFilePath, List<String> filePaths, ZipOutputStream zos) throws IOException {
      for(String filePath : filePaths) {
         File inputFile = new File(filePath);
         if (inputFile.exists()) {
            if (!inputFile.isFile()) {
               try {
                  File[] files = inputFile.listFiles();
                  List<String> filePathsTem = new ArrayList();

                  for(File fileTem : files) {
                     filePathsTem.add(fileTem.toString());
                  }

                  return this.zipFile(zipBasePath, zipName, zipFilePath, filePathsTem, zos);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
               zos.putNextEntry(new ZipEntry(inputFile.getName()));
               int size = 0;
               byte[] buffer = new byte[1024];

               while((size = bis.read(buffer)) > 0) {
                  zos.write(buffer, 0, size);
               }

               zos.closeEntry();
               bis.close();
            }
         }
      }

      return null;
   }

   public Map<String, String> EdataMappingType() {
      Map<String, String> map = new HashMap();

      for(EdataMappingType em : EdataMappingType.values()) {
         map.put(em.getName(), em.getFlag());
      }

      return map;
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByInsert(String source_hq, int sortnum, boolean issomedb, boolean isfile, Map<String, String> maptarget, ColumnInfoVO columnInfoVO) {
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
      tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setIsPrimaryKey(columnInfoVO.getPrimarykey());
      tCoreMaskingTaskTableInfo.setIsForeignKey(columnInfoVO.getForeignkey());
      tCoreMaskingTaskTableInfo.setColumnName(columnInfoVO.getColumnname());
      tCoreMaskingTaskTableInfo.setSearchType("");
      tCoreMaskingTaskTableInfo.setSourceType(columnInfoVO.getTypename());
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? columnInfoVO.getTypename() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !isfile ? (String)maptarget.get("targetlength") : columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !isfile ? (String)maptarget.get("targetdecimal") : columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setColumnLength(columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setColumnPrecision(columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setRegexRuleId("");
      tCoreMaskingTaskTableInfo.setRegexRuleName("");
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   private String zipFile(List<String> filePaths, ZipOutputStream zos) throws IOException {
      for(String filePath : filePaths) {
         File inputFile = new File(filePath);
         if (inputFile.exists()) {
            if (!inputFile.isFile()) {
               try {
                  File[] files = inputFile.listFiles();
                  List<String> filePathsTem = new ArrayList();

                  for(File fileTem : files) {
                     filePathsTem.add(fileTem.toString());
                  }

                  return this.zipFile(filePathsTem, zos);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
               zos.putNextEntry(new ZipEntry(inputFile.getName()));
               int size = 0;
               byte[] buffer = new byte[1024];

               while((size = bis.read(buffer)) > 0) {
                  zos.write(buffer, 0, size);
               }

               zos.closeEntry();
               bis.close();
            }
         }
      }

      return null;
   }
}
