package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.encryption.DesensitizationStrategyDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitizationStrategy;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.RowSensitiveLevelReqVO;
import com.chenyang.nse.bussiness.entity.vo.RowSensitivelevelVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.SensitivelevelVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ScopeInfoVO;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.RowSensitiveLevelService;
import com.chenyang.nse.bussiness.service.core.udf.UdfService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/rowsensitivelevel"})
public class RowSensitiveLevelController {
   @Autowired
   private RowSensitiveLevelService rowSensitiveLevelService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   DesensitizationStrategyDao desensitizationStrategyDao;
   @Autowired
   UdfService udfService;

   @ResponseBody
   @RequestMapping({"/queryTables"})
   public Response<List<Map<String, String>>> queryTables(@RequestBody RowSensitiveLevelReqVO vo) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(vo.getDataSystemId(), vo.getSchema());
      List<String> tables = (List)list.stream().map((e) -> new String(e.getTablename())).collect(Collectors.toList());
      Collections.sort(tables);
      List<Map<String, String>> newTables = new ArrayList();

      for(int i = 0; i < tables.size(); ++i) {
         Map<String, String> tableMap = new HashMap();
         tableMap.put("realName", tables.get(i));
         tableMap.put("showName", this.udfService.getSourceTable((String)tables.get(i)));
         newTables.add(tableMap);
      }

      return RespHelper.<List<Map<String, String>>>successResp(newTables);
   }

   @ResponseBody
   @RequestMapping({"/queryDesensitizationTables"})
   public Response<List<String>> queryDesensitizationTables(@RequestBody RowSensitiveLevelReqVO vo) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(vo.getDataSystemId(), vo.getSchema());
      List<String> tables = (List)list.stream().map((e) -> new String(e.getTablename())).collect(Collectors.toList());
      int t = tables.size();
      if (t > 0) {
         for(int i = 0; i < tables.size(); ++i) {
            String tableName = (String)tables.get(i);
            if (!tableName.toLowerCase().contains(vo.getTableName().toLowerCase())) {
               tables.remove(i);
               --i;
            }
         }
      }

      if (null != vo.getDataareaid() && !"".equals(vo.getDataareaid())) {
         List<TCoreDesensitizationStrategy> desensitStrategyList;
         if (null != vo.getStrategyId() && !"".equals(vo.getStrategyId())) {
            desensitStrategyList = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("dataareaid", vo.getDataareaid()), Restrictions.eq("strategyid", vo.getStrategyId()), Restrictions.eq("datasystem_id", vo.getDataSystemId()), Restrictions.eq("tschemas", vo.getSchema())});
         } else {
            desensitStrategyList = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("dataareaid", vo.getDataareaid()), Restrictions.eq("datasystem_id", vo.getDataSystemId()), Restrictions.eq("tschemas", vo.getSchema())});
         }

         int d = desensitStrategyList.size();
         if (d > 0) {
            List<String> tableNameList = new ArrayList();

            for(int y = 0; y < d; ++y) {
               String tableName1 = ((TCoreDesensitizationStrategy)desensitStrategyList.get(y)).getNames();
               tableNameList.add(tableName1);
            }

            int t1 = tables.size();
            if (t1 > 0) {
               for(int i1 = 0; i1 < tables.size(); ++i1) {
                  String tableName2 = (String)tables.get(i1);
                  if (!tableNameList.contains(tableName2.toLowerCase())) {
                     tables.remove(i1);
                     --i1;
                  }
               }
            }
         } else {
            for(int i1 = 0; i1 < tables.size(); ++i1) {
               tables.remove(i1);
               --i1;
            }
         }
      }

      if (null != vo.getState() && !"".equals(vo.getState())) {
         List<TCoreDesensitizationStrategy> desensitStrategyList1;
         if (null != vo.getStrategyId() && !"".equals(vo.getStrategyId())) {
            desensitStrategyList1 = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", vo.getDataSystemId()), Restrictions.eq("strategyid", vo.getStrategyId()), Restrictions.eq("tschemas", vo.getSchema())});
         } else {
            desensitStrategyList1 = this.desensitizationStrategyDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", vo.getDataSystemId()), Restrictions.eq("tschemas", vo.getSchema())});
         }

         int d1 = desensitStrategyList1.size();
         if (d1 > 0) {
            List<String> tableNameList = new ArrayList();

            for(int y1 = 0; y1 < d1; ++y1) {
               if (null != ((TCoreDesensitizationStrategy)desensitStrategyList1.get(y1)).getRuleid() && !"".equals(((TCoreDesensitizationStrategy)desensitStrategyList1.get(y1)).getRuleid())) {
                  String tableName2 = ((TCoreDesensitizationStrategy)desensitStrategyList1.get(y1)).getNames();
                  tableNameList.add(tableName2);
               }
            }

            int t2 = tables.size();
            if (t2 > 0) {
               for(int i2 = 0; i2 < tables.size(); ++i2) {
                  String tableName3 = (String)tables.get(i2);
                  if (tableNameList.contains(tableName3) && vo.getState().equals("0")) {
                     tables.remove(i2);
                     --i2;
                  }

                  if (!tableNameList.contains(tableName3) && vo.getState().equals("1")) {
                     tables.remove(i2);
                     --i2;
                  }
               }
            }
         } else if ("1".equals(vo.getState())) {
            for(int i1 = 0; i1 < tables.size(); ++i1) {
               tables.remove(i1);
               --i1;
            }
         }
      }

      Collections.sort(tables);
      return RespHelper.<List<String>>successResp(tables);
   }

   @ResponseBody
   @RequestMapping({"/queryViews"})
   public Response<List<String>> queryViews(@RequestBody RowSensitiveLevelReqVO vo) {
      List<String> list = this.dataSystemService.queryView(vo.getDataSystemId(), vo.getSchema());
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/querySynonyms"})
   public Response<List<String>> querySynonyms(@RequestBody RowSensitiveLevelReqVO vo) {
      List<String> list = this.dataSystemService.querySynonym(vo.getDataSystemId(), vo.getSchema());
      Collections.sort(list);
      return RespHelper.<List<String>>successResp(list);
   }

   @ResponseBody
   @PostMapping({"/query"})
   public Response<RowSensitivelevelVO> queryLineLevelBysql(@RequestBody RowSensitivelevelVO sensitivelevelVO) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(sensitivelevelVO.getPage());
      pageInfo.setPagesize(sensitivelevelVO.getRows());
      RowSensitivelevelVO rowSensitivelevelVO = null;

      try {
         rowSensitivelevelVO = this.rowSensitiveLevelService.queryRowLevelBysql(pageInfo, sensitivelevelVO);
      } catch (Exception e) {
         StringWriter sw = new StringWriter();
         PrintWriter pw = new PrintWriter(sw);
         e.printStackTrace(pw);
         String content = sw.toString();
         return RespHelper.<RowSensitivelevelVO>createResp(false, "POP_00022", MesUtil.getMsg("DIS_ERR_02", new String[]{content}));
      }

      rowSensitivelevelVO.setPageInfo(pageInfo);
      return RespHelper.<RowSensitivelevelVO>successResp(rowSensitivelevelVO);
   }

   @ResponseBody
   @PostMapping({"/save"})
   public Response<RowSensitivelevelVO> saveLineLevelBysql(@RequestBody RowSensitivelevelVO rowSensitivelevelVO) throws Exception {
      this.rowSensitiveLevelService.saveRowLevelBysql(rowSensitivelevelVO);
      return RespHelper.<RowSensitivelevelVO>successResp(rowSensitivelevelVO);
   }

   @ResponseBody
   @RequestMapping({"/getSensitivelist"})
   public Response<List<SensitivelevelVO>> geteditionlist(@RequestBody SensitivelevelVO vo) {
      List<SensitivelevelVO> list = this.rowSensitiveLevelService.getSensitivelist(vo.getId(), vo.getEdition_id());
      return RespHelper.<List<SensitivelevelVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryScope2Sensitive"})
   public Response<List<ScopeInfoVO>> queryScope2Sensitive(@RequestBody RowSensitiveLevelReqVO vo) {
      String scopeid = vo.getScopeId();
      String sensitiveid = vo.getSensitiveId();
      String dataSystemId = vo.getDataSystemId();
      String schema = vo.getSchema();
      String projectid = vo.getProjectId();
      List<ScopeInfoVO> retMap = this.rowSensitiveLevelService.queryScope2Sensitive(scopeid, sensitiveid, dataSystemId, schema, projectid);
      return RespHelper.<List<ScopeInfoVO>>successResp(retMap);
   }
}
