package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/sensitivecolumnlog"})
public class SensitiveLogController {
   @Autowired
   private SensitiveColumnService sensitiveColumnService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/sensitivecolumn/sensitivelog";
   }

   @RequestMapping({"/remove"})
   public void remove(String sensitivecolumnid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.sensitiveColumnService.remove(sensitivecolumnid);
   }

   @RequestMapping({"/queryAllSensitiveColumns"})
   @ResponseBody
   public DataGridVO<TCoreSensitivecolumn> queryAllSensitiveColumns(Boolean sensitive, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreSensitivecolumn> list;
      if (sensitive) {
         list = this.sensitiveColumnService.queryValidSensitiveColumns(pageInfo);
      } else {
         list = this.sensitiveColumnService.queryAllSensitiveColumns(pageInfo);
      }

      DataGridVO<TCoreSensitivecolumn> vo = new DataGridVO<TCoreSensitivecolumn>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/queryAllSensitiveColumnsNoPage"})
   @ResponseBody
   public List<TCoreSensitivecolumn> queryAllSensitiveColumnsNoPage(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreSensitivecolumn> listt = this.sensitiveColumnService.queryAllSensitiveColumns();
      return listt;
   }
}
