package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.service.core.SwitchFieldService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionProxyService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"switchfield"})
public class SwitchFieldController {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   protected SwitchFieldService switchFieldService;
   @Autowired
   EncryptionProxyService encryptionProxyService;
   @Autowired
   private TCoreProjectDatasourceDao tCoreProjectDatasourceDao;

   @RequestMapping({"encryptbatchswitch"})
   public Response<String> encryptbatchswitch(@RequestBody Map<String, String> map) {
      StringBuilder errStr = new StringBuilder();
      this.logger.info(map != null ? map.toString() : "");
      String dataSystemId = (String)map.get("dataSystemId");
      if (!StringUtils.hasText(dataSystemId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "dataSystemId is required");
      } else {
         String schema = (String)map.get("schema");
         if (!StringUtils.hasText(schema)) {
            return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "schema is required");
         } else {
            String tableName = (String)map.get("tableName");
            if (!StringUtils.hasText(tableName)) {
               return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "tableName is required");
            } else {
               String projectId = (String)map.get("projectId");
               if (!StringUtils.hasText(projectId)) {
                  return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
               } else {
                  List<TCoreEncryptionTypeField> fields;
                  try {
                     fields = this.switchFieldService.switchFieldAfterEncryption(projectId, dataSystemId, schema, tableName, errStr);
                  } catch (Exception var11) {
                     return RespHelper.<String>errResp(ErrCode.REDUNDANCE_COLUMN);
                  }

                  List<TCoreProjectDatasource> relations = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("systemsource_id", dataSystemId)});
                  if (relations != null && relations.size() > 0) {
                     for(TCoreProjectDatasource relation : relations) {
                        this.encryptionProxyService.noticeProxyFetchEngineAndMaskingInfosByProject(relation.getProject_id());
                     }
                  }

                  if (fields.size() != 0) {
                     String c = new String();

                     for(int i = 0; i < fields.size(); ++i) {
                        if (i != 0) {
                           c = c + ",";
                        }

                        c = c + ((TCoreEncryptionTypeField)fields.get(i)).getTschemas() + "." + ((TCoreEncryptionTypeField)fields.get(i)).getNames() + "." + ((TCoreEncryptionTypeField)fields.get(i)).getTable_field_id();
                     }

                     errStr.append("字段" + c + "加载替换校验失败.");
                  }

                  return errStr.length() > 0 ? RespHelper.successResp(errStr.toString()) : RespHelper.successResp();
               }
            }
         }
      }
   }

   @RequestMapping({"decryptbatchswitch"})
   public Response<String> decryptbatchswitch(@RequestBody Map<String, String> map) {
      StringBuilder errStr = new StringBuilder();
      this.logger.info(map != null ? map.toString() : "");
      String dataSystemId = (String)map.get("dataSystemId");
      if (!StringUtils.hasText(dataSystemId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "dataSystemId is required");
      } else {
         String schema = (String)map.get("schema");
         if (!StringUtils.hasText(schema)) {
            return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "schema is required");
         } else {
            String tableName = (String)map.get("tableName");
            if (!StringUtils.hasText(tableName)) {
               return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "tableName is required");
            } else {
               String projectId = (String)map.get("projectId");
               if (!StringUtils.hasText(projectId)) {
                  return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
               } else {
                  List<TCoreEncryptionTypeField> fields;
                  try {
                     fields = this.switchFieldService.switchFieldAfterDecryption(projectId, dataSystemId, schema, tableName, errStr);
                  } catch (Exception var11) {
                     return RespHelper.<String>errResp(ErrCode.REDUNDANCE_COLUMN);
                  }

                  List<TCoreProjectDatasource> relations = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("systemsource_id", dataSystemId)});
                  if (relations != null && relations.size() > 0) {
                     for(TCoreProjectDatasource relation : relations) {
                        this.encryptionProxyService.noticeProxyFetchEngineAndMaskingInfosByProject(relation.getProject_id());
                     }
                  }

                  if (fields.size() != 0) {
                     String c = new String();

                     for(int i = 0; i < fields.size(); ++i) {
                        if (i != 0) {
                           c = c + ",";
                        }

                        c = c + ((TCoreEncryptionTypeField)fields.get(i)).getTschemas() + "." + ((TCoreEncryptionTypeField)fields.get(i)).getNames() + "." + ((TCoreEncryptionTypeField)fields.get(i)).getTable_field_id();
                     }

                     errStr.append("字段" + c + "解密替换校验失败");
                  }

                  return errStr.length() > 0 ? RespHelper.successResp(errStr.toString()) : RespHelper.successResp("ok");
               }
            }
         }
      }
   }

   @RequestMapping({"encryptbatchswitchProject"})
   public Response<String> encryptbatchswitchProject(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String projectId = (String)map.get("projectId");
      if (!StringUtils.hasText(projectId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
      } else {
         this.switchFieldService.switchFieldEncryptionProject(projectId);
         return RespHelper.<String>successResp();
      }
   }

   @RequestMapping({"decryptbatchswitchProject"})
   public Response<String> decryptbatchswitchProject(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String projectId = (String)map.get("projectId");
      if (!StringUtils.hasText(projectId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "projectId is required");
      } else {
         this.switchFieldService.switchFieldDecryptionProject(projectId);
         return RespHelper.<String>successResp("ok");
      }
   }

   @RequestMapping({"addColumn"})
   public Response<String> addColumn(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String dataSystemId = (String)map.get("dataSystemId");
      if (!StringUtils.hasText(dataSystemId)) {
         return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "dataSystemId is required");
      } else {
         String schema = (String)map.get("schema");
         if (!StringUtils.hasText(schema)) {
            return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "schema is required");
         } else {
            String tableName = (String)map.get("tableName");
            if (!StringUtils.hasText(tableName)) {
               return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "tableName is required");
            } else {
               String columnName = (String)map.get("columnName");
               if (!StringUtils.hasText(columnName)) {
                  return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "columnName is required");
               } else {
                  String columnType = (String)map.get("columnType");
                  if (!StringUtils.hasText(columnType)) {
                     return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "columnType is required");
                  } else {
                     String columnSize = (String)map.get("columnSize");
                     if (!StringUtils.hasText(columnSize)) {
                        return RespHelper.<String>createResp(ErrCode.REQ_PARAM_ERROR.getCode(), "columnSize is required");
                     } else {
                        try {
                           this.switchFieldService.addColumn(dataSystemId, schema, tableName, columnName, columnType, columnSize);
                           return RespHelper.<String>successResp();
                        } catch (Exception e) {
                           e.printStackTrace();
                           return RespHelper.<String>createResp("333", e.getMessage());
                        }
                     }
                  }
               }
            }
         }
      }
   }

   @RequestMapping({"delTableColumn"})
   public Response<String> delTableColumn(@RequestBody Map<String, String> map) {
      this.logger.info(map != null ? map.toString() : "");
      String projectId = (String)map.get("projectId");
      if (!StringUtils.hasText(projectId)) {
         return RespHelper.<String>createResp(false, "POP_000134", MesUtil.getMsg("POP_000134", new String[0]));
      } else {
         String dataSystemId = (String)map.get("dataSystemId");
         if (!StringUtils.hasText(dataSystemId)) {
            return RespHelper.<String>createResp(false, "POP_000103", MesUtil.getMsg("POP_000103", new String[0]));
         } else {
            String schema = (String)map.get("schema");
            if (!StringUtils.hasText(schema)) {
               return RespHelper.<String>createResp(false, "POP_000104", MesUtil.getMsg("POP_000104", new String[0]));
            } else {
               String tableName = (String)map.get("tableName");
               if (!StringUtils.hasText(tableName)) {
                  return RespHelper.<String>createResp(false, "POP_000131", MesUtil.getMsg("POP_000131", new String[0]));
               } else {
                  try {
                     String okBoolean = this.switchFieldService.newDelTableColumn(projectId, dataSystemId, schema, tableName);
                     if ("OK".equals(okBoolean)) {
                        return RespHelper.<String>successResp();
                     } else {
                        return "hasfailedstatus".equals(okBoolean) ? RespHelper.createResp(false, "POP_0001333", MesUtil.getMsg("POP_0001333", new String[]{"加解密失败情况下，不允许删除多余列！"})) : RespHelper.createResp(false, "POP_0001333", MesUtil.getMsg("POP_0001333", new String[]{okBoolean}));
                     }
                  } catch (Exception e) {
                     e.printStackTrace();
                     return RespHelper.<String>createResp("POP_000153", e.getMessage());
                  }
               }
            }
         }
      }
   }

   @RequestMapping({"delBatchTableColumn"})
   public Response<String> delBatchTableColumn(@RequestBody Map<String, String> map) {
      String projectid = (String)map.get("projectid");

      try {
         String okBoolean = this.switchFieldService.newDelBatchTableColumn(projectid);
         if ("OK".equals(okBoolean)) {
            return RespHelper.<String>successResp();
         } else {
            return "hasfailedstatus".equals(okBoolean) ? RespHelper.createResp(false, "POP_0001333", MesUtil.getMsg("POP_0001333", new String[]{"加解密失败情况下，不允许删除多余列！"})) : RespHelper.createResp(false, "POP_0001333", MesUtil.getMsg("POP_0001333", new String[]{okBoolean}));
         }
      } catch (Exception e) {
         e.printStackTrace();
         return RespHelper.<String>createResp("POP_000153", e.getMessage());
      }
   }
}
