package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreBussinessSystem;
import com.chenyang.nse.bussiness.service.core.IBussinessSystemService;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/bussiness_system"})
public class TCoreBussinessSystemController {
   private static Logger logger = LoggerFactory.getLogger(TCoreBussinessSystemController.class);
   @Autowired
   private IBussinessSystemService bussinessSystemService;

   @RequestMapping({"/delete"})
   public Response<String> delete(@RequestBody TCoreBussinessSystem bussinessSystem) {
      try {
         this.bussinessSystemService.delete(bussinessSystem);
      } catch (Exception e) {
         e.printStackTrace();
         logger.info(e.getMessage());
         RespHelper.errResp(ErrCode.SERVER_EXCEPTION);
      }

      return RespHelper.<String>successResp(null);
//      return RespHelper.<String>successResp(null);
   }

   @RequestMapping({"/saveorupdate"})
   public Response<String> saveOrUdpate(@RequestBody TCoreBussinessSystem bussinessSystem) {
      try {
         this.bussinessSystemService.saveOrUpdate(bussinessSystem);
      } catch (Exception e) {
         e.printStackTrace();
         logger.info(e.getMessage());
         RespHelper.errResp(ErrCode.SERVER_EXCEPTION);
      }

      return RespHelper.<String>successResp(null);
//      return RespHelper.<String>successResp(null);
   }

   @RequestMapping({"/querylist"})
   public Response<List<TCoreBussinessSystem>> queryList(@RequestBody TCoreBussinessSystem bussinessSystem) {
      Response<List<TCoreBussinessSystem>> res = new Response<List<TCoreBussinessSystem>>();
      List<TCoreBussinessSystem> result = null;

      try {
         result = this.bussinessSystemService.queryList(bussinessSystem);
      } catch (Exception e) {
         e.printStackTrace();
         logger.info(e.getMessage());
         RespHelper.errResp(ErrCode.SERVER_EXCEPTION);
      }

      res.setTotalCount(this.bussinessSystemService.getTotalCount());
      res.setData(result);
      res.setCode("POP_00014");
      res.setMsg(MesUtil.getMsg("POP_00014", new String[0]));
      res.setFlag(true);
      return res;
   }

   @RequestMapping({"queryunique"})
   public Response<TCoreBussinessSystem> queryUnique(@RequestBody TCoreBussinessSystem bussinessSystem) {
      TCoreBussinessSystem tCoreBussinessSystem = this.bussinessSystemService.queryById(bussinessSystem.getId());
      return RespHelper.<TCoreBussinessSystem>successResp(tCoreBussinessSystem);
   }
}
