package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectChooseList;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreWatermarkKeyInfo;
import com.chenyang.nse.bussiness.entity.vo.DataAreaAndRuleVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.tools.engine.mapplet.MyEntityResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/tdataarea"})
public class TdataAreaController {
   @Autowired
   private TdataProjectService tdataProjectService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      model.addAttribute("id", id);
      return "core/dataproject/tdataarea";
   }

   @ResponseBody
   @RequestMapping({"/getAllDataAreaAndRule"})
   public Response<List<DataAreaAndRuleVO>> getAllDataAreaAndRule() {
      List<DataAreaAndRuleVO> drList = new ArrayList();
      List<TCoreDataArea> list = this.tdataProjectService.selectDataAreaHasFindRule();

      for(int i = 0; i < list.size(); ++i) {
         DataAreaAndRuleVO dataAreaAndRuleVO = new DataAreaAndRuleVO();
         List<TConsoleSearchregex> findRuleList = this.tdataProjectService.selectDataAreaFindRule(((TCoreDataArea)list.get(i)).getId());
         dataAreaAndRuleVO.setList(findRuleList);
         dataAreaAndRuleVO.setId(((TCoreDataArea)list.get(i)).getId());
         dataAreaAndRuleVO.setDataarea(((TCoreDataArea)list.get(i)).getDataarea());
         drList.add(dataAreaAndRuleVO);
      }

      return RespHelper.<List<DataAreaAndRuleVO>>successResp(drList, drList.size());
   }

   @ResponseBody
   @RequestMapping({"/saveDataArea"})
   public Response<String> saveDataArea(@RequestBody TCoreProjectFindrule obj, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.saveDataArea(obj);
      return RespHelper.<String>successResp("success");
   }

   @ResponseBody
   @RequestMapping({"/deleteDataArea"})
   public String deleteDataArea(TCoreProjectFindrule obj, String changedefault, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.deleteDataArea(obj);
      if ("1".equals(changedefault)) {
         String ruleid = this.tdataProjectService.changeDefault(obj);
         return ruleid;
      } else {
         return "fault";
      }
   }

   @ResponseBody
   @RequestMapping({"/isAll"})
   public String isAll(String project_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      String is = this.tdataProjectService.isAll(project_id);
      return is;
   }

   @ResponseBody
   @RequestMapping({"/deleteDataAreaList"})
   public void deleteDataAreaList(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
   }

   @ResponseBody
   @RequestMapping({"/defaultRow"})
   public void defaultRow(String rule_id, String project_id, String dataarea_id, String rulestyle, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.defaultRow(rule_id, project_id, dataarea_id, rulestyle);
   }

   @ResponseBody
   @RequestMapping({"/resetDefault"})
   public void resetDefault(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.resetDefault(id);
   }

   @ResponseBody
   @RequestMapping({"/selectDataArea"})
   public Response<List<TCoreDataArea>> selectDataArea(@RequestBody Map<String, String> params) {
      String project_id = (String)params.get("project_id");
      List<TCoreDataArea> list = this.tdataProjectService.selectDataArea();
      List<Map<String, Object>> list1 = this.tdataProjectService.selectDataAreaHas(project_id);

      for(TCoreDataArea tCoreDataArea : list) {
         for(Map<String, Object> map : list1) {
            if (tCoreDataArea.getId().equals(map.get("dataarea_id"))) {
               tCoreDataArea.setHasarea("1");
            }
         }
      }

      return RespHelper.<List<TCoreDataArea>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreas"})
   public List<TCoreDataArea> selectDataAreas(String project_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDataArea> lists = new ArrayList();
      List<TCoreDataArea> list = this.tdataProjectService.selectDataArea();
      List<Map<String, Object>> list1 = this.tdataProjectService.selectDataAreaHas(project_id);

      for(TCoreDataArea tCoreDataArea : list) {
         for(Map<String, Object> map : list1) {
            if (tCoreDataArea.getId().equals(map.get("dataarea_id"))) {
               lists.add(tCoreDataArea);
            }
         }
      }

      return lists;
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreasEM"})
   public List<TCoreDataArea> selectDataAreasEM(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDataArea> lists = new ArrayList();
      TCoreDataArea tCoreDataArea1 = new TCoreDataArea();
      tCoreDataArea1.setId("gongzi");
      tCoreDataArea1.setDataarea("工资");
      lists.add(tCoreDataArea1);
      TCoreDataArea tCoreDataArea2 = new TCoreDataArea();
      tCoreDataArea2.setId("zhiwei");
      tCoreDataArea2.setDataarea("职位");
      lists.add(tCoreDataArea2);
      return lists;
   }

   @ResponseBody
   @RequestMapping({"/deleteTable"})
   public void deleteTable(String project_id, String dataarea_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.deleteTable(project_id, dataarea_id);
   }

   @ResponseBody
   @RequestMapping({"/saveAllDataArea"})
   public void saveAllDataArea(@RequestBody Map<String, String> map) {
      String project_id = ((String)map.get("project_id")).toString();
      String dataarea_id = ((String)map.get("dataarea_id")).toString();
      String defaultid = ((String)map.get("defaultid")).toString();
      this.tdataProjectService.saveAllFind(project_id, dataarea_id, defaultid);
   }

   @ResponseBody
   @RequestMapping({"/deleteAllDataArea"})
   public void deleteAllDataArea(String project_id, String dataarea_id) {
      this.tdataProjectService.deleteAllDataArea(project_id, dataarea_id);
   }

   @ResponseBody
   @RequestMapping({"/saveAll"})
   public void saveAll(String project_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.saveAll(project_id);
   }

   @ResponseBody
   @RequestMapping({"/deleteAll"})
   public void deleteAll(String project_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.deleteAll(project_id);
   }

   @ResponseBody
   @RequestMapping({"/selectCheckDataArea"})
   public DataGridVO<TCoreProjectChooseList> selectCheckDataArea(String project_id, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      long tableCount = 0L;
      List<Map<String, Object>> list = this.tdataProjectService.selectCheckDataArea(project_id);
      List<TCoreProjectChooseList> list1 = new ArrayList();
      List<String> idList = new ArrayList();

      for(Map<String, Object> map : list) {
         TCoreProjectChooseList s = new TCoreProjectChooseList();
         if (!idList.contains(map.get("areatid"))) {
            s.setRulestyle("3");
            s.setRuleid((String)map.get("areatid"));
            s.setRulename((String)map.get("dataarea"));
            idList.add((String)map.get("areatid"));
            ++tableCount;
            List<TCoreProjectChooseList> list2 = new ArrayList();

            for(Map<String, Object> map1 : list) {
               if (map1.get("areatid").equals(map.get("areatid"))) {
                  TCoreProjectChooseList s1 = new TCoreProjectChooseList();
                  s1.setTid((String)map1.get("id"));
                  s1.setDataarea_id((String)map.get("areatid"));
                  s1.setDataareaname((String)map.get("dataarea"));
                  s1.setRulestyle((String)map1.get("rulestyle"));
                  s1.setRuleid((String)map1.get("ruleid"));
                  s1.setRulename((String)map1.get("rulename"));
                  s1.setRuleexample((String)map1.get("ruleexample"));
                  s1.setDefaultrule((String)map1.get("defaultrule"));
                  list2.add(s1);
               }

               s.setChildren(list2);
            }

            list1.add(s);
         }
      }

      List<TCoreProjectChooseList> list2 = new ArrayList();
      if (!list1.isEmpty()) {
         if (list1.size() > page * rows) {
            list2 = list1.subList((page - 1) * rows, page * rows);
         } else {
            list2 = list1.subList((page - 1) * rows, list1.size());
         }
      }

      DataGridVO<TCoreProjectChooseList> vo = new DataGridVO<TCoreProjectChooseList>(tableCount, list2);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreaFindRule"})
   public Response<List<TCoreProjectAllrule>> selectDataAreaFindRule(@RequestBody TCoreProjectFindrule obj, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreProjectAllrule> listfind = this.tdataProjectService.selectDataAreaFindRule(obj);
      return RespHelper.<List<TCoreProjectAllrule>>successResp(listfind);
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreaFindRules"})
   public List<TCoreProjectAllrule> selectDataAreaFindRules(TCoreProjectFindrule obj, String searchstr, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreProjectAllrule> lists = new ArrayList();

      for(TCoreProjectAllrule tCoreProjectAllrule : this.tdataProjectService.selectDataAreaMaskingRule(obj, searchstr)) {
         if ("1".equals(tCoreProjectAllrule.getCheckstyle())) {
            lists.add(tCoreProjectAllrule);
         }
      }

      return lists;
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreaFindRulesEM"})
   public List<TCoreProjectAllrule> selectDataAreaFindRulesEM(TCoreProjectFindrule obj, String searchstr, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreProjectAllrule> lists = new ArrayList();
      if ("gongzi".equals(obj.getDataarea_id())) {
         TCoreProjectAllrule tCoreProjectAllrule1 = new TCoreProjectAllrule();
         tCoreProjectAllrule1.setRule_id("suijitihuan");
         tCoreProjectAllrule1.setRulename("工资随机替换");
         lists.add(tCoreProjectAllrule1);
         TCoreProjectAllrule tCoreProjectAllrule2 = new TCoreProjectAllrule();
         tCoreProjectAllrule2.setRule_id("xingtihuan");
         tCoreProjectAllrule2.setRulename("工资全*替换");
         lists.add(tCoreProjectAllrule2);
      } else if ("zhiwei".equals(obj.getDataarea_id())) {
         TCoreProjectAllrule tCoreProjectAllrule1 = new TCoreProjectAllrule();
         tCoreProjectAllrule1.setRule_id("xingtihuan");
         tCoreProjectAllrule1.setRulename("职务全*替换");
         lists.add(tCoreProjectAllrule1);
      }

      return lists;
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreaMaskingRule"})
   public List<TCoreMaskingRule> selectDataAreaMaskingRule(String projectid) {
      List<TCoreMaskingRule> list = this.tdataProjectService.queryMaskingRule(projectid);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/selectDataAreaMaskingRules"})
   public Response<List<TCoreMaskingRuleinfo>> selectDataAreaMaskingRules(TCoreProjectFindrule obj, String searchstr, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingRuleinfo> listmasking = this.tdataProjectService.selectDataAreaMaskingRules(obj, searchstr);
      return RespHelper.<List<TCoreMaskingRuleinfo>>successResp(listmasking);
   }

   @ResponseBody
   @RequestMapping({"/selectMaskingRule"})
   public Map<String, String> selectMaskingRule(String mappletname) throws DocumentException {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("xml_mapplet_file_path");
      File f = new File(path + "/" + mappletname + ".xml");
      SAXReader reader = new SAXReader();
      reader.setEntityResolver(new MyEntityResolver());
      Document doc = reader.read(f);
      Element root = doc.getRootElement();
      Element repositoryInfo = root.element("REPOSITORY");
      Element folderInfo = repositoryInfo.element("FOLDER");
      List<Element> mappletList = folderInfo.elements("MAPPLET");
      new ArrayList();
      Map<String, String> map = new LinkedHashMap();

      for(int i = 0; i < mappletList.size(); ++i) {
         Element mappletInfo = (Element)mappletList.get(i);
         List<Element> transformationLst = mappletInfo.elements("MAPPINGVARIABLE");
         if (transformationLst.size() > 0) {
            for(int j = 0; j < transformationLst.size(); ++j) {
               Element transformationInfo = (Element)transformationLst.get(j);
               String mpltName = transformationInfo.attributeValue("NAME");
               String rename = "";
               if ("$$key".equals(mpltName)) {
                  rename = "密钥名称";
               }

               if ("$$start".equals(mpltName)) {
                  rename = "起始位置";
               }

               if ("$$end".equals(mpltName)) {
                  rename = "终止位置";
               }

               map.put(mpltName, rename);
            }
         }
      }

      return map;
   }

   @ResponseBody
   @RequestMapping({"/selectWatermarkKey"})
   public List<TCoreWatermarkKeyInfo> selectWatermarkKey(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreWatermarkKeyInfo> list = this.tdataProjectService.selectWatermarkKey();
      return list;
   }
}
