package com.chenyang.nse.bussiness.controller.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/tdatasource"})
public class TdataSourceController {
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private TdataProjectService tdataProjectService;

   @ResponseBody
   @RequestMapping({"/saveHadoopFilePath"})
   public Response<String> saveHadoop(@RequestBody List<Map<String, Object>> list) throws JsonProcessingException {
      new ObjectMapper();
      return RespHelper.<String>successResp();
   }

   @ResponseBody
   @RequestMapping({"/selectHadoop/{id}/{projectid}"})
   public Response<List<ComboboxVO>> selectHadoop(@PathVariable("id") String id) {
      List<ComboboxVO> list = new ArrayList();
      ComboboxVO comboboxVO = new ComboboxVO();
      comboboxVO.setId("11");
      comboboxVO.setDbType("HADOOP");
      comboboxVO.setTid("11");
      comboboxVO.setValue("192.168.2.222");
      comboboxVO.setText("192.168.2.222");
      comboboxVO.setFlag("0");
      comboboxVO.setFilePath("/a/b/c");
      list.add(comboboxVO);
      ComboboxVO cvo = new ComboboxVO();
      cvo.setValue("0");
      cvo.setFilePath("/c/d/f");
      list.add(cvo);
      return RespHelper.<List<ComboboxVO>>successResp(list);
   }

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      model.addAttribute("id", id);
      return "core/dataproject/tdatasource";
   }

   @ResponseBody
   @RequestMapping({"/saveProDataSource"})
   public Response<String> saveProDataSource(@RequestBody TCoreProjectDatasource obj, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataProjectService.saveProDataSource(obj);
      return RespHelper.<String>successResp("success");
   }

   @ResponseBody
   @RequestMapping({"/query"})
   public Response<List<DatasystemProjectdatasourceVO>> queryDatasourceById(@RequestBody DatasystemProjectdatasourceVO vo) {
      List<DatasystemProjectdatasourceVO> list = this.tdataProjectService.queryDatasourceByProjectId(vo.getProject_id());
      return RespHelper.<List<DatasystemProjectdatasourceVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryDataSystemDetail"})
   public Response<DatasystemProjectdatasourceVO> queryDataSystemDetail(@RequestBody DatasystemProjectdatasourceVO vo) {
      List<DatasystemProjectdatasourceVO> list = this.tdataProjectService.queryDataSystemByProjectIdAndDataSystemId(vo.getProject_id(), vo.getDatasystemid());
      if (list != null && list.size() > 0) {
         String password = AesTool.decrypt(((DatasystemProjectdatasourceVO)list.get(0)).getPassword(), "ghca");
         ((DatasystemProjectdatasourceVO)list.get(0)).setPassword(password);
         return RespHelper.<DatasystemProjectdatasourceVO>successResp(list.get(0));
      } else {
         return RespHelper.<DatasystemProjectdatasourceVO>errResp(ErrCode.DATA_NOT_FOUND);
      }
   }

   @ResponseBody
   @RequestMapping({"/queryDB"})
   public Response<List<DatasystemProjectdatasourceVO>> queryDatasourceByProjectId(@RequestBody DatasystemProjectdatasourceVO vo) {
      List<DatasystemProjectdatasourceVO> list = this.tdataProjectService.queryDatasourceById(vo.getProject_id());
      return RespHelper.<List<DatasystemProjectdatasourceVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/deleteProDataSource"})
   public ResultVO deleteProDataSource(@RequestBody TCoreProjectDatasource obj, HttpServletRequest request, HttpServletResponse response, Model model) {
      boolean delDataSource = false;
      delDataSource = this.tdataProjectService.deleteProDataSource(obj);
      return delDataSource ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @ResponseBody
   @RequestMapping({"/selectOneProDataSource"})
   public TCoreDatasystem selectOneProDataSource(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem obj = this.tdataProjectService.selectOneProDataSource(id);
      return obj;
   }

   @ResponseBody
   @RequestMapping({"/selectProDataSource"})
   public Response<List<ComboboxVO>> selectProDataSource(@RequestBody Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      String systemstyle = (String)map.get("systemstyle");
      if ("1".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSource("1");
      } else if ("2".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSource("2");
      } else if ("3".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSource1("3");
      } else if ("4".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSource("4");
      } else if ("5".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSource("5");
      } else if ("6".equals(systemstyle)) {
         ComboboxVO comboboxVO = new ComboboxVO();
         comboboxVO.setId("11");
         comboboxVO.setDbType("HADOOP");
         comboboxVO.setTid("11");
         comboboxVO.setValue("192.168.2.222");
         comboboxVO.setText("192.168.2.222");
         comboboxVO.setFlag("0");
         list.add(comboboxVO);
      }

      ComboboxVO cvo = new ComboboxVO();
      cvo.setValue("0");
      cvo.setText("全部");
      list.add(cvo);
      return RespHelper.<List<ComboboxVO>>successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/selectProDataSourceDet"})
   public List<ComboboxVO> selectProDataSourceDet(String systemstyle, String dbtype, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      if ("1".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSourceDet("1", dbtype);
      } else if ("2".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSourceDet("2", dbtype);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/selectProDataSourceDet1"})
   public List<ComboboxVO> selectProDataSourceDet1(String systemstyle, String dbtype, String versionname, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      if ("3".equals(systemstyle)) {
         list = this.tdataProjectService.selectProDataSourceDet("3", dbtype);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/selectCheckProDataSource"})
   public List<TCoreDatasystem> selectCheckProDataSource(String projectid, String systemstyle, String searchval, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = this.tdataProjectService.selectCheckProDataSource(projectid, systemstyle, searchval);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryByEditSort"})
   public Response<List<DatasystemProjectdatasourceVO>> queryByEditSort(@RequestBody Map<String, Object> map) throws JsonMappingException, JsonProcessingException {
      ObjectMapper objectMapper = new ObjectMapper();
      String jsonInfo = objectMapper.writeValueAsString(map.get("loginUser"));
      LoginUser loginUser = (LoginUser)objectMapper.readValue(jsonInfo, LoginUser.class);
      String dbtype = map.get("dbtype").toString();
      String flag = map.get("flag").toString();
      String projectId = map.get("projectId").toString();
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup() == null ? "" : loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      List<DatasystemProjectdatasourceVO> list = this.tdataProjectService.queryByEditSort(dbtype, flag, userid);
      if (dbtype.equals("HADOOP")) {
         DatasystemProjectdatasourceVO datasystemProjectdatasourceVO = new DatasystemProjectdatasourceVO();
         datasystemProjectdatasourceVO.setDblinkname("192.168.2.173");
         datasystemProjectdatasourceVO.setDbip("192.168.2.173");
         datasystemProjectdatasourceVO.setTid("11");
         datasystemProjectdatasourceVO.setDatasystemid("11");
         datasystemProjectdatasourceVO.setDbservername("11222");
         list.add(datasystemProjectdatasourceVO);
      }

      int p = list.size();

      for(int i = 0; i < p; ++i) {
         Map map1 = (Map)list.get(i);
         String id = (String)map1.get("tid");
         if (null != id && !"".equals(id) && this.dataSystemService.checkUsedByProject(id, projectId)) {
            list.remove(i);
            --p;
            --i;
         }
      }

      return RespHelper.<List<DatasystemProjectdatasourceVO>>successResp(list, list.size());
   }

   @ResponseBody
   @RequestMapping({"/queryAll"})
   public Response<List<DatasystemProjectdatasourceVO>> queryAll(@RequestBody Map<String, Object> map) throws JsonMappingException, JsonProcessingException {
      ObjectMapper objectMapper = new ObjectMapper();
      String jsonInfo = objectMapper.writeValueAsString(map.get("loginUser"));
      LoginUser loginUser = (LoginUser)objectMapper.readValue(jsonInfo, LoginUser.class);
      String dbtype = map.get("dbtype").toString();
      String flag = map.get("flag").toString();
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup() == null ? "" : loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      List<DatasystemProjectdatasourceVO> list = this.tdataProjectService.queryByEditSort(dbtype, flag, userid);
      return RespHelper.<List<DatasystemProjectdatasourceVO>>successResp(list, list.size());
   }

   @ResponseBody
   @RequestMapping({"/saveAllProDataSource"})
   public Response<String> saveAllProDataSource(@RequestBody Map<String, Object> map) throws JsonProcessingException {
      ObjectMapper objectMapper = new ObjectMapper();
      String jsonInfo = objectMapper.writeValueAsString(map.get("loginUser"));
      LoginUser loginUser = (LoginUser)objectMapper.readValue(jsonInfo, LoginUser.class);
      String dbtype = map.get("dbtype").toString();
      String flag = map.get("flag").toString();
      String projectid = map.get("projectid").toString();
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup() == null ? "" : loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      this.tdataProjectService.saveAllProDataSource(dbtype, flag, projectid, userid);
      return RespHelper.<String>successResp();
   }

   @ResponseBody
   @RequestMapping({"/deleteAllProDataSource"})
   public Response<String> deleteAllProDataSource(@RequestBody Map<String, Object> map) throws JsonProcessingException {
      ObjectMapper objectMapper = new ObjectMapper();
      String jsonInfo = objectMapper.writeValueAsString(map.get("loginUser"));
      LoginUser loginUser = (LoginUser)objectMapper.readValue(jsonInfo, LoginUser.class);
      String dbtype = map.get("dbtype").toString();
      String flag = map.get("flag").toString();
      String projectid = map.get("projectid").toString();
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup() == null ? "" : loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      this.tdataProjectService.deleteAllProDataSource(dbtype, flag, projectid, userid);
      return RespHelper.<String>successResp("success");
   }

   @ResponseBody
   @RequestMapping({"/isChooseAll"})
   public String isChooseAll(String dbtype, String flag, String projectid, String searchval, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      String isChooseAll = this.tdataProjectService.isChooseAll(dbtype, flag, projectid, searchval, userid);
      return isChooseAll;
   }
}
