package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreWatermarkKeyInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.WaterMarkService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/watermark"})
public class WaterMarkController {
   @Autowired
   private WaterMarkService waterMarkService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("toPageCurr", 1);
      return "core/watermark/watermarkkeyinfo";
   }

   @RequestMapping({"/generatekey"})
   @ResponseBody
   public String generatekey(HttpServletRequest request, HttpServletResponse response, Model model) {
      String val = "";
      boolean exist = false;

      do {
         val = "";
         Random random = new Random();

         for(int i = 0; i < 10; ++i) {
            val = val + String.valueOf(random.nextInt(10));
         }

         List existKey = this.waterMarkService.isExistKey(val);
         if (existKey.size() > 0) {
            exist = true;
         } else {
            exist = false;
         }
      } while(exist);

      return val;
   }

   @RequestMapping({"/waterMarkInfoSave"})
   public String waterMarkInfoSave(@RequestParam Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      new LoginUser();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String loginusername = loginUser.getTsysUser().getUsername();
      TCoreWatermarkKeyInfo tCoreWatermarkKeyInfo = null;
      String taskid = (String)map.get("keyid");
      if (taskid != null && taskid != "") {
         tCoreWatermarkKeyInfo = (TCoreWatermarkKeyInfo)this.waterMarkService.queryWaterMarkInfobyId(taskid).get(0);
         tCoreWatermarkKeyInfo.setUpdatetime(new Date());
         tCoreWatermarkKeyInfo.setUpdateuser(loginusername);
      } else {
         tCoreWatermarkKeyInfo = new TCoreWatermarkKeyInfo();
         tCoreWatermarkKeyInfo.setCreatetime(new Date());
         tCoreWatermarkKeyInfo.setCreateuser(loginusername);
      }

      tCoreWatermarkKeyInfo.setKeyname((String)map.get("keyname"));
      tCoreWatermarkKeyInfo.setSecretkey((String)map.get("keyval"));
      tCoreWatermarkKeyInfo.setCompany((String)map.get("company"));
      tCoreWatermarkKeyInfo.setCompanyaddress((String)map.get("companyaddress"));
      tCoreWatermarkKeyInfo.setDateowner((String)map.get("dateowner"));
      tCoreWatermarkKeyInfo.setDept((String)map.get("dept"));
      tCoreWatermarkKeyInfo.setTelephoneNum((String)map.get("telephoneNum"));
      tCoreWatermarkKeyInfo.setUsagescenarios((String)map.get("usagescenarios"));
      tCoreWatermarkKeyInfo.setNote((String)map.get("note"));
      List existKeyname = this.waterMarkService.isExistKeyname((String)map.get("keyname"));
      if (existKeyname.size() > 0) {
         model.addAttribute("toPageCurr", 1);
         return "core/watermark/watermarkkeyinfo";
      } else {
         this.waterMarkService.saveWaterMarkInfo(tCoreWatermarkKeyInfo);
         model.addAttribute("toPageCurr", 1);
         return "core/watermark/watermarkkeyinfo";
      }
   }

   @RequestMapping({"/queryWaterMarkInfo"})
   @ResponseBody
   public DataGridVO<TCoreWatermarkKeyInfo> queryWaterMarkInfo(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreWatermarkKeyInfo> list = this.waterMarkService.queryWaterMarkInfo(pageInfo);
      DataGridVO<TCoreWatermarkKeyInfo> vo = new DataGridVO<TCoreWatermarkKeyInfo>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/queryWaterMarkInfobyId"})
   @ResponseBody
   public List<TCoreWatermarkKeyInfo> queryWaterMarkInfobyId(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreWatermarkKeyInfo> list = this.waterMarkService.queryWaterMarkInfobyId(taskid);
      return list;
   }

   @RequestMapping({"/removeinfo"})
   @ResponseBody
   public void removeinfo(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.waterMarkService.delWaterMarkInfobyId(taskid);
   }

   @RequestMapping({"/isrepeatname"})
   @ResponseBody
   public boolean isrepeatname(String keyval, HttpServletRequest request, HttpServletResponse response) {
      if (keyval != null && !"".equals(keyval)) {
         List existKey = this.waterMarkService.isExistKey(keyval);
         return existKey.size() <= 0;
      } else {
         return true;
      }
   }

   @RequestMapping({"/isexistkeyname"})
   @ResponseBody
   public boolean isexistkeyname(String keyname, HttpServletRequest request, HttpServletResponse response) {
      if (keyname != null && !"".equals(keyname)) {
         List existKeyname = this.waterMarkService.isExistKeyname(keyname);
         return existKeyname.size() <= 0;
      } else {
         return true;
      }
   }

   @RequestMapping({"/getKeyInfoByValues"})
   @ResponseBody
   public List<TCoreWatermarkKeyInfo> getKeyInfoByValues(String textval, HttpServletRequest request, HttpServletResponse response) {
      List<TCoreWatermarkKeyInfo> relist = new ArrayList();
      if ("".equals(textval)) {
         return relist;
      } else {
         List<Map<String, String>> list = this.waterMarkService.getMatchingInfo(textval);
         if (list.size() > 0) {
            Map<String, String> similarmap = (Map)list.get(0);
            Map<String, String> matchmap = (Map)list.get(1);

            for(String key : similarmap.keySet()) {
               TCoreWatermarkKeyInfo tCoreWatermarkKeyInfo = (TCoreWatermarkKeyInfo)this.waterMarkService.isExistKey(key).get(0);
               tCoreWatermarkKeyInfo.setSimilar((String)similarmap.get(key));
               tCoreWatermarkKeyInfo.setMatchstr((String)matchmap.get(key));
               relist.add(tCoreWatermarkKeyInfo);
            }
         }

         return relist;
      }
   }
}
