package com.chenyang.nse.bussiness.controller.core.config;

import com.chenyang.nse.bussiness.interceptor.AuthenticationInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebMvcConfig extends WebMvcConfigurerAdapter {
   public void addInterceptors(InterceptorRegistry registry) {
      registry.addInterceptor(new AuthenticationInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/core/compliancedirectory/downloadfile"}).excludePathPatterns(new String[]{"/core/fieldreportform/downloadfile"});
   }

   public void addCorsMappings(CorsRegistry registry) {
      registry.addMapping("/**").allowedMethods(new String[]{"POST", "GET", "PUT", "OPTIONS", "DELETE"}).maxAge(3600L).allowCredentials(true).allowedOriginPatterns(new String[]{"*"});
   }
}
